/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class FastStftEngine
implements IHasSerialSections {
    private static final String ANALYZER_SECTION_NAME = "FastStftEngine.analyzer";
    private static final String SYNTHESIZER_SECTION_NAME = "FastStftEngine.synthesizer";
    private final int numHops;
    private final int blockSize;
    private final int hopSize;
    private final int overlapFactor;
    private final int olaSize;
    private final int nbBins;
    private Buffer inBuffer;
    private float[][] inputBlocks;
    private BooFFT fft;
    private Cmplx[][] spectrums;
    private float correction;
    private final boolean synthesisWindow;
    private float[][] outBlocks;
    private Buffer olaBuffer;
    private ISerialSection analyzerSection = new DummySerialSection();
    private ISerialSection synthesizerSection = new DummySerialSection();

    public FastStftEngine(int numHops, int blockSize, int overlapFactor, boolean synthesisWindow) {
        int minOverlap;
        this.numHops = numHops;
        this.overlapFactor = overlapFactor;
        int n = minOverlap = synthesisWindow ? 4 : 2;
        if (overlapFactor < minOverlap || (overlapFactor & overlapFactor - 1) != 0) {
            throw new IllegalArgumentException("overlapFactor must be a power of two >= " + minOverlap);
        }
        this.blockSize = blockSize;
        this.hopSize = blockSize / overlapFactor;
        if ((this.hopSize & this.hopSize - 1) != 0) {
            throw new IllegalArgumentException("blockSize / overlapFactor must be a power of 2");
        }
        this.olaSize = blockSize - this.hopSize;
        this.nbBins = blockSize / 2 + 1;
        this.synthesisWindow = synthesisWindow;
    }

    public void init() {
        this.inputBlocks = new float[this.numHops][this.blockSize];
        this.fft = BooFFT.getInstance((int)(this.blockSize / 2));
        this.spectrums = Cmplx.newArray((int)this.numHops, (int)this.nbBins);
        this.correction = Windows.getHannCorrection((int)this.overlapFactor, (int)(this.synthesisWindow ? 2 : 1));
        this.outBlocks = new float[this.numHops][this.blockSize];
    }

    public Cmplx[][] analyze(float[] input) {
        int hop;
        if (input.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize " + this.hopSize);
        }
        this.analyzerSection.enterSerialSection();
        try {
            hop = 0;
            while (hop < this.numHops) {
                System.arraycopy(input, this.hopSize * hop, this.inBuffer.buffer, this.inBuffer.index, this.hopSize);
                this.inBuffer.index = (this.inBuffer.index + this.hopSize) % this.blockSize;
                int i = 0;
                while (i < this.blockSize) {
                    this.inputBlocks[hop][i] = this.inBuffer.buffer[(i + this.inBuffer.index) % this.blockSize];
                    ++i;
                }
                ++hop;
            }
        }
        finally {
            this.analyzerSection.leaveSerialSection();
        }
        hop = 0;
        while (hop < this.numHops) {
            this.fft.forwR2C(this.inputBlocks[hop], this.spectrums[hop]);
            Windows.convolve2((Cmplx[])this.spectrums[hop], (float)Windows.HannCoefs[0], (float)Windows.HannCoefs[1]);
            ++hop;
        }
        return this.spectrums;
    }

    public void synthesize(float[] output) {
        if (output.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize " + this.hopSize);
        }
        int hop = 0;
        while (hop < this.numHops) {
            if (this.synthesisWindow) {
                Windows.convolve2((Cmplx[])this.spectrums[hop], (float)Windows.HannCoefs[0], (float)Windows.HannCoefs[1]);
            }
            this.fft.backC2R(this.spectrums[hop], this.outBlocks[hop]);
            ++hop;
        }
        this.synthesizerSection.enterSerialSection();
        try {
            hop = 0;
            while (hop < this.numHops) {
                int i = 0;
                while (i < this.hopSize) {
                    output[this.hopSize * hop + i] = (this.olaBuffer.buffer[(i + this.olaBuffer.index) % this.olaSize] + this.outBlocks[hop][i]) * this.correction;
                    ++i;
                }
                this.olaBuffer.index = (this.olaBuffer.index + this.hopSize) % this.olaSize;
                i = 0;
                while (i < this.olaSize - this.hopSize) {
                    int n = (i + this.olaBuffer.index) % this.olaSize;
                    this.olaBuffer.buffer[n] = this.olaBuffer.buffer[n] + this.outBlocks[hop][i + this.hopSize];
                    ++i;
                }
                i = this.olaSize - this.hopSize;
                while (i < this.olaSize) {
                    this.olaBuffer.buffer[(i + this.olaBuffer.index) % this.olaSize] = this.outBlocks[hop][i + this.hopSize];
                    ++i;
                }
                ++hop;
            }
        }
        finally {
            this.synthesizerSection.leaveSerialSection();
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getInputSize() {
        return this.hopSize * this.numHops;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getNbBins() {
        return this.blockSize / 2 + 1;
    }

    public int getLatency() {
        return this.blockSize - this.hopSize;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.inBuffer = new Buffer(this.blockSize);
        this.olaBuffer = new Buffer(this.blockSize);
        this.analyzerSection = factory.createSerialSection(ANALYZER_SECTION_NAME, (Object)this.inBuffer);
        this.synthesizerSection = factory.createSerialSection(SYNTHESIZER_SECTION_NAME, (Object)this.olaBuffer);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzerSection = pool.getSerialSection(ANALYZER_SECTION_NAME);
        this.synthesizerSection = pool.getSerialSection(SYNTHESIZER_SECTION_NAME);
        this.inBuffer = (Buffer)this.analyzerSection.getUserData();
        this.olaBuffer = (Buffer)this.synthesizerSection.getUserData();
    }

    static class Buffer {
        public final float[] buffer;
        public int index;

        public Buffer(int size) {
            this.buffer = new float[size];
        }
    }
}

