/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.base.stft.StftBufferArr;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialAccu;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialAccumulator;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.math.Cmplx;

public class StftAnalyzerAccu
implements IHasSerialSections {
    private static final String SECTION_NAME = "ch.tachyon.sonics.stft.analyzer";
    private final int blockSize;
    private final int hopSize;
    private final int numHops;
    private final int overlap;
    private int numHistoryBuffers;
    private StftBufferArr inBuffers;
    private final float[] analysisWindow;
    private BooFFT fft;
    private Cmplx[][] spectrums;
    private float[] processBuffer;
    private ISerialAccumulator<float[]> sa = new DummySerialAccu();
    private transient long currentClock;

    public StftAnalyzerAccu(int blockSize, int hopSize, int numHops, float[] analysisWindow) {
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.numHops = numHops;
        this.overlap = (blockSize + hopSize - 1) / hopSize;
        this.numHistoryBuffers = 1 + (this.overlap + numHops - 1) / numHops;
        this.analysisWindow = analysisWindow;
    }

    public void init() {
        this.fft = BooFFT.getInstance((int)(this.blockSize / 2));
        int nbBins = this.blockSize / 2 + 1;
        this.spectrums = Cmplx.newArray((int)this.numHops, (int)nbBins);
        this.processBuffer = new float[this.blockSize];
    }

    public int pushNextInput(float[] input) {
        float[] nextInput = (float[])this.sa.enterNext((Object)input);
        if (nextInput != null) {
            this.currentClock = this.sa.getCurrentClock();
            int baseIndex = this.pushInput0(nextInput, this.currentClock);
            this.sa.leaveNext();
            return baseIndex;
        }
        return -1;
    }

    public long getMyClock() {
        return this.sa.getMyClock();
    }

    public long getCurrentClock() {
        return this.currentClock;
    }

    public Cmplx[][] analyze(int baseIndex) {
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            this.fetchInputBlock(baseIndex, hopIndex);
            this.applyAnalysisWindow();
            this.forwardFFT(this.spectrums[hopIndex]);
            ++hopIndex;
        }
        return this.spectrums;
    }

    private int pushInput0(float[] input, long clock) {
        int index = (int)(clock % (long)this.numHistoryBuffers);
        this.inBuffers.buffers[index] = input;
        return index;
    }

    private void fetchInputBlock(int baseIndex, int hopIndex) {
        int backwardOffset = this.overlap - 1 - hopIndex;
        baseIndex = (baseIndex + this.numHistoryBuffers - (backwardOffset + this.numHops - 1) / this.numHops) % this.numHistoryBuffers;
        int offset = (this.numHops - backwardOffset % this.numHops) % this.numHops * this.hopSize;
        int dst = 0;
        int k = 0;
        while (k < this.overlap) {
            int i;
            float[] historyBuffer = this.inBuffers.buffers[baseIndex];
            if (historyBuffer != null) {
                i = 0;
                while (i < this.hopSize) {
                    this.processBuffer[dst++] = historyBuffer[i + offset];
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.hopSize) {
                    this.processBuffer[dst++] = 0.0f;
                    ++i;
                }
            }
            if ((offset += this.hopSize) >= this.hopSize * this.numHops) {
                baseIndex = (baseIndex + 1) % this.numHistoryBuffers;
                offset = 0;
            }
            ++k;
        }
    }

    private void applyAnalysisWindow() {
        int i = 0;
        while (i < this.blockSize) {
            int n = i;
            this.processBuffer[n] = this.processBuffer[n] * this.analysisWindow[i];
            ++i;
        }
    }

    private void forwardFFT(Cmplx[] spectrum) {
        this.fft.forwR2C(this.processBuffer, spectrum);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getNumHops() {
        return this.numHops;
    }

    public int getInputSize() {
        return this.hopSize * this.numHops;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public int getNbBins() {
        return this.blockSize / 2 + 1;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        assert (this.inBuffers == null);
        this.numHistoryBuffers = factory.getMtContext().getAccuRunningMaxSkew(3) + (this.overlap + this.numHops - 1) / this.numHops;
        this.inBuffers = new StftBufferArr(this.hopSize, this.numHistoryBuffers, false);
        this.sa = factory.createSerialAccumulator(float[].class, SECTION_NAME, (Object)this.inBuffers, 0.6f);
        factory.ensureMinInputHistorySize(this.overlap);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.numHistoryBuffers = pool.getMtContext().getAccuRunningMaxSkew(3) + (this.overlap + this.numHops - 1) / this.numHops;
        this.sa = pool.getSerialAccu(SECTION_NAME, float[].class);
        this.inBuffers = (StftBufferArr)this.sa.getUserData();
    }
}

