/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.base.stft.old.StftBufferOld;
import ch.tachyon.tunnel.utils.numa.ThreadPool0;
import java.util.Map;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.math.Cmplx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StftAnalyzerNuma {
    private static final String DATA_NAME = "ch.tachyon.sonics.stft.analyzer";
    protected final int blockSize;
    protected final int hopSize;
    protected final int olaSize;
    protected final int overlap;
    protected final int numHops;
    protected StftBufferOld inBuffers;
    protected final float[] analysisWindow;
    protected final BooFFT fft;
    protected final Cmplx[] spectrum;
    protected final float[] processBuffer;
    private transient float[] input;
    private transient int baseIndex;

    public StftAnalyzerNuma(int blockSize, int hopSize, float[] analysisWindow) {
        this(blockSize, hopSize, analysisWindow, BooFFT.getPrivateInstance((int)(blockSize / 2)), new float[blockSize]);
    }

    protected StftAnalyzerNuma(int blockSize, int hopSize, float[] analysisWindow, BooFFT fft, float[] processBuffer) {
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.olaSize = blockSize - hopSize;
        this.overlap = (blockSize + hopSize - 1) / hopSize;
        this.numHops = ThreadPool0.getMaxSkew() + this.overlap;
        int nbBins = blockSize / 2 + 1;
        this.analysisWindow = analysisWindow;
        this.inBuffers = new StftBufferOld(hopSize, this.numHops, false);
        this.fft = fft;
        this.spectrum = Cmplx.newArray((int)nbBins);
        this.processBuffer = processBuffer;
    }

    public void setInput(float[] input) {
        this.input = input;
    }

    public Cmplx[] getSpectrum() {
        return this.spectrum;
    }

    public void pushInput() {
        this.inBuffers.buffers[this.inBuffers.index] = this.input;
        this.baseIndex = this.inBuffers.index;
        this.inBuffers.index = (this.inBuffers.index + 1) % this.numHops;
    }

    public void fetchInputBlock() {
        this.input = null;
        this.baseIndex = (this.baseIndex + this.numHops - this.overlap + 1) % this.numHops;
        int dst = 0;
        int k = 0;
        while (k < this.overlap) {
            float[] hopBuffer = this.inBuffers.buffers[this.baseIndex];
            this.baseIndex = (this.baseIndex + 1) % this.numHops;
            if (hopBuffer != null) {
                int i = 0;
                while (i < this.hopSize) {
                    this.processBuffer[dst++] = hopBuffer[i];
                    ++i;
                }
            }
            ++k;
        }
    }

    public void applyAnalysisWindow() {
        int i = 0;
        while (i < this.blockSize) {
            int n = i;
            this.processBuffer[n] = this.processBuffer[n] * this.analysisWindow[i];
            ++i;
        }
    }

    public void forwardFFT() {
        this.fft.forwR2C(this.processBuffer, this.spectrum);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public int getNbBins() {
        return this.spectrum.length;
    }

    public void setupCommonData(Map<String, Object> data) {
        if (data.containsKey(DATA_NAME)) {
            this.inBuffers = (StftBufferOld)data.get(DATA_NAME);
        } else {
            data.put(DATA_NAME, this.inBuffers);
        }
    }
}

