/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.stft.StftAnalyzerMulti;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizerMulti;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPullEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import org.corebounce.common.math.Cmplx;

public abstract class StftPullEffectBase
extends EffectBase
implements IPullEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private int blockSizeLog = 10;
    private int overlapInLog = 3;
    private int overlapOutLog = 3;
    private float[] analysisWindow;
    private float[] synthesisWindow;
    protected StftAnalyzerMulti analyzer;
    protected StftSynthesizerMulti synthesizer;
    protected float[] input;

    protected StftPullEffectBase() {
    }

    protected StftPullEffectBase(int blockSizeLog, int overlapLog) {
        this.blockSizeLog = blockSizeLog;
        this.overlapInLog = overlapLog;
    }

    protected int getBlockSizeLog() {
        return this.blockSizeLog;
    }

    protected void setBlockSizeLog(int blockSizeLog) {
        this.blockSizeLog = blockSizeLog;
    }

    protected int getOverlapLog() {
        return this.overlapInLog;
    }

    protected void setOverlapLog(int overlapLog) {
        this.setOverlapInLog(overlapLog);
        this.setOverlapOutLog(overlapLog);
    }

    protected int getOverlapInLog() {
        return this.overlapInLog;
    }

    protected void setOverlapInLog(int overlapInLog) {
        this.overlapInLog = overlapInLog;
    }

    protected int getOverlapOutLog() {
        return this.overlapOutLog;
    }

    protected void setOverlapOutLog(int overlapOutLog) {
        this.overlapOutLog = overlapOutLog;
    }

    protected float[] getAnalysisWindow() {
        return this.analysisWindow;
    }

    protected void setAnalysisWindow(float[] analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    protected float[] getSynthesisWindow() {
        return this.synthesisWindow;
    }

    protected void setSynthesisWindow(float[] synthesisWindow) {
        this.synthesisWindow = synthesisWindow;
    }

    public boolean canWriteFasterThanRead() {
        return false;
    }

    public void startProcessing(IProcessingInfo info) {
        int blockSize = 1 << this.getBlockSizeLog();
        int overlapIn = 1 << this.getOverlapInLog();
        int overlapOut = 1 << this.getOverlapOutLog();
        if (this.analysisWindow == null) {
            this.analysisWindow = WindowsFactory.getHannWindow(blockSize);
        }
        if (this.synthesisWindow == null) {
            if (this.overlapInLog <= 1) {
                this.synthesisWindow = new float[blockSize];
                Arrays.fill(this.synthesisWindow, 1.0f);
            } else {
                this.synthesisWindow = WindowsFactory.getHannWindow(blockSize);
            }
        }
        int inHopSize = blockSize / overlapIn;
        int numHops = 1;
        int chunkLength = info.getHostPreferredChunkLength();
        if (chunkLength > 0 && (numHops = chunkLength / inHopSize) < 1) {
            numHops = 1;
        }
        info.negociateFixedChunkLength(inHopSize * numHops);
        int outHopSize = blockSize / overlapOut;
        this.analyzer = new StftAnalyzerMulti(blockSize, inHopSize, numHops, this.analysisWindow, true);
        this.synthesizer = new StftSynthesizerMulti(blockSize, outHopSize, numHops, this.analysisWindow, this.synthesisWindow);
        this.input = new float[this.analyzer.getInputSize()];
    }

    public int getFixedChunkLength() {
        return this.analyzer.getInputSize();
    }

    public int getLatency(IoDirection ioDirection) {
        return this.synthesizer.getLatency();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.analyzer.init();
        this.synthesizer.init();
    }

    public int process(ISingleChanAudioSource source, float[] output) {
        Cmplx[][] spectrums;
        int length = source.readSamples(this.input);
        if (length == 0) {
            return 0;
        }
        Cmplx[][] cmplxArray = spectrums = this.analyzer.analyze(this.input);
        int n = spectrums.length;
        int n2 = 0;
        while (n2 < n) {
            Cmplx[] spectrum = cmplxArray[n2];
            this.processSpectrum(spectrum);
            ++n2;
        }
        this.synthesizer.synthesize(spectrums, output);
        if (length == this.input.length) {
            return length;
        }
        return length * output.length / this.input.length;
    }

    protected abstract void processSpectrum(Cmplx[] var1);

    public void stopProcessing() {
        this.analyzer = null;
        this.synthesizer = null;
        this.input = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
    }
}

