/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.stft.StftAnalyzerMulti;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizerMulti;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.sonics.effect.base.stft.old.StftAnalyzerAccu;
import ch.tachyon.sonics.effect.base.stft.old.StftSynthesizerAccu;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.IDisposable;

public abstract class StftPushEffectBase
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private int blockSizeLog = 10;
    private int overlapInLog = 3;
    private int overlapOutLog = 3;
    private float[] analysisWindow;
    private float[] modifiedWindow;
    private float[] synthesisWindow;
    private float shrinkEnergyCorrection = 1.0f;
    private boolean accuMode = false;
    private AbstractStftEngine engine;

    protected StftPushEffectBase() {
    }

    protected StftPushEffectBase(int blockSizeLog, int overlapLog) {
        this.blockSizeLog = blockSizeLog;
        this.overlapInLog = overlapLog;
    }

    protected int getBlockSizeLog() {
        return this.blockSizeLog;
    }

    protected void setBlockSizeLog(int blockSizeLog) {
        this.blockSizeLog = blockSizeLog;
    }

    protected int getOverlapLog() {
        return this.overlapInLog;
    }

    protected void setOverlapLog(int overlapLog) {
        this.setOverlapInLog(overlapLog);
        this.setOverlapOutLog(overlapLog);
    }

    protected int getOverlapInLog() {
        return this.overlapInLog;
    }

    protected void setOverlapInLog(int overlapInLog) {
        this.overlapInLog = overlapInLog;
    }

    protected int getOverlapOutLog() {
        return this.overlapOutLog;
    }

    protected void setOverlapOutLog(int overlapOutLog) {
        this.overlapOutLog = overlapOutLog;
    }

    protected float[] getAnalysisWindow() {
        return this.analysisWindow;
    }

    protected void setAnalysisWindow(float[] analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    protected float[] getModifiedWindow() {
        return this.modifiedWindow;
    }

    protected void setModifiedWindow(float[] modifiedWindow) {
        this.modifiedWindow = modifiedWindow;
    }

    protected float[] getSynthesisWindow() {
        return this.synthesisWindow;
    }

    protected void setSynthesisWindow(float[] synthesisWindow) {
        this.synthesisWindow = synthesisWindow;
    }

    protected float getShrinkEnergyCorrection() {
        return this.shrinkEnergyCorrection;
    }

    protected void setShrinkEnergyCorrection(float shrinkEnergyCorrection) {
        this.shrinkEnergyCorrection = shrinkEnergyCorrection;
    }

    protected boolean isAccuMode() {
        return this.accuMode;
    }

    protected void setAccuMode(boolean accuMode) {
        this.accuMode = accuMode;
    }

    public boolean canWriteFasterThanRead() {
        return false;
    }

    public void startProcessing(IProcessingInfo info) {
        int blockSize = 1 << this.getBlockSizeLog();
        int overlapIn = 1 << this.getOverlapInLog();
        int overlapOut = 1 << this.getOverlapOutLog();
        if (this.analysisWindow == null) {
            this.analysisWindow = WindowsFactory.getHannWindow(blockSize);
            if (this.synthesisWindow == null) {
                this.synthesisWindow = this.analysisWindow;
            }
        }
        if (this.synthesisWindow == null) {
            this.synthesisWindow = WindowsFactory.getHannWindow(blockSize);
        }
        if (this.modifiedWindow == null) {
            this.modifiedWindow = this.analysisWindow;
        }
        int inHopSize = blockSize / overlapIn;
        int numHops = 1;
        int chunkLength = info.getHostPreferredChunkLength();
        if (chunkLength > 0 && (numHops = chunkLength / inHopSize) < 1) {
            numHops = 1;
        }
        info.negociateFixedChunkLength(inHopSize * numHops);
        int outHopSize = blockSize / overlapOut;
        this.engine = this.accuMode ? this.newAccuStftEngine() : this.newParallelStftEngine();
        this.engine.createEngine(blockSize, inHopSize, outHopSize, numHops, this.analysisWindow, this.modifiedWindow, this.synthesisWindow, this.shrinkEnergyCorrection);
    }

    protected AbstractStftEngine newAccuStftEngine() {
        return new AccuStftEngine();
    }

    protected AbstractStftEngine newParallelStftEngine() {
        return new ParallelStftEngine();
    }

    public int getFixedChunkLength() {
        return this.engine.getFixedChunkLength();
    }

    public int getLatency(IoDirection ioDirection) {
        return this.engine.getLatency(ioDirection);
    }

    public void beginProcessing(IProcessingInfo info) {
        if (this.engine == null) {
            throw new IllegalStateException("Stft engine not created. Maybe you overrided startProcessing() and forgot to invoke the super's method !?");
        }
        this.engine.initEngine();
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        this.engine.process(input, length, target);
    }

    protected abstract void processSpectrum(Cmplx[] var1);

    public void stopProcessing() {
        this.engine.dispose();
        this.engine = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engine.setSerialSections(pool);
    }

    protected abstract class AbstractStftEngine
    implements IHasSerialSections,
    IDisposable,
    IFixedChunkLength,
    ILatency {
        protected AbstractStftEngine() {
        }

        protected abstract void createEngine(int var1, int var2, int var3, int var4, float[] var5, float[] var6, float[] var7, float var8);

        protected abstract void initEngine();

        protected abstract void process(float[] var1, int var2, ISingleChanAudioSink var3);
    }

    protected class AccuStftEngine
    extends AbstractStftEngine {
        protected StftAnalyzerAccu analyzer = null;
        protected StftSynthesizerAccu synthesizer = null;

        protected AccuStftEngine() {
        }

        protected void createEngine(int blockSize, int inHopSize, int outHopSize, int numHops, float[] analysisWindow, float[] modifiedWindow, float[] synthesisWindow, float shrinkEnergyCorrection) {
            this.analyzer = new StftAnalyzerAccu(blockSize, inHopSize, numHops, analysisWindow);
            this.synthesizer = new StftSynthesizerAccu(blockSize, outHopSize, numHops, modifiedWindow, synthesisWindow);
        }

        public int getLatency(IoDirection ioDirection) {
            return this.synthesizer.getLatency();
        }

        public int getFixedChunkLength() {
            return this.analyzer.getInputSize();
        }

        public void createSerialSections(ISerialSectionFactory factory) {
            this.analyzer.createSerialSections(factory);
            this.synthesizer.createSerialSections(factory);
        }

        public void setSerialSections(ISerialSectionPool pool) {
            this.analyzer.setSerialSections(pool);
            this.synthesizer.setSerialSections(pool);
        }

        protected void initEngine() {
            this.analyzer.init();
            this.synthesizer.init();
        }

        protected void process(float[] input, int length, ISingleChanAudioSink target) {
            if (length < input.length) {
                this.synthesizer.setLastBufferInfo(length, this.analyzer.getMyClock());
            }
            int baseIndex = this.analyzer.pushNextInput(input);
            while (baseIndex >= 0) {
                Cmplx[][] spectrums;
                Cmplx[][] cmplxArray = spectrums = this.analyzer.analyze(baseIndex);
                int n = spectrums.length;
                int n2 = 0;
                while (n2 < n) {
                    Cmplx[] spectrum = cmplxArray[n2];
                    StftPushEffectBase.this.processSpectrum(spectrum);
                    ++n2;
                }
                this.synthesizer.backwardStft(this.analyzer.getCurrentClock(), spectrums);
                float[] output = this.synthesizer.overlapAddNext(this.analyzer.getCurrentClock(), this.analyzer.getCurrentClock());
                while (output != null) {
                    this.synthesizer.writeOutput(output, target);
                    output = this.synthesizer.overlapAddNext(this.analyzer.getCurrentClock(), null);
                }
                baseIndex = this.analyzer.pushNextInput(null);
            }
        }

        public void dispose() {
            this.analyzer = null;
            this.synthesizer = null;
        }
    }

    protected class ParallelStftEngine
    extends AbstractStftEngine {
        protected StftAnalyzerMulti analyzer;
        protected StftSynthesizerMulti synthesizer;
        protected float[] output;

        protected ParallelStftEngine() {
        }

        protected void createEngine(int blockSize, int inHopSize, int outHopSize, int numHops, float[] analysisWindow, float[] modifiedWindow, float[] synthesisWindow, float shrinkEnergyCorrection) {
            this.analyzer = new StftAnalyzerMulti(blockSize, inHopSize, numHops, analysisWindow, false);
            this.synthesizer = new StftSynthesizerMulti(blockSize, outHopSize, numHops, modifiedWindow, synthesisWindow, shrinkEnergyCorrection, true);
            this.output = new float[this.synthesizer.getOutputSize()];
        }

        public int getLatency(IoDirection ioDirection) {
            return this.synthesizer.getLatency();
        }

        public int getFixedChunkLength() {
            return this.analyzer.getInputSize();
        }

        public void createSerialSections(ISerialSectionFactory factory) {
            this.analyzer.createSerialSections(factory);
            this.synthesizer.createSerialSections(factory);
        }

        public void setSerialSections(ISerialSectionPool pool) {
            this.analyzer.setSerialSections(pool);
            this.synthesizer.setSerialSections(pool);
        }

        protected void initEngine() {
            this.analyzer.init();
            this.synthesizer.init();
        }

        protected void process(float[] input, int length, ISingleChanAudioSink target) {
            Cmplx[][] spectrums;
            Cmplx[][] cmplxArray = spectrums = this.analyzer.analyze(input);
            int n = spectrums.length;
            int n2 = 0;
            while (n2 < n) {
                Cmplx[] spectrum = cmplxArray[n2];
                StftPushEffectBase.this.processSpectrum(spectrum);
                ++n2;
            }
            this.synthesizer.synthesize(spectrums, this.output);
            if (length == input.length) {
                target.writeSamples(this.output);
            } else {
                float[] lastOutput = new float[length * this.output.length / input.length];
                System.arraycopy(this.output, 0, lastOutput, 0, lastOutput.length);
                target.writeSamples(lastOutput);
            }
        }

        public void dispose() {
            this.analyzer = null;
            this.synthesizer = null;
            this.output = null;
        }
    }
}

