/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.base.stft.StftBufferArr;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialAccu;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialAccumulator;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.utils.Debug;
import java.util.concurrent.atomic.AtomicLong;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class StftSynthesizerAccu
implements IHasSerialSections {
    private static final String SECTION_NAME = "ch.tachyon.sonics.stft.synthesizer";
    private static final String SECTION_WRITER_NAME = "ch.tachyon.sonics.stft.writer";
    protected final int blockSize;
    protected final int hopSize;
    protected final int numHops;
    protected final int olaSize;
    protected final int overlap;
    protected final float[] analysisWindow;
    protected final float[] synthesisWindow;
    protected float[] invWindow;
    protected BooFFT fft;
    protected int numSections;
    protected int accuSkew;
    protected StftBufferArr olaBuffers;
    private float[][] outputs;
    private AtomicLong outputIndex;
    protected ISerialAccumulator<Long> sa = new DummySerialAccu();
    private Long nextClock;
    protected ISerialAccumulator<float[]> saw = new DummySerialAccu();

    public StftSynthesizerAccu(int blockSize, int hopSize, int numHops, float[] analysisWindow, float[] synthesisWindow) {
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.numHops = numHops;
        this.olaSize = blockSize - hopSize;
        this.overlap = (blockSize + hopSize - 1) / hopSize;
        this.numSections = numHops + this.overlap;
        this.analysisWindow = analysisWindow;
        this.synthesisWindow = synthesisWindow;
    }

    public void init() {
        this.fft = BooFFT.getInstance((int)(this.blockSize / 2));
        this.invWindow = new float[this.hopSize];
        boolean result = Windows.fillInverseWindow((float[])this.analysisWindow, (float[])this.synthesisWindow, (float[])this.invWindow, (int)this.blockSize, (int)this.hopSize);
        if (!result) {
            Debug.warn((String)"Cannot create inverse window", (Object[])new Object[0]);
        }
        this.outputs = new float[this.accuSkew][this.getOutputSize()];
        this.outputIndex = new AtomicLong();
    }

    public void backwardStft(long clock, Cmplx[][] spectrums) {
        int outputIndex;
        int runIndex = outputIndex = (int)(clock * (long)this.numHops % (long)this.numSections);
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            float[] outputBlock = this.olaBuffers.buffers[runIndex];
            this.backwardFFT(spectrums[hopIndex], outputBlock);
            this.applySynthesisWindow(outputBlock);
            runIndex = (runIndex + 1) % this.numSections;
            ++hopIndex;
        }
    }

    public float[] overlapAddNext(Long clock, Long work) {
        int oIndex = (int)(this.outputIndex.getAndIncrement() % (long)this.outputs.length);
        float[] output = this.outputs[oIndex];
        if (output.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize * numHops " + this.hopSize * this.numHops);
        }
        this.nextClock = (Long)this.sa.enterNext(clock.longValue(), (Object)work);
        if (this.nextClock == null) {
            return null;
        }
        this.sa.leaveNext();
        int outputIndex = (int)(this.nextClock * (long)this.numHops % (long)this.numSections);
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            this.overlapAdd(output, outputIndex, hopIndex);
            outputIndex = (outputIndex + 1) % this.numSections;
            ++hopIndex;
        }
        return output;
    }

    public void setLastBufferInfo(int lastLength, long lastClock) {
        this.olaBuffers.lastClock = lastClock;
        this.olaBuffers.lastLength = lastLength;
    }

    public void writeOutput(float[] output, ISingleChanAudioSink sink) {
        float[] nextOutput = (float[])this.saw.enterNext(this.nextClock.longValue(), (Object)output);
        while (nextOutput != null) {
            if (this.saw.getCurrentClock() == this.olaBuffers.lastClock) {
                float[] temp = new float[this.olaBuffers.lastLength];
                System.arraycopy(nextOutput, 0, temp, 0, this.olaBuffers.lastLength);
                nextOutput = temp;
            }
            try {
                sink.writeSamples(nextOutput);
            }
            finally {
                this.saw.leaveNext();
            }
            nextOutput = (float[])this.saw.enterNext(this.nextClock.longValue(), null);
        }
    }

    protected void backwardFFT(Cmplx[] spectrum, float[] output) {
        this.fft.backC2R(spectrum, output);
    }

    private void applySynthesisWindow(float[] output) {
        if (this.synthesisWindow != null) {
            int i = 0;
            while (i < output.length) {
                int n = i;
                output[n] = output[n] * this.synthesisWindow[i];
                ++i;
            }
        }
    }

    private void overlapAdd(float[] output, int outputIndex, int hopIndex) {
        int outputOffset = this.hopSize * hopIndex;
        int shift = this.overlap - 1;
        int bufferIndex = (outputIndex + this.numSections - shift) % this.numSections;
        int bufferOffset = shift * this.hopSize;
        float[] block = this.olaBuffers.buffers[bufferIndex];
        int i = 0;
        while (i < this.hopSize) {
            output[outputOffset + i] = block[bufferOffset + i];
            ++i;
        }
        int k = 1;
        while (k < this.overlap) {
            int shift2 = this.overlap - k - 1;
            int bufferIndex2 = (outputIndex + this.numSections - shift2) % this.numSections;
            int bufferOffset2 = shift2 * this.hopSize;
            float[] block2 = this.olaBuffers.buffers[bufferIndex2];
            int i2 = 0;
            while (i2 < this.hopSize) {
                int n = outputOffset + i2;
                output[n] = output[n] + block2[bufferOffset2 + i2];
                ++i2;
            }
            ++k;
        }
        int i3 = 0;
        while (i3 < this.hopSize) {
            int n = outputOffset + i3;
            output[n] = output[n] * this.invWindow[i3];
            ++i3;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getNumHops() {
        return this.numHops;
    }

    public int getOutputSize() {
        return this.hopSize * this.numHops;
    }

    public int getLatency() {
        return this.blockSize - this.hopSize;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        assert (this.olaBuffers == null);
        this.numSections = factory.getMtContext().getAccuRunningMaxSkew(3) * this.numHops + this.overlap;
        this.accuSkew = factory.getMtContext().getAccuRunningMaxSkew(3);
        this.olaBuffers = new StftBufferArr(this.blockSize, this.numSections, true);
        this.sa = factory.createSerialAccumulator(Long.class, SECTION_NAME, (Object)this.olaBuffers, 2.0f);
        this.saw = factory.createSerialAccumulator(float[].class, SECTION_WRITER_NAME, null, 0.4f);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.numSections = pool.getMtContext().getAccuRunningMaxSkew(3) * this.numHops + this.overlap;
        this.accuSkew = pool.getMtContext().getAccuRunningMaxSkew(3);
        this.sa = pool.getSerialAccu(SECTION_NAME, Long.class);
        this.olaBuffers = (StftBufferArr)this.sa.getUserData();
        this.saw = pool.getSerialAccu(SECTION_WRITER_NAME, float[].class);
    }
}

