/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.base.stft.old.StftBuffer;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.utils.Debug;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class StftSynthesizerMem
implements IHasSerialSections {
    protected final int blockSize;
    protected final int hopSize;
    protected final int olaSize;
    protected final int overlap;
    protected final int historySize;
    protected final float[] synthesisWindow;
    protected final float[] invWindow;
    protected final BooFFT fft;
    protected final float[] processBuffer;
    protected StftBuffer olaBuffer;
    protected ISerialSection ss = new DummySerialSection();

    public StftSynthesizerMem(IMtContext mtContext, int blockSize, int hopSize, float[] analysisWindow, float[] synthesisWindow) {
        this(mtContext, blockSize, hopSize, analysisWindow, synthesisWindow, BooFFT.getPrivateInstance((int)(blockSize / 2)), new float[blockSize]);
    }

    protected StftSynthesizerMem(IMtContext mtContext, int blockSize, int hopSize, float[] analysisWindow, float[] synthesisWindow, BooFFT fft, float[] processBuffer) {
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.olaSize = blockSize - hopSize;
        this.overlap = (blockSize + hopSize - 1) / hopSize;
        int numSections = this.overlap + mtContext.getSerialRunningMaxSkew();
        this.historySize = blockSize * numSections;
        this.synthesisWindow = synthesisWindow;
        this.invWindow = new float[hopSize];
        boolean result = Windows.fillInverseWindow((float[])analysisWindow, (float[])synthesisWindow, (float[])this.invWindow, (int)blockSize, (int)hopSize);
        if (!result) {
            Debug.warn((String)"Cannot create inverse window", (Object[])new Object[0]);
        }
        this.fft = fft;
        this.processBuffer = processBuffer;
        this.olaBuffer = new StftBuffer(this.historySize);
    }

    public void synthesize(Cmplx[] spectrum, float[] output) {
        if (output.length != this.hopSize) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize " + this.hopSize);
        }
        this.fft.backC2R(spectrum, this.processBuffer);
        this.applySynthesisWindow();
        this.overlapAdd(output);
    }

    protected void applySynthesisWindow() {
        if (this.synthesisWindow != null) {
            int i = 0;
            while (i < this.processBuffer.length) {
                int n = i;
                this.processBuffer[n] = this.processBuffer[n] * this.synthesisWindow[i];
                ++i;
            }
        }
    }

    protected void overlapAdd(float[] output) {
        int baseIndex;
        this.ss.enterSerialSection();
        try {
            System.arraycopy(this.processBuffer, 0, this.olaBuffer.buffer, this.olaBuffer.index, this.blockSize);
            baseIndex = this.olaBuffer.index = (this.olaBuffer.index + this.blockSize) % this.historySize;
        }
        finally {
            this.ss.leaveSerialSection();
        }
        baseIndex = (baseIndex + this.historySize - this.blockSize * this.overlap) % this.historySize;
        int hopIndex = baseIndex + this.blockSize * 0 + this.hopSize * (this.overlap - 0 - 1);
        hopIndex %= this.historySize;
        int i = 0;
        while (i < this.hopSize) {
            output[i] = this.olaBuffer.buffer[hopIndex + i];
            ++i;
        }
        int k = 1;
        while (k < this.overlap) {
            int hopIndex2 = baseIndex + this.blockSize * k + this.hopSize * (this.overlap - k - 1);
            hopIndex2 %= this.historySize;
            int i2 = 0;
            while (i2 < this.hopSize) {
                int n = i2;
                output[n] = output[n] + this.olaBuffer.buffer[hopIndex2 + i2];
                ++i2;
            }
            ++k;
        }
        int i3 = 0;
        while (i3 < this.hopSize) {
            int n = i3;
            output[n] = output[n] * this.invWindow[i3];
            ++i3;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getLatency() {
        return this.blockSize - this.hopSize;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.ss = factory.createSerialSection(this.toString(), (Object)this.olaBuffer);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.ss = pool.getSerialSection(this.toString());
        this.olaBuffer = (StftBuffer)this.ss.getUserData();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

