/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.base.stft.old.StftBuffer;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.utils.Debug;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class StftSynthesizerOld
implements IHasSerialSections {
    protected final int blockSize;
    protected final int hopSize;
    protected final int olaSize;
    protected final float[] synthesisWindow;
    protected final float[] invWindow;
    protected final BooFFT fft;
    protected final float[] processBuffer;
    protected StftBuffer olaBuffer;
    protected ISerialSection ss = new DummySerialSection();

    public StftSynthesizerOld(int blockSize, int hopSize, float[] analysisWindow, float[] synthesisWindow) {
        this(blockSize, hopSize, analysisWindow, synthesisWindow, BooFFT.getPrivateInstance((int)(blockSize / 2)), new float[blockSize]);
    }

    protected StftSynthesizerOld(int blockSize, int hopSize, float[] analysisWindow, float[] synthesisWindow, BooFFT fft, float[] processBuffer) {
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.olaSize = blockSize - hopSize;
        this.synthesisWindow = synthesisWindow;
        this.invWindow = new float[hopSize];
        boolean result = Windows.fillInverseWindow((float[])analysisWindow, (float[])synthesisWindow, (float[])this.invWindow, (int)blockSize, (int)hopSize);
        if (!result) {
            Debug.warn((String)"Cannot create inverse window", (Object[])new Object[0]);
        }
        this.fft = fft;
        this.processBuffer = processBuffer;
        this.olaBuffer = new StftBuffer(this.olaSize);
    }

    public void synthesize(Cmplx[] spectrum, float[] output) {
        if (output.length != this.hopSize) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize " + this.hopSize);
        }
        this.fft.backC2R(spectrum, this.processBuffer);
        this.applySynthesisWindow();
        this.overlapAdd(output);
    }

    protected void applySynthesisWindow() {
        if (this.synthesisWindow != null) {
            int i = 0;
            while (i < this.processBuffer.length) {
                int n = i;
                this.processBuffer[n] = this.processBuffer[n] * this.synthesisWindow[i];
                ++i;
            }
        }
    }

    protected void overlapAdd(float[] output) {
        this.ss.enterSerialSection();
        try {
            int i = 0;
            while (i < this.hopSize) {
                output[i] = (this.olaBuffer.buffer[(i + this.olaBuffer.index) % this.olaSize] + this.processBuffer[i]) * this.invWindow[i];
                ++i;
            }
            this.olaBuffer.index = (this.olaBuffer.index + this.hopSize) % this.olaSize;
            i = 0;
            while (i < this.olaSize - this.hopSize) {
                int n = (i + this.olaBuffer.index) % this.olaSize;
                this.olaBuffer.buffer[n] = this.olaBuffer.buffer[n] + this.processBuffer[i + this.hopSize];
                ++i;
            }
            i = this.olaSize - this.hopSize;
            while (i < this.olaSize) {
                this.olaBuffer.buffer[(i + this.olaBuffer.index) % this.olaSize] = this.processBuffer[i + this.hopSize];
                ++i;
            }
        }
        finally {
            this.ss.leaveSerialSection();
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getLatency() {
        return this.blockSize - this.hopSize;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.ss = factory.createSerialSection(this.toString(), (Object)this.olaBuffer);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.ss = pool.getSerialSection(this.toString());
        this.olaBuffer = (StftBuffer)this.ss.getUserData();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

