/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.channels;

import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.sonics.effect.utils.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IMultiChanEffect;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.Channels;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Unit;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

@Category(value="Channels")
@Name(value="Headphonize")
@Description(value="Convert intensity stereophony into delay stereophony\nMakes highly stereophonic audio more pleasant on headphones")
@Channels(min=2, max=2)
@SampleRates(min=8000.0f, max=192000.0f)
@MultiThreading
public class Headphonize
implements IMultiChanEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private static final double EARS_INTER_DELAY = 6.6E-4;
    private static final int NB_CHANS = 2;
    private static final String SERIAL_SECTION_NAME = String.valueOf(Headphonize.class.getName()) + ".delayer";
    private double aperture;
    private double strength;
    private int quality;
    private int nbRes;
    private Fork fork;
    private PyramidAnalyzer[] analyzers;
    private PyramidSynthesizer[] synthesizers;
    private int inputSize;
    private Cmplx[][][][] spectrums;
    private float[][][] layers;
    private float[][] sides;
    private ConcurrentDelayBuffer[] sideDelayers;
    private ConcurrentDelayBuffer[] mainDelayers;
    private ISerialSection delayerSerialSection;
    private float wetLevel;
    private float stereoWidth;
    private int forwardDelay;
    private float globalCorrection;
    private float centerAddition;
    private PyramidSynthesizer centerSynthesizer;
    private float[] center;
    private Cmplx[][][] centerSpectrums;
    private Cmplx srcWest = Cmplx.newCmplx();
    private Cmplx srcEast = Cmplx.newCmplx();
    private Cmplx srcNorth = Cmplx.newCmplx();
    private Cmplx srcSouth = Cmplx.newCmplx();
    private Cmplx srcFront = Cmplx.newCmplx();
    private Cmplx srcRear = Cmplx.newCmplx();
    private Cmplx dstFront = Cmplx.newCmplx();
    private Cmplx dstRear = Cmplx.newCmplx();
    private Cmplx dstWest = Cmplx.newCmplx();
    private Cmplx dstEast = Cmplx.newCmplx();
    private Cmplx dstNorth = Cmplx.newCmplx();
    private Cmplx dstSouth = Cmplx.newCmplx();

    @Order(value=1)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=0.75)
    @Description(value="Dry (0.0) to Wet (1.0) balance\nproportion of delay stereophony")
    public double getStrength() {
        return this.strength;
    }

    public void setStrength(double strength) {
        this.strength = strength;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=120.0, defaultValue=90.0)
    @Description(value="Aperture angle\n90\u00b0 preserves the stereo width\nValues below 90\u00b0 reduce it")
    @Unit(value="\u00b0")
    public double getAperture() {
        return this.aperture;
    }

    public void setAperture(double aperture) {
        this.aperture = aperture;
    }

    @Order(value=3)
    @Description(value="Precision of the result\nHigher values mean less transient smearing but slower processing")
    @Range(minValue=1.0, maxValue=3.0, defaultValue=2.0)
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public void startProcessing(IProcessingInfo info) {
        if (info.getNumberOfChannels() != 2) {
            throw new IllegalArgumentException("Only stereo sounds can be processed with Headphonize");
        }
        double coef = this.aperture <= 90.0 ? Math.sin(this.aperture * Math.PI / 180.0) : 1.0 + Math.sin((this.aperture - 90.0) * Math.PI / 180.0);
        this.stereoWidth = (float)Math.min(coef, 1.0);
        this.forwardDelay = (int)(6.6E-4 * (double)info.getSampleRate() * this.aperture / 90.0 + 0.5);
        this.nbRes = this.quality;
        int baseResolution = AudioMath.adjustPowerOf2((int)4096, (float)44100.0f, (float)info.getSampleRate());
        int overlap = 1 << this.quality;
        SharpInfo sharpInfo = new SharpInfo(baseResolution, this.nbRes, 4.0f, baseResolution, (float)overlap, info.getSampleRate());
        int[] resolutions = null;
        resolutions = this.quality == 1 ? new int[]{baseResolution} : (this.quality == 2 ? new int[]{baseResolution * 2, baseResolution / 2} : new int[]{baseResolution * 2, baseResolution / 2, baseResolution / 8});
        this.inputSize = resolutions[0] / overlap;
        this.fork = new Fork(2, sharpInfo, this.inputSize, false, false, 1.0f);
        this.analyzers = new PyramidAnalyzer[2];
        this.synthesizers = new PyramidSynthesizer[2];
        float[] window = WindowsFactory.getHannWindow(resolutions[0]);
        int c = 0;
        while (c < 2) {
            this.analyzers[c] = new PyramidAnalyzer("Channel" + c, resolutions, this.inputSize, overlap, window);
            this.synthesizers[c] = new PyramidSynthesizer("Channel" + c, resolutions, this.inputSize, overlap, window, window, null, 1.0f, true, 1.0f);
            ++c;
        }
        this.sides = new float[2][this.inputSize];
        this.spectrums = new Cmplx[2][this.nbRes][][];
        this.layers = new float[2][this.nbRes][];
        this.centerSynthesizer = new PyramidSynthesizer("Center", resolutions, this.inputSize, overlap, window, window, null, 1.0f, true, 1.0f);
        this.center = new float[this.inputSize];
        this.centerSpectrums = new Cmplx[this.nbRes][][];
        int r = 0;
        while (r < this.nbRes) {
            this.centerSpectrums[r] = Cmplx.newArray((int)this.analyzers[0].getNumHops(r), (int)(this.analyzers[0].getBlockSize(r) / 2 + 1));
            ++r;
        }
        this.wetLevel = (float)this.strength;
        this.globalCorrection = (float)Math.sqrt(1.0f / (1.0f + this.wetLevel));
        this.centerAddition = 1.0f / this.globalCorrection - 1.0f;
    }

    public int getLatency(IoDirection ioDirection) {
        return this.fork.getLatency() + this.synthesizers[0].getLatency();
    }

    public int getFixedChunkLength() {
        return this.inputSize;
    }

    public void beginProcessing(IProcessingInfo info) {
        this.fork.init();
        Object[] objectArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            PyramidAnalyzer analyzer = objectArray[n2];
            analyzer.init();
            ++n2;
        }
        objectArray = this.synthesizers;
        n = this.synthesizers.length;
        n2 = 0;
        while (n2 < n) {
            Object synthesizer = objectArray[n2];
            ((PyramidSynthesizer)synthesizer).init();
            ++n2;
        }
        this.centerSynthesizer.init();
    }

    public void process(float[][] data) {
        assert (data.length == 2);
        this.fork.process(data);
        int r = 0;
        while (r < this.nbRes) {
            this.layers[0][r] = this.fork.getOutput(this.nbRes - 1 - r, 0);
            this.layers[1][r] = this.fork.getOutput(this.nbRes - 1 - r, 1);
            ++r;
        }
        this.spectrums[0] = this.analyzers[0].analyze(this.layers[0]);
        this.spectrums[1] = this.analyzers[1].analyze(this.layers[1]);
        r = 0;
        while (r < this.nbRes) {
            Cmplx[][] leftFrames = this.spectrums[0][r];
            Cmplx[][] rightFrames = this.spectrums[1][r];
            Cmplx[][] centerFrames = this.centerSpectrums[r];
            assert (leftFrames.length == rightFrames.length && leftFrames.length == centerFrames.length);
            int k = 0;
            while (k < centerFrames.length) {
                this.processSpectrum(leftFrames[k], rightFrames[k], centerFrames[k]);
                ++k;
            }
            ++r;
        }
        int c = 0;
        while (c < 2) {
            this.synthesizers[c].synthesize(this.spectrums[c], this.sides[c]);
            ++c;
        }
        this.centerSynthesizer.synthesize(this.centerSpectrums, this.center);
        long delayerClock = this.delayerSerialSection.getClock();
        int c2 = 0;
        while (c2 < 2) {
            this.mainDelayers[c2].push(data[c2], delayerClock);
            ++c2;
        }
        c2 = 0;
        while (c2 < 2) {
            this.sideDelayers[c2].push(this.sides[c2], delayerClock);
            ++c2;
        }
        this.delayerSerialSection.sync();
        c2 = 0;
        while (c2 < 2) {
            this.mainDelayers[c2].pop(data[c2], delayerClock);
            ++c2;
        }
        c2 = 0;
        while (c2 < 2) {
            this.sideDelayers[c2].pop(this.sides[c2], delayerClock);
            ++c2;
        }
        float sw = 1.0f - (1.0f - this.stereoWidth) * (1.0f - this.wetLevel);
        float correction = 1.0f;
        if (sw != 1.0f) {
            float crossMix = 1.0f - sw;
            correction = 1.0f / (1.0f + crossMix);
            int i = 0;
            while (i < this.inputSize) {
                float l = data[0][i];
                float r2 = data[1][i];
                data[0][i] = (data[0][i] + r2 * crossMix) * correction;
                data[1][i] = (data[1][i] + l * crossMix) * correction;
                ++i;
            }
        }
        int c3 = 0;
        while (c3 < 2) {
            int d = 1 - c3;
            int i = 0;
            while (i < this.inputSize) {
                data[c3][i] = (data[c3][i] + this.sides[d][i] * this.wetLevel * correction) * this.globalCorrection + this.center[i] * this.centerAddition * correction;
                ++i;
            }
            ++c3;
        }
    }

    private void processSpectrum(Cmplx[] spectrumL, Cmplx[] spectrumR, Cmplx[] centerSpectrum) {
        assert (spectrumL.length == spectrumR.length && spectrumL.length == centerSpectrum.length);
        int i = 0;
        while (i < centerSpectrum.length) {
            this.srcWest.set(spectrumL[i]);
            this.srcEast.set(spectrumR[i]);
            this.srcNorth.clear();
            this.srcSouth.clear();
            this.dstWest.set(spectrumL[i]);
            this.dstEast.set(spectrumR[i]);
            this.dstNorth.clear();
            this.dstSouth.clear();
            this.quadize(this.dstWest, this.dstEast, this.dstNorth, this.dstSouth, this.srcWest, this.srcEast, this.srcNorth, this.srcSouth, true);
            spectrumL[i].set(this.dstWest);
            spectrumR[i].set(this.dstEast);
            centerSpectrum[i].set(this.dstNorth);
            centerSpectrum[i].add(this.dstSouth);
            ++i;
        }
    }

    private void quadize(Cmplx dstWest, Cmplx dstEast, Cmplx dstNorth, Cmplx dstSouth, Cmplx srcWest, Cmplx srcEast, Cmplx srcNorth, Cmplx srcSouth, boolean surround) {
        boolean isRear;
        this.srcFront.sum(srcWest, srcEast);
        this.srcRear.dif(srcWest, srcEast);
        this.dstFront.sum(dstWest, dstEast);
        this.dstRear.dif(dstWest, dstEast);
        float pmLeft = srcWest.powerMag();
        float pmRight = srcEast.powerMag();
        float pmFront = this.srcFront.powerMag();
        float pmRear = this.srcRear.powerMag();
        float pmCommon = pmLeft < pmRight ? pmLeft : pmRight;
        boolean bl = isRear = pmRear > pmFront;
        if (isRear) {
            if (surround) {
                if (pmRear > pmCommon) {
                    float correction = (float)Math.sqrt(pmCommon / pmRear);
                    this.srcRear.mul(correction);
                    this.dstRear.mul(correction);
                }
            } else {
                this.srcRear.clear();
                this.dstRear.clear();
            }
            this.srcFront.clear();
            this.dstFront.clear();
        } else {
            if (pmFront > pmCommon) {
                float correction = (float)Math.sqrt(pmCommon / pmFront);
                this.srcFront.mul(correction);
                this.dstFront.mul(correction);
            }
            this.srcRear.clear();
            this.dstRear.clear();
        }
        srcNorth.add(this.srcFront);
        srcWest.sub(this.srcFront);
        srcEast.sub(this.srcFront);
        dstNorth.add(this.dstFront);
        dstWest.sub(this.dstFront);
        dstEast.sub(this.dstFront);
        if (surround) {
            srcSouth.add(this.srcRear);
            srcWest.sub(this.srcRear);
            srcEast.add(this.srcRear);
            dstSouth.add(this.dstRear);
            dstWest.sub(this.dstRear);
            dstEast.add(this.dstRear);
        }
    }

    public void stopProcessing() {
        this.fork = null;
        this.analyzers = null;
        this.synthesizers = null;
        this.spectrums = null;
        this.layers = null;
        this.mainDelayers = null;
        this.sideDelayers = null;
        this.sides = null;
        this.centerSynthesizer = null;
        this.center = null;
        this.centerSpectrums = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.mainDelayers = new ConcurrentDelayBuffer[2];
        this.sideDelayers = new ConcurrentDelayBuffer[2];
        int c = 0;
        while (c < 2) {
            int mainDelay = this.fork.getLatency() + this.synthesizers[c].getLatency();
            this.mainDelayers[c] = new ConcurrentDelayBuffer(mainDelay, this.inputSize, factory.getMtContext());
            this.sideDelayers[c] = new ConcurrentDelayBuffer(this.forwardDelay, this.inputSize, factory.getMtContext());
            ++c;
        }
        this.delayerSerialSection = factory.createSerialSection(SERIAL_SECTION_NAME, (Object)new Object[]{this.mainDelayers, this.sideDelayers});
        this.fork.createSerialSections(factory);
        Object[] objectArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            PyramidAnalyzer analyzer = objectArray[n2];
            analyzer.createSerialSections(factory);
            ++n2;
        }
        objectArray = this.synthesizers;
        n = this.synthesizers.length;
        n2 = 0;
        while (n2 < n) {
            Object synthesizer = objectArray[n2];
            ((PyramidSynthesizer)synthesizer).createSerialSections(factory);
            ++n2;
        }
        this.centerSynthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.delayerSerialSection = pool.getSerialSection(SERIAL_SECTION_NAME);
        Object[] delayers = (Object[])this.delayerSerialSection.getUserData();
        this.mainDelayers = (ConcurrentDelayBuffer[])delayers[0];
        this.sideDelayers = (ConcurrentDelayBuffer[])delayers[1];
        this.fork.setSerialSections(pool);
        Object[] objectArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            PyramidAnalyzer analyzer = objectArray[n2];
            analyzer.setSerialSections(pool);
            ++n2;
        }
        objectArray = this.synthesizers;
        n = this.synthesizers.length;
        n2 = 0;
        while (n2 < n) {
            Object synthesizer = objectArray[n2];
            ((PyramidSynthesizer)synthesizer).setSerialSections(pool);
            ++n2;
        }
        this.centerSynthesizer.setSerialSections(pool);
    }
}

