/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.filters;

import ch.tachyon.sonics.effect.timbre.rollers.FilterEngine;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.IStorage;
import ch.tachyon.tunnel.plugin.opt.callback.ILoadUnload;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.ITimeLocal;
import ch.tachyon.tunnel.plugin.opt.thread.Live;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.SampleRateTransform;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Transform;
import ch.tachyon.tunnel.plugin.param.Unit;
import org.corebounce.common.audio.AudioMath;

@Category(value="Filters")
@Name(value="Butterworth Filter")
@Description(value="Band-pass filter\nImplemented using a recursive Butterworth filter")
@Live
@MultiThreading
public class ButterworthBandPass
implements ISimpleEffect,
ILoadUnload,
IStartStop,
ITimeLocal {
    private static final float MIN_LOW_CUT = 2.2E-5f;
    private static final float MAX_HIGH_CUT = 0.499978f;
    private static final float THRESHOLD = (float)AudioMath.dbToLevel((double)-120.0);
    private static final int MAX_RESPONSE_SIZE = 50000;
    private static final int DENORMAL_PERIOD = 10000;
    private int strength;
    private float lowCut;
    private float highCut;
    private FilterEngine engine;
    private int countDown;
    private int responseSize;

    @Order(value=1)
    @Unit(value="Hz")
    @Scale(value=ScaleType.LOGARITHMIC)
    @Transform(value=SampleRateTransform.class)
    @Range(minValue=0.0, maxValue=0.5)
    @Name(value="Low Cut")
    @Description(value="Low cut frequency\nFrequencies below the given value will be removed\nIf set to 0, a low-pass filter is created")
    public float getLowCut() {
        return this.lowCut;
    }

    public void setLowCut(float lowCut) {
        this.lowCut = lowCut;
    }

    @Order(value=2)
    @Unit(value="Hz")
    @Scale(value=ScaleType.LOGARITHMIC)
    @Transform(value=SampleRateTransform.class)
    @Range(minValue=0.0, maxValue=0.5)
    @Name(value="High Cut")
    @Description(value="High cut frequency\nFrequencies above the given value will be removed\nIf set to maximum, a high-pass filter is created")
    public float getHighCut() {
        return this.highCut;
    }

    public void setHighCut(float highCut) {
        this.highCut = highCut;
    }

    @Order(value=3)
    @Range(minValue=1.0, maxValue=10.0, defaultValue=4.0)
    @Description(value="Roll-off in 12db/octave increments\nHigher values means sharper cutoff but slower processing and longer resonances")
    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public void load(IProcessingInfo info) {
        this.lowCut = 400.0f / info.getSampleRate();
        this.highCut = 4000.0f / info.getSampleRate();
    }

    public void startProcessing(IProcessingInfo info) {
        float sr = info.getSampleRate();
        if (this.lowCut > this.highCut) {
            float temp = this.lowCut;
            this.lowCut = this.highCut;
            this.highCut = temp;
        }
        if (this.lowCut < 2.2E-5f && this.highCut > 0.499978f) {
            this.engine = null;
        } else if (this.lowCut < 2.2E-5f) {
            this.engine = new FilterEngine(this.strength);
            this.engine.initButterworthLow(sr, sr * this.highCut);
        } else if (this.highCut > 0.499978f) {
            this.engine = new FilterEngine(this.strength);
            this.engine.initButterworthHigh(sr, sr * this.lowCut);
        } else {
            this.engine = new FilterEngine(this.strength * 2);
            this.engine.initButterworthBand(sr, sr * this.lowCut, sr * this.highCut);
        }
        this.countDown = 10000;
        IStorage storage = info.getStorage();
        Integer rs = (Integer)storage.getProcessData(Integer.class);
        if (rs == null) {
            this.responseSize = this.computeResponseSize();
            storage.setProcessData((Object)this.responseSize);
        } else {
            this.responseSize = rs;
        }
    }

    private int computeResponseSize() {
        float period1 = 1.0f / Math.min(this.lowCut, this.highCut);
        float period2 = 1.0f / Math.abs(this.highCut - this.lowCut);
        float period3 = 1.0f / (0.5f - Math.max(this.lowCut, this.highCut));
        int maxPeriod = 0;
        if (!Float.isNaN(period1)) {
            maxPeriod = (int)period1;
        }
        if (!Float.isNaN(period2)) {
            maxPeriod = Math.max(maxPeriod, (int)period2);
        }
        if (!Float.isNaN(period3)) {
            maxPeriod = Math.max(maxPeriod, (int)period3);
        }
        if (maxPeriod > 50000) {
            maxPeriod = 50000;
        }
        int currentSize = 1;
        int responseSize = 1;
        float value = Math.abs(this.engine.process(2.0f));
        while (value < THRESHOLD) {
            ++currentSize;
            ++responseSize;
            value = Math.abs(this.engine.process(0.0f));
        }
        while (value > THRESHOLD || currentSize < responseSize + maxPeriod) {
            if (currentSize > 50000) {
                return -1;
            }
            if (value > THRESHOLD) {
                responseSize = currentSize;
            }
            ++currentSize;
            value = Math.abs(this.engine.process(0.0f));
        }
        this.engine.clearHistory();
        return responseSize;
    }

    public int getRequiredFramesBefore(IProcessingInfo info) {
        return this.responseSize;
    }

    public void process(float[] data) {
        int i = 0;
        while (i < data.length) {
            if (data[i] > 2.0f) {
                data[i] = 2.0f;
            } else if (data[i] < -2.0f) {
                data[i] = -2.0f;
            }
            ++i;
        }
        if (this.engine != null) {
            this.engine.processButter(data, data);
        }
        i = 0;
        while (i < data.length) {
            if (data[i] < Float.MIN_NORMAL && data[i] > -1.1754944E-38f) {
                data[i] = 0.0f;
            }
            ++i;
        }
        if (data.length >= this.countDown) {
            this.countDown = 10000;
            this.engine.clearDenormal();
        } else {
            this.countDown -= data.length;
        }
    }

    public void stopProcessing() {
        this.engine = null;
    }

    public void unload() {
    }
}

