/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.filters;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.IRequiredBeforeAfter;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.Live;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Unit;
import java.util.HashMap;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

@Category(value="Filters")
@Name(value="Graphic Equalizer")
@Description(value="Linear-Phase Frequency Equalizer\n10 bands")
@SampleRates(min=44100.0f, max=48000.0f)
@Live
@MultiThreading
public class Equalizer
extends FourierSimpleEffectBase
implements IRequiredBeforeAfter {
    private float g32 = -4.0f;
    private float g64 = -4.0f;
    private float g125 = 8.0f;
    private float g250 = 8.0f;
    private float g500 = 0.0f;
    private float g1000 = -4.0f;
    private float g2000 = -8.0f;
    private float g4000 = 0.0f;
    private float g8000 = 8.0f;
    private float g16000 = 4.0f;
    private float globalGain = -4.0f;
    private boolean adaptive;
    private transient CurveMap curves;
    private transient float sampleRate;

    @Order(value=1)
    @Name(value="32 Hz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG32() {
        return this.g32;
    }

    public void setG32(float g32) {
        this.g32 = g32;
    }

    @Order(value=2)
    @Name(value="64 Hz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG64() {
        return this.g64;
    }

    public void setG64(float g64) {
        this.g64 = g64;
    }

    @Order(value=3)
    @Name(value="125 Hz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG125() {
        return this.g125;
    }

    public void setG125(float g125) {
        this.g125 = g125;
    }

    @Order(value=4)
    @Name(value="250 Hz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG250() {
        return this.g250;
    }

    public void setG250(float g250) {
        this.g250 = g250;
    }

    @Order(value=5)
    @Name(value="500 Hz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG500() {
        return this.g500;
    }

    public void setG500(float g500) {
        this.g500 = g500;
    }

    @Order(value=6)
    @Name(value="1 KHz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG1000() {
        return this.g1000;
    }

    public void setG1000(float g1000) {
        this.g1000 = g1000;
    }

    @Order(value=7)
    @Name(value="2 kHz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG2000() {
        return this.g2000;
    }

    public void setG2000(float g2000) {
        this.g2000 = g2000;
    }

    @Order(value=8)
    @Name(value="4 kHz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG4000() {
        return this.g4000;
    }

    public void setG4000(float g4000) {
        this.g4000 = g4000;
    }

    @Order(value=9)
    @Name(value="8 kHz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG8000() {
        return this.g8000;
    }

    public void setG8000(float g8000) {
        this.g8000 = g8000;
    }

    @Order(value=10)
    @Name(value="16 kHz")
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getG16000() {
        return this.g16000;
    }

    public void setG16000(float g16000) {
        this.g16000 = g16000;
    }

    @Order(value=11)
    @Unit(value="dB")
    @Range(minValue=-20.0, maxValue=20.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public float getGlobalGain() {
        return this.globalGain;
    }

    public void setGlobalGain(float globalGain) {
        this.globalGain = globalGain;
    }

    public long getRequiredSamplesBefore(IProcessingInfo info) {
        return this.getLatency(IoDirection.INPUT);
    }

    public long getRequiredSamplesAfter(IProcessingInfo info) {
        return 0L;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec(info.getSampleRate());
        if (!this.adaptive) {
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setBaseResolution(this.adjustPowerOf2(info, 2048));
            specs.setOverlap(4.0f);
        } else if (this.adaptive) {
            specs.setProcessingType(FourierProcessingType.MULTI_SCALE);
            specs.setResolution(this.adjustPowerOf2(info, 4096), 4.0f, 3, 4.0f, 1.0f, true);
        }
        this.sampleRate = info.getSampleRate();
        return specs;
    }

    private int adjustPowerOf2(IProcessingInfo info, int value) {
        float sampleRateChange = info.getSampleRate() / 44100.0f;
        float baseSR = 0.707f;
        while (baseSR > sampleRateChange) {
            value /= 2;
            baseSR *= 0.5f;
        }
        while (baseSR * 2.0f < sampleRateChange) {
            value *= 2;
            baseSR *= 2.0f;
        }
        return value;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.curves = (CurveMap)info.getStorage().getProcessData(CurveMap.class);
        if (this.curves == null) {
            this.curves = new CurveMap();
            int r = 0;
            while (r < this.getNbResolutions()) {
                int nbBins = this.getNbBins(r);
                this.curves.put(nbBins, this.computeCurve(nbBins));
                ++r;
            }
            info.getStorage().setProcessData((Object)this.curves);
        }
    }

    /*
     * Unable to fully structure code
     */
    private float[] computeCurve(int nbBins) {
        curve = new float[nbBins];
        Freqs = new float[]{32.0f, 64.0f, 125.0f, 250.0f, 500.0f, 1000.0f, 2000.0f, 4000.0f, 8000.0f, 16000.0f};
        Amps = new float[]{this.getG32(), this.getG64(), this.getG125(), this.getG250(), this.getG500(), this.getG1000(), this.getG2000(), this.getG4000(), this.getG8000(), this.getG16000()};
        if (!Equalizer.$assertionsDisabled && Freqs.length != Amps.length) {
            throw new AssertionError();
        }
        NbBands = Freqs.length;
        b0 = -1;
        b1 = 0;
        nextBin = this.freq2bin(nbBins, Freqs[0]);
        i = 0;
        ** GOTO lbl35
        {
            ++b0;
            nextBin = ++b1 < NbBands ? this.freq2bin(nbBins, Freqs[b1]) : (float)nbBins;
            do {
                if ((float)i >= nextBin) continue block0;
                if (b0 < 0) {
                    curve[i] = (float)AudioMath.dbToLevel((double)Amps[b1]);
                } else if (b1 >= Freqs.length) {
                    curve[i] = (float)AudioMath.dbToLevel((double)Amps[b0]);
                } else {
                    a1 = b0 < 0 ? Amps[0] : Amps[b0];
                    a2 = b1 >= NbBands ? Amps[NbBands - 1] : Amps[b1];
                    f0Log = Math.log(Freqs[b0]);
                    f1Log = Math.log(Freqs[b1]);
                    freq = this.bin2freq(nbBins, i);
                    freqLog = Math.log(freq);
                    mu = (freqLog - f0Log) / (f1Log - f0Log);
                    if (!(Equalizer.$assertionsDisabled || mu >= 0.0 && mu <= 1.0)) {
                        throw new AssertionError(mu);
                    }
                    mu = Math.sin(mu * 3.141592653589793 / 2.0);
                    result = (double)a1 * (1.0 - mu) + (double)a2 * mu;
                    curve[i] = (float)AudioMath.dbToLevel((double)result);
                }
                ++i;
lbl35:
                // 2 sources

            } while (i < nbBins);
        }
        return curve;
    }

    private float freq2bin(int nbBins, float freq) {
        int fftSize = (nbBins - 1) * 2;
        return freq * (float)fftSize / this.sampleRate;
    }

    private float bin2freq(int nbBins, int binNum) {
        int fftSize = (nbBins - 1) * 2;
        return (float)binNum * this.sampleRate / (float)fftSize;
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int step) {
        float gain = (float)AudioMath.dbToLevel((double)this.globalGain);
        float[] curve = (float[])this.curves.get(spectrum.length);
        int i = 0;
        while (i < spectrum.length) {
            spectrum[i].mul(curve[i] * gain);
            ++i;
        }
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.curves = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CurveMap
    extends HashMap<Integer, float[]> {
        CurveMap() {
        }
    }
}

