/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.filters;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.PowerOf2;
import ch.tachyon.sonics.effect.base.stft.old.FastStftEngine;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.common.ParameterDefinition;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.opt.thread.Live;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.PowerOfTwoTransform;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.SampleRateTransform;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Sweepable;
import ch.tachyon.tunnel.plugin.param.Transform;
import ch.tachyon.tunnel.plugin.param.Unit;
import org.corebounce.common.math.Cmplx;

@Category(value="Filters")
@Name(value="FFT Band-Pass Filter")
@Description(value="Brickwall linear-phase band-pass filter\nKeep only frequencies between the low and high cut frequencies\nCan also be used as band-stop, low-pass or high-pass filter\nImplemented using the Short-Time Fourier Transform.")
@Live
@MultiThreading
public class FftFilter
extends EffectBase
implements ISimpleEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    public static final ParameterDefinition<FftFilter, Float> LOW_CUT = new ParameterDefinition(FftFilter.class, Float.class, "lowCut");
    public static final ParameterDefinition<FftFilter, Float> HIGH_CUT = new ParameterDefinition(FftFilter.class, Float.class, "highCut");
    public static final ParameterDefinition<FftFilter, PowerOf2> FFT_SIZE = new ParameterDefinition(FftFilter.class, PowerOf2.class, "fftSize");
    public static final ParameterDefinition<FftFilter, Integer> OVERLAP = new ParameterDefinition(FftFilter.class, Integer.class, "overlap");
    private float lowCut;
    private float highCut;
    private PowerOf2 fftSize;
    private int overlap;
    private int bin1;
    private int bin2;
    private FastStftEngine engine = null;

    @Order(value=1)
    @Unit(value="Hz")
    @Sweepable
    @Scale(value=ScaleType.LOGARITHMIC)
    @Transform(value=SampleRateTransform.class)
    @Range(minValue=0.0, maxValue=0.5, defaultValue=0.01)
    @Name(value="Low Cut")
    @Description(value="Low cut frequency\nFrequencies below the given value will be removed")
    public float getLowCut() {
        return this.lowCut;
    }

    public void setLowCut(float lowCut) {
        this.lowCut = lowCut;
    }

    @Order(value=2)
    @Unit(value="Hz")
    @Sweepable
    @Scale(value=ScaleType.LOGARITHMIC)
    @Transform(value=SampleRateTransform.class)
    @Range(minValue=0.0, maxValue=0.5, defaultValue=0.1)
    @Name(value="High Cut")
    @Description(value="High cut frequency\nFrequencies above the given value will be removed")
    public float getHighCut() {
        return this.highCut;
    }

    public void setHighCut(float highCut) {
        this.highCut = highCut;
    }

    @Order(value=3)
    @Range(minValue=6.0, maxValue=19.0, defaultValue=9.0)
    @Name(value="FFT Size")
    @Description(value="Size of the Fourier transform\nSmaller values mean higher time resolution and lower frequency resolution.\nHigher values mean higher frequency resolution and lower time resolution.")
    public PowerOf2 getFftSize() {
        return this.fftSize;
    }

    public void setFftSize(PowerOf2 fftSize) {
        this.fftSize = fftSize;
    }

    @Order(value=4)
    @Range(minValue=1.0, maxValue=5.0, defaultValue=3.0)
    @Name(value="Overlapping")
    @Transform(value=PowerOfTwoTransform.class)
    public int getOverlap() {
        return this.overlap;
    }

    public void setOverlap(int overlap) {
        this.overlap = overlap;
    }

    public void startProcessing(IProcessingInfo info) {
        int inHopSize = this.fftSize.intValue() / (1 << this.overlap);
        int numHops = 1;
        info.negociateFixedChunkLength(inHopSize * numHops);
        this.engine = new FastStftEngine(numHops, this.fftSize.intValue(), 1 << this.overlap, this.overlap > 1);
        if (this.lowCut <= this.highCut) {
            this.bin1 = this.cut2bin(this.lowCut, 1);
            this.bin2 = this.cut2bin(this.highCut, -1);
        } else {
            this.bin1 = this.cut2bin(this.lowCut, -1);
            this.bin2 = this.cut2bin(this.highCut, 1);
        }
    }

    private int cut2bin(float freq, int rounding) {
        float offset = (float)(rounding + 1) * 0.4999f;
        int result = (int)(freq * (float)this.fftSize.intValue() + offset);
        if (result < 0) {
            result = 0;
        } else if (result >= this.engine.getNbBins()) {
            result = this.engine.getNbBins() - 1;
        }
        return result;
    }

    public int getFixedChunkLength() {
        return this.engine.getInputSize();
    }

    public int getLatency(IoDirection ioDirection) {
        if (this.engine == null) {
            return 0;
        }
        return this.engine.getLatency();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.engine.init();
    }

    public void process(float[] data) {
        Cmplx[][] spectrums;
        Cmplx[][] cmplxArray = spectrums = this.engine.analyze(data);
        int n = spectrums.length;
        int n2 = 0;
        while (n2 < n) {
            Cmplx[] spectrum = cmplxArray[n2];
            int i = 0;
            while (i < spectrum.length) {
                if (this.bin2 > this.bin1) {
                    if (i < this.bin1 || i > this.bin2) {
                        spectrum[i].set(0.0f, 0.0f);
                    }
                } else if (i <= this.bin1 && i >= this.bin2) {
                    spectrum[i].set(0.0f, 0.0f);
                }
                ++i;
            }
            ++n2;
        }
        this.engine.synthesize(data);
    }

    public void stopProcessing() {
        this.engine = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engine.setSerialSections(pool);
    }
}

