/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.filters;

import ch.tachyon.sonics.effect.utils.DelayBuffer;
import ch.tachyon.sonics.effect.utils.MultiAvgBuffer;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.SampleRateTransform;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Transform;

@Category(value="Filters")
@Name(value="Multi Average Filter")
public class MultiAverageFilter
implements ISimpleEffect,
IStartStop,
ILatency {
    private float frequency;
    private int numberOfSections;
    private float strength;
    private boolean reverse;
    private MultiAvgBuffer filter;
    private DelayBuffer delayer;

    @Order(value=1)
    @Scale(value=ScaleType.LOGARITHMIC)
    @Transform(value=SampleRateTransform.class)
    @Range(minValue=0.001, maxValue=0.5, defaultValue=0.05)
    public float getFrequency() {
        return this.frequency;
    }

    public void setFrequency(float frequency) {
        this.frequency = frequency;
    }

    @Range(minValue=1.0, maxValue=10.0, defaultValue=4.0)
    @Order(value=2)
    public int getNumberOfSections() {
        return this.numberOfSections;
    }

    public void setNumberOfSections(int numberOfSections) {
        this.numberOfSections = numberOfSections;
    }

    @Range(minValue=0.0, maxValue=1.0, defaultValue=1.0)
    @Order(value=3)
    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    @Order(value=4)
    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void startProcessing(IProcessingInfo info) {
        float realFreq = this.frequency * info.getSampleRate();
        float lengthF = info.getSampleRate() / 2.0f / realFreq;
        int length = (int)((lengthF - 1.0f) / 2.0f + 0.5f) * 2 + 1;
        if (length < 1) {
            length = 1;
        }
        this.filter = new MultiAvgBuffer(this.numberOfSections, length);
        this.delayer = new DelayBuffer((int)(this.filter.getLatency() + 0.5f));
    }

    public int getLatency(IoDirection ioDirection) {
        return (int)(this.filter.getLatency() + 0.5f);
    }

    public void process(float[] data) {
        int i = 0;
        while (i < data.length) {
            float value = this.filter.push(data[i]);
            float delayed = this.delayer.push(data[i]);
            data[i] = this.reverse ? delayed - value * this.strength : delayed * (1.0f - this.strength) + value * this.strength;
            ++i;
        }
    }

    public void stopProcessing() {
        this.filter = null;
        this.delayer = null;
    }
}

