/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierPushEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IPostFftProcessor;
import ch.tachyon.sonics.effect.base.fourier.IPostLockedProcessor;
import ch.tachyon.sonics.effect.timbre.texture.TextureLevelTimeEngine;
import ch.tachyon.sonics.effect.utils.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.IRequiredBeforeAfter;
import ch.tachyon.tunnel.plugin.opt.spec.OverTime;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

@Category(value="Tempo")
@Name(value="Half Tempo")
@Description(value="Slow down the tempo by 2 without affecting the pitch")
@MultiThreading
@SampleRates(min=8000.0f, max=96000.0f)
@OverTime(parameterName="quality", minValue=5.0)
public class HalfTempo
extends FourierPushEffectBase
implements IPostFftProcessor,
IPostLockedProcessor,
IRequiredBeforeAfter {
    private static final String DELAYER_SECTION_NAME = String.valueOf(HalfTempo.class.getName()) + ".delayer";
    private static final float BASE_SAMPLE_RATE = 44100.0f;
    private int quality = 3;
    private float frequencyRes = 1.0f;
    private transient float sampleRateChange = 1.0f;
    private TextureLevelTimeEngine textureEngine;
    private ConcurrentDelayBuffer noiseDelayer;
    private float postGain;
    private ISerialSection delayerSection = new DummySerialSection();

    @Description(value="Precision of the result\nHigher values mean better quality but slower processing")
    @Range(minValue=1.0, maxValue=5.0, defaultValue=3.0)
    @Order(value=1)
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    @Order(value=2)
    @Name(value="Time/Frequency")
    @Description(value="Frequency resolution")
    @Range(minValue=0.5, maxValue=2.0, defaultValue=1.0)
    @Scale(value=ScaleType.LOGARITHMIC, steps=8)
    public float getFrequencyRes() {
        return this.frequencyRes;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        this.sampleRateChange = info.getSampleRate() / 44100.0f;
        FourierSpec specs = new FourierSpec(info.getSampleRate());
        specs.setAntiLeakage(true);
        specs.setEnergyCorrection(true);
        specs.setPostFftProcessor(this);
        this.postGain = 1.0f;
        if (this.quality == 1) {
            int blockSize = this.adjust(2700);
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setBaseResolution(blockSize);
            specs.setOverlap(8.0f);
            specs.setEnergyCorrection(true);
            float[] convolved0 = new float[blockSize * 2];
            float[] HannSelfConvolvedCoefs = new float[]{0.2857143f, -0.2057143f, 0.071428575f, -0.008217143f};
            Windows.fillWindow((float[])convolved0, (float[])HannSelfConvolvedCoefs);
            int fftSize = AudioMath.getCeilingPowerOf2((int)blockSize);
            float[] convolved = new float[fftSize * 2];
            System.arraycopy(convolved0, 0, convolved, fftSize - blockSize, blockSize * 2);
            float correction = (float)Math.sqrt((float)fftSize / (float)blockSize);
            int i = 0;
            while (i < convolved.length) {
                int n = i++;
                convolved[n] = convolved[n] * correction;
            }
            float[] modifiedWindow = new float[fftSize];
            int i2 = 0;
            while (i2 < fftSize) {
                modifiedWindow[i2] = convolved[i2 + fftSize / 2] + convolved[(i2 + fftSize * 3 / 2) % convolved.length];
                ++i2;
            }
            specs.setModifiedWindow(modifiedWindow);
        } else if (this.quality == 2) {
            int blockSize = this.adjust(2700);
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setAnalysisShrink(2.0f);
            specs.setBaseResolution(blockSize * 2);
            specs.setOverlap(32.0f);
            specs.setSynthesisShrink(4.0f);
        } else if (this.quality == 3) {
            specs.setProcessingType(FourierProcessingType.PYRAMIDAL);
            int[] resolutions = new int[]{8820, 3400, 2200, 1024};
            specs.setPyramidResolutions(this.adjust(resolutions));
            specs.setSplitFreqs(new float[]{1000.0f, 2050.0f, 10000.0f});
            specs.setOverlap(32.0f);
            specs.setAnalysisShrink(2.0f);
            specs.setSynthesisShrink(4.0f);
            specs.setEnergyCorrection(true);
            specs.setPostLockedProcessor(this);
        } else if (this.quality == 4) {
            specs.setProcessingType(FourierProcessingType.ADAPTIVE);
            int[][] resolutions = new int[][]{{2200, 1024, 1024, 1024}, {8820, 3400, 2200, 1024}, {8820, 3400, 2200, 1024}, {15000, 15000, 8824, 8824}};
            specs.setSplitFreqs(new float[]{1000.0f, 2050.0f, 10000.0f});
            specs.setNoiseSplitFreqs(new float[]{1500.0f, 4200.0f, 12000.0f});
            specs.setNoiseMode(true);
            specs.setNbLockedLayers(3);
            specs.setAdaptiveResolutions(this.adjust(resolutions));
            specs.setOverlap(32.0f);
            specs.setAnalysisShrink(2.0f);
            specs.setSynthesisShrink(4.0f);
            specs.setMaxSynthesisSize((float)specs.getBaseResolution() / 4.0f);
            specs.setPostLockedProcessor(this);
        } else if (this.quality == 5) {
            specs.setProcessingType(FourierProcessingType.LOCKED_ADAPTIVE);
            int[][] resolutions = new int[][]{{2200, 1024, 1024, 1024}, {4410, 2200, 2200, 1024}, {8820, 3400, 2200, 1024}, {15000, 15000, 8820, 8820}};
            specs.setAdaptiveResolutions(this.adjust(resolutions));
            specs.setSplitFreqs(new float[]{1000.0f, 2050.0f, 10000.0f});
            specs.setNoiseSplitFreqs(new float[]{1500.0f, 4200.0f, 12000.0f});
            specs.setNoiseMode(true);
            specs.setNbLockedLayers(3);
            specs.setOverlap(16.0f);
            specs.setAnalysisShrink(2.0f);
            specs.setSynthesisShrink(4.0f);
            specs.setMaxSynthesisSize((float)specs.getBaseResolution() / 4.0f);
            specs.setPostLockedProcessor(this);
        }
        specs.setOutputHopSize(specs.getInputHopSize() * 2);
        return specs;
    }

    private int adjust(int value) {
        return (int)((float)value * this.frequencyRes * this.sampleRateChange + 0.5f);
    }

    private int[] adjust(int[] values) {
        int[] result = new int[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = this.adjust(values[i]);
            ++i;
        }
        return result;
    }

    private int[][] adjust(int[][] values) {
        int[][] result = new int[values.length][];
        int i = 0;
        while (i < values.length) {
            result[i] = this.adjust(values[i]);
            ++i;
        }
        return result;
    }

    private int adjustPowerOf2(int value) {
        float baseSR = 0.707f;
        while (baseSR > this.sampleRateChange) {
            value /= 2;
            baseSR *= 0.5f;
        }
        while (baseSR * 2.0f < this.sampleRateChange) {
            value *= 2;
            baseSR *= 2.0f;
        }
        return value;
    }

    private int[] adjustPowerOf2(int[] values) {
        int[] result = new int[values.length];
        int i = 0;
        while (i < values.length) {
            result[i] = this.adjustPowerOf2(values[i]);
            ++i;
        }
        return result;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        if (this.quality == 4 || this.quality == 5) {
            this.textureEngine = new TextureLevelTimeEngine(16, this.getInputHopSize() * 2, 4, new float[]{4.0f, 5.0f}, -0.9f, this.adjustPowerOf2(new int[]{1024, 512}), new float[]{1000.0f}, info.getSampleRate());
            this.postGain = (float)AudioMath.dbToLevel((double)-0.3);
        } else if (this.quality == 3) {
            this.textureEngine = new TextureLevelTimeEngine(8, this.getInputHopSize() * 2, 2, new float[]{4.0f, 4.0f}, -1.2f, this.adjustPowerOf2(new int[]{1024, 512}), new float[]{1000.0f}, info.getSampleRate());
        }
    }

    public long getRequiredSamplesBefore(IProcessingInfo info) {
        if (this.quality <= 3) {
            return this.getLatency(IoDirection.INPUT);
        }
        return (long)(info.getSampleRate() / 4.0f);
    }

    public long getRequiredSamplesAfter(IProcessingInfo info) {
        return 0L;
    }

    public int getLatency(IoDirection ioDirection) {
        int result = super.getLatency(ioDirection);
        if (this.textureEngine != null) {
            result = ioDirection == IoDirection.INPUT ? (result += this.textureEngine.getLatency() / 2) : (result += this.textureEngine.getLatency());
        }
        return result;
    }

    public void beginProcessing(IProcessingInfo info) {
        super.beginProcessing(info);
        if (this.textureEngine != null) {
            this.textureEngine.init();
        }
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int step) {
        int i = 1;
        while (i < spectrum.length - 1) {
            Cmplx value = spectrum[i];
            float mag = value.magApprox();
            if (mag > Float.MIN_NORMAL) {
                value.mul(value);
                value.mul(1.0f / mag);
            }
            ++i;
        }
    }

    public void postProcess(float[] chunk) {
        int middle = chunk.length / 2;
        int i = 0;
        while (i < middle) {
            float temp = chunk[i];
            chunk[i] = chunk[i + middle];
            chunk[i + middle] = temp;
            ++i;
        }
    }

    public void postProcess(float[] locked, float[] unlocked) {
        long clock = this.textureEngine.getClock();
        if (unlocked != null) {
            this.noiseDelayer.push(unlocked, clock);
        }
        this.textureEngine.process(locked);
        if (unlocked != null) {
            this.noiseDelayer.pop(unlocked, clock);
        }
        if (this.postGain != 1.0f) {
            int i = 0;
            while (i < locked.length) {
                int n = i++;
                locked[n] = locked[n] * this.postGain;
            }
            i = 0;
            while (i < unlocked.length) {
                int n = i++;
                unlocked[n] = unlocked[n] * this.postGain;
            }
        }
    }

    public void stopProcessing() {
        super.stopProcessing();
        if (this.textureEngine != null) {
            this.textureEngine.stopProcessing();
        }
        this.textureEngine = null;
        this.noiseDelayer = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        super.createSerialSections(factory);
        if (this.textureEngine != null) {
            this.textureEngine.createSerialSections(factory);
            int outSize = this.getInputHopSize() * 2;
            this.noiseDelayer = new ConcurrentDelayBuffer(this.textureEngine.getLatency(), this.textureEngine.getLatency() + outSize * factory.getMtContext().getSerialRunningMaxSkew(), outSize);
            this.delayerSection = factory.createSerialSection(DELAYER_SECTION_NAME, (Object)this.noiseDelayer);
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        super.setSerialSections(pool);
        if (this.textureEngine != null) {
            this.textureEngine.setSerialSections(pool);
            this.delayerSection = pool.getSerialSection(DELAYER_SECTION_NAME);
            this.noiseDelayer = (ConcurrentDelayBuffer)this.delayerSection.getUserData();
        }
    }
}

