/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierPushEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IPostFftProcessor;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Unit;
import org.corebounce.common.math.Cmplx;

@Category(value="Tempo")
@Name(value="Replicator")
@Description(value="Double the length by replicating closely spaced events")
@MultiThreading
@SampleRates(min=8000.0f, max=192000.0f)
public class Replicator
extends FourierPushEffectBase
implements IPostFftProcessor {
    private float period;
    private int quality = 0;

    @Unit(value="s")
    @Order(value=1)
    @Scale(value=ScaleType.LOGARITHMIC, steps=8)
    @Range(minValue=0.25, maxValue=4.0, defaultValue=1.0)
    @Description(value="Max period between which events are replicated")
    public float getPeriod() {
        return this.period;
    }

    public void setPeriod(float period) {
        this.period = period;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=1.0)
    @Description(value="Precision of the result\nHigher values mean better quality but slower processing")
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        int blockSize = (int)(info.getSampleRate() * this.period * 2.0f + 0.5f);
        FourierSpec specs = new FourierSpec(info.getSampleRate());
        specs.setEnergyCorrection(true);
        specs.setPostFftProcessor(this);
        specs.setProcessingType(FourierProcessingType.SIMPLE);
        specs.setAnalysisShrink(2.0f);
        specs.setBaseResolution(blockSize * 2);
        if (this.quality == 0) {
            specs.setOverlap(16.0f);
        } else {
            specs.setOverlap(64.0f);
        }
        specs.setSynthesisShrink(4.0f);
        specs.setOutputHopSize(specs.getInputHopSize() * 2);
        return specs;
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int step) {
        spectrum[0].mul(-1.0f);
        spectrum[spectrum.length - 1].mul(-1.0f);
        int i = 1;
        while (i < spectrum.length - 1) {
            Cmplx value = spectrum[i];
            float mag = value.magApprox();
            if (mag > Float.MIN_NORMAL) {
                value.mul(value);
                value.mul(1.0f / mag);
            }
            ++i;
        }
    }

    public void postProcess(float[] chunk) {
        int middle = chunk.length / 2;
        int i = 0;
        while (i < middle) {
            float temp = chunk[i];
            chunk[i] = chunk[i + middle];
            chunk[i + middle] = temp;
            ++i;
        }
    }
}

