/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime;

import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.common.ParameterDefinition;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPullEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import java.util.Arrays;
import org.corebounce.common.audio.IAudioSource;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.ResamplerFactory;

@Category(value="Tempo")
@Name(value="Resample")
@Description(value="Change the speed, affecting both the pitch and tempo")
public class Resample
implements IPullEffect,
IStartStop,
ILatency,
IAudioSource {
    public static final ParameterDefinition<Resample, Double> RATIO = new ParameterDefinition(Resample.class, Double.class, "ratio");
    public static final ParameterDefinition<Resample, Integer> QUALITY = new ParameterDefinition(Resample.class, Integer.class, "accuracy");
    private static final int BUFFER_SIZE_STD = 8192;
    private static final int BUFFER_SIZE_LOW_LATENCY = 128;
    private double ratio;
    private int accuracy = 3;
    private boolean lowLatency = false;
    private IResampler resampler;
    private float[] sourceBuffer;
    private ISingleChanAudioSource hostSource;

    @Order(value=1)
    @Scale(value=ScaleType.LOGARITHMIC)
    @Range(minValue=0.1, maxValue=10.0, defaultValue=1.0)
    @Name(value="Ratio")
    @Description(value="Ratio between new speed and old speed\nValues greater than one increase the tempo and the pitch\nValues less than one decrease the tempo and the pitch")
    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=5.0, defaultValue=3.0)
    @Name(value="Quality")
    @Description(value="Precision of the result\nHigher values mean better quality but slower processing")
    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(int quality) {
        this.accuracy = quality;
    }

    public int getSamples(float[] target, int offset, int count) {
        int amount = this.hostSource.readSamples(this.sourceBuffer);
        System.arraycopy(this.sourceBuffer, 0, target, offset, amount);
        if (amount < count) {
            Arrays.fill(target, offset + amount, offset + count, 0.0f);
        }
        return amount;
    }

    public void startProcessing(IProcessingInfo info) {
        int bufferSize = this.lowLatency ? 128 : 8192;
        this.resampler = ResamplerFactory.getResampler((IAudioSource)this, (double)(1.0 / this.ratio), (int)this.accuracy, (boolean)false, (int)bufferSize);
        this.sourceBuffer = new float[bufferSize];
    }

    public boolean canWriteFasterThanRead() {
        return this.ratio < 1.0;
    }

    public int getLatency(IoDirection ioDirection) {
        if (ioDirection == IoDirection.INPUT) {
            return this.resampler.getLatency();
        }
        return (int)((double)this.resampler.getLatency() / this.ratio + 0.5);
    }

    public int process(ISingleChanAudioSource source, float[] output) {
        this.hostSource = source;
        return this.resampler.resample(output);
    }

    public void stopProcessing() {
        this.resampler = null;
        this.sourceBuffer = null;
        this.hostSource = null;
    }
}

