/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.old;

import ch.tachyon.sonics.effect.base.old.AdaptivePushEffectBase;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import org.corebounce.common.math.Cmplx;

@Category(value="Tempo")
@Name(value="Adaptive Half Tempo")
@Description(value="Slow down the tempo by 2 without affecting the pitch")
@MultiThreading
public class AdaptiveHalfTempo
extends AdaptivePushEffectBase {
    public void startProcessing(IProcessingInfo info) {
        this.setRotate(true);
        this.setOverlap(16);
        int blockSize = this.getBaseResolution();
        float[] analysisWindow = WindowsFactory.getHannWindow(blockSize, 2.0f);
        float[] synthesisWindow = WindowsFactory.getHannWindow(blockSize, 4.0f);
        this.setAnalysisWindow(analysisWindow);
        this.setSynthesisWindow(synthesisWindow);
        super.startProcessing(info);
    }

    public int getLatency(IoDirection ioDirection) {
        if (ioDirection == IoDirection.INPUT) {
            return super.getLatency(ioDirection) / 2;
        }
        return super.getLatency(ioDirection);
    }

    protected void processSpectrum(Cmplx[] spectrum) {
        spectrum[0].mul(-1.0f);
        spectrum[spectrum.length - 1].mul(-1.0f);
        int i = 1;
        while (i < spectrum.length - 1) {
            Cmplx value = spectrum[i];
            float mag = value.magApprox();
            if (mag > Float.MIN_NORMAL) {
                value.mul(value);
                value.mul(1.0f / mag);
            }
            ++i;
        }
    }
}

