/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.old;

import ch.tachyon.sonics.effect.base.old.MsStftPushEffectBase;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import org.corebounce.common.math.Cmplx;

@Category(value="Tempo")
@Name(value="MS-STFT Half Tempo")
@Description(value="Slow down the tempo by 2 without affecting the pitch")
@MultiThreading
public class MsStftHalfTempo
extends MsStftPushEffectBase {
    private float[] phases;

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.phases = new float[super.getNbBins()];
    }

    public int getLatency(IoDirection ioDirection) {
        if (ioDirection == IoDirection.INPUT) {
            return super.getLatency(ioDirection) / 2;
        }
        return super.getLatency(ioDirection);
    }

    protected void processSpectrum(Cmplx[] source, Cmplx[][] spectrums) {
        int i = 0;
        while (i < source.length) {
            float phase = source[i].phi();
            this.phases[i] = phase * 2.0f;
            ++i;
        }
        int r = 0;
        while (r < spectrums.length) {
            Cmplx[] spectrum = spectrums[r];
            spectrum[0].mul(-1.0f);
            spectrum[spectrum.length - 1].mul(-1.0f);
            int i2 = 1;
            while (i2 < spectrum.length - 1) {
                float magnitude = spectrum[i2].magApprox();
                spectrum[i2].set(magnitude, this.phases[i2]);
                spectrum[i2].toCartesianApprox();
                ++i2;
            }
            ++r;
        }
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.phases = null;
    }
}

