/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.old;

import ch.tachyon.sonics.effect.base.stft.StftAnalyzerMulti;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizerMulti;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.sonics.effect.base.stft.old.StftAnalyzerAccu;
import ch.tachyon.sonics.effect.base.stft.old.StftPushEffectBase;
import ch.tachyon.sonics.effect.base.stft.old.StftSynthesizerAccu;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

@Category(value="Tempo")
@Name(value="Simple Half Tempo")
@Description(value="Slow down the tempo by 2 without affecting the pitch")
@MultiThreading
public class SimpleHalfTempo
extends StftPushEffectBase {
    private static final int BLOCK_SIZE_0 = 4096;
    private static final int BLOCK_SIZE_1 = 8192;
    private static final int OVERLAP_OUT_0 = 2;
    private static final int OVERLAP_OUT_1 = 8;
    private static final int OVERLAP_OUT_2 = 64;
    private static final int MAX_QUALITY = 2;
    private int quality = 1;
    private int shrinkLatency;

    @Order(value=1)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    @Name(value="Accuracy")
    @Description(value="Accuracy of the result\nHigher values mean better quality but slower processing")
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    @Order(value=2)
    @Name(value="NUMA Mode")
    @Description(value="Experimental - Optimize for NUMA architectures")
    public boolean isAccuMode() {
        return super.isAccuMode();
    }

    public void setAccuMode(boolean accuMode) {
        super.setAccuMode(accuMode);
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public void startProcessing(IProcessingInfo info) {
        float[] synthesisWindow;
        float[] analysisWindow;
        int blockSize;
        int n = blockSize = this.quality == 0 ? 4096 : 8192;
        if (this.quality == 0) {
            this.shrinkLatency = 0;
            analysisWindow = WindowsFactory.getHannWindow(blockSize);
            synthesisWindow = WindowsFactory.getHannWindow(blockSize);
            float[] convolved = new float[blockSize * 2];
            float[] HannSelfConvolvedCoefs = new float[]{0.25f, -0.18f, 0.0625f, -0.00719f};
            Windows.fillWindow((float[])convolved, (float[])HannSelfConvolvedCoefs);
            float[] modifiedWindow = new float[blockSize];
            int i = 0;
            while (i < blockSize) {
                modifiedWindow[i] = convolved[i + blockSize / 2] + convolved[(i + blockSize * 3 / 2) % convolved.length];
                ++i;
            }
            super.setModifiedWindow(modifiedWindow);
        } else {
            this.shrinkLatency = blockSize / 4;
            analysisWindow = WindowsFactory.getHannWindow(blockSize, 2.0f);
            synthesisWindow = WindowsFactory.getHannWindow(blockSize, 4.0f);
            super.setShrinkEnergyCorrection(4.0f);
        }
        int overlapOut = this.quality == 0 ? 2 : (this.quality == 1 ? 8 : 64);
        super.setBlockSizeLog(AudioMath.log2((int)blockSize));
        super.setOverlapInLog(AudioMath.log2((int)(overlapOut * 2)));
        super.setOverlapOutLog(AudioMath.log2((int)overlapOut));
        super.setAnalysisWindow(analysisWindow);
        super.setSynthesisWindow(synthesisWindow);
        super.startProcessing(info);
    }

    public int getLatency(IoDirection ioDirection) {
        if (ioDirection == IoDirection.INPUT) {
            return super.getLatency(ioDirection) / 2 + this.shrinkLatency;
        }
        return super.getLatency(ioDirection) + this.shrinkLatency * 2;
    }

    protected void processSpectrum(Cmplx[] spectrum) {
        spectrum[0].mul(-1.0f);
        spectrum[spectrum.length - 1].mul(-1.0f);
        int i = 1;
        while (i < spectrum.length - 1) {
            Cmplx value = spectrum[i];
            float mag = value.magApprox();
            if (mag > Float.MIN_NORMAL) {
                value.mul(value);
                value.mul(1.0f / mag);
            }
            ++i;
        }
    }

    protected StftPushEffectBase.AbstractStftEngine newAccuStftEngine() {
        return new StftPushEffectBase.AccuStftEngine(this){

            protected void createEngine(int blockSize, int inHopSize, int outHopSize, int numHops, float[] analysisWindow, float[] modifiedWindow, float[] synthesisWindow, float shrinkEnergyCorrection) {
                this.analyzer = new StftAnalyzerAccu(blockSize, inHopSize, numHops, analysisWindow);
                this.synthesizer = new StftSynthesizerAccu(blockSize, outHopSize, numHops, modifiedWindow, synthesisWindow){

                    protected void backwardFFT(Cmplx[] spectrum, float[] output) {
                        super.backwardFFT(spectrum, output);
                        int middle = this.blockSize / 2;
                        int i = 0;
                        while (i < middle) {
                            float temp = output[i];
                            output[i] = -output[i + middle];
                            output[i + middle] = -temp;
                            ++i;
                        }
                    }
                };
            }
        };
    }

    protected StftPushEffectBase.AbstractStftEngine newParallelStftEngine() {
        return new StftPushEffectBase.ParallelStftEngine(this){

            protected void createEngine(int blockSize, int inHopSize, int outHopSize, int numHops, float[] analysisWindow, float[] modifiedWindow, float[] synthesisWindow, float shrinkEnergyCorrection) {
                this.analyzer = new StftAnalyzerMulti(blockSize, inHopSize, numHops, analysisWindow, false);
                this.synthesizer = new StftSynthesizerMulti(blockSize, outHopSize, numHops, modifiedWindow, synthesisWindow, shrinkEnergyCorrection, true){

                    protected void backwardFFT(Cmplx[] spectrum, float[] output) {
                        super.backwardFFT(spectrum, output);
                        int middle = this.getBlockSize() / 2;
                        int i = 0;
                        while (i < middle) {
                            float temp = output[i];
                            output[i] = -output[i + middle];
                            output[i + middle] = -temp;
                            ++i;
                        }
                    }
                };
                this.output = new float[this.synthesizer.getOutputSize()];
            }
        };
    }
}

