/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.stft.old.StftAnalyzerAccu;
import ch.tachyon.sonics.effect.base.stft.old.StftSynthesizerAccu;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.PowerOfTwoTransform;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Transform;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

@Category(value="Tempo")
@Name(value="Tempo Divider Accu")
@Description(value="Slow down the tempo by 2, 4, 8 or 16 without affecting the pitch")
public class TempoDividerAccu
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private static final int BLOCK_SIZE = 4096;
    private static final int OVERLAP_OUT_0 = 2;
    private static final int OVERLAP_OUT_1 = 16;
    private static final int MAX_QUALITY = 1;
    private int logRatio = 1;
    private int ratio = 2;
    private int quality = 0;
    private StftAnalyzerAccu analyzer = null;
    private StftSynthesizerAccu synthesizer = null;
    private int shrinkLatency;

    @Order(value=1)
    @Range(minValue=1.0, maxValue=4.0, defaultValue=1.0)
    @Transform(value=PowerOfTwoTransform.class)
    @Name(value="Ratio")
    @Description(value="Amount by which to divide the tempo\nThe result will be that time longer")
    public int getRatio() {
        return this.logRatio;
    }

    public void setRatio(int ratio) {
        this.logRatio = ratio;
        this.ratio = 1 << ratio;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=0.0)
    @Name(value="Accuracy")
    @Description(value="Accuracy of the result\nHigher values mean better quality but slower processing")
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public void startProcessing(IProcessingInfo info) {
        int targetSize = 4096 * this.ratio;
        int blockSize = 4096;
        int shrink = 1;
        while (blockSize < targetSize) {
            blockSize *= 2;
            shrink *= 2;
        }
        int overlapMult = Math.max(4, shrink);
        this.shrinkLatency = (blockSize - blockSize / shrink) / 2;
        float[] analysisWindow = new float[blockSize];
        float[] synthesisWindow = new float[blockSize];
        Windows.fillShrunkWindow((float[])analysisWindow, (float[])Windows.HannCoefs, (float)shrink);
        Windows.fillShrunkWindow((float[])synthesisWindow, (float[])Windows.HannCoefs, (float)1.0f);
        int overlapOut = this.quality == 0 ? 2 : 16;
        int inHopSize = blockSize / (overlapOut * overlapMult * this.ratio);
        int numHops = 1;
        int chunkLength = info.getHostPreferredChunkLength();
        if (chunkLength > 0 && (numHops = chunkLength / inHopSize) < 1) {
            numHops = 1;
        }
        info.negociateFixedChunkLength(inHopSize * numHops);
        this.analyzer = new StftAnalyzerAccu(blockSize, inHopSize, numHops, analysisWindow);
        this.synthesizer = new StftSynthesizerAccu(blockSize, blockSize / (overlapOut * overlapMult), numHops, analysisWindow, synthesisWindow){

            protected void backwardFFT(Cmplx[] spectrum, float[] output) {
                super.backwardFFT(spectrum, output);
                if (TempoDividerAccu.this.ratio % 2 == 0) {
                    int middle = this.blockSize / 2;
                    int i = 0;
                    while (i < middle) {
                        float temp = output[i];
                        output[i] = -output[i + middle];
                        output[i + middle] = -temp;
                        ++i;
                    }
                }
            }
        };
    }

    public int getFixedChunkLength() {
        int result = this.analyzer.getInputSize();
        return result;
    }

    public int getLatency(IoDirection ioDirection) {
        if (ioDirection == IoDirection.INPUT) {
            return this.synthesizer.getLatency() / this.ratio + this.shrinkLatency;
        }
        return this.synthesizer.getLatency() + this.shrinkLatency * this.ratio;
    }

    public void beginProcessing(IProcessingInfo info) {
        this.analyzer.init();
        this.synthesizer.init();
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        if (length < input.length) {
            this.synthesizer.setLastBufferInfo(length * this.ratio, this.analyzer.getMyClock());
        }
        int baseIndex = this.analyzer.pushNextInput(input);
        while (baseIndex >= 0) {
            Cmplx[][] spectrums;
            Cmplx[][] cmplxArray = spectrums = this.analyzer.analyze(baseIndex);
            int n = spectrums.length;
            int n2 = 0;
            while (n2 < n) {
                float mag;
                Cmplx value;
                int i;
                Cmplx[] spectrum = cmplxArray[n2];
                if (this.ratio == 2) {
                    spectrum[0].mul(-1.0f);
                    spectrum[spectrum.length - 1].mul(-1.0f);
                    i = 1;
                    while (i < spectrum.length - 1) {
                        value = spectrum[i];
                        mag = value.magApprox();
                        if (mag > Float.MIN_NORMAL) {
                            value.mul(value);
                            value.mul(1.0f / mag);
                        }
                        ++i;
                    }
                } else {
                    i = 1;
                    while (i < spectrum.length - 1) {
                        value = spectrum[i];
                        mag = value.magApprox();
                        if (mag > Float.MIN_NORMAL) {
                            int k = 0;
                            while (k < this.logRatio) {
                                value.mul(value);
                                value.mul(1.0f / mag);
                                ++k;
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            this.synthesizer.backwardStft(this.analyzer.getCurrentClock(), spectrums);
            float[] output = this.synthesizer.overlapAddNext(this.analyzer.getCurrentClock(), this.analyzer.getCurrentClock());
            while (output != null) {
                this.synthesizer.writeOutput(output, target);
                output = this.synthesizer.overlapAddNext(this.analyzer.getCurrentClock(), null);
            }
            baseIndex = this.analyzer.pushNextInput(null);
        }
    }

    public void stopProcessing() {
        this.analyzer = null;
        this.synthesizer = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
    }
}

