/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.stft.old.StftAnalyzerNuma;
import ch.tachyon.sonics.effect.base.stft.old.StftSynthesizerNuma;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IMultiStep;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.PowerOfTwoTransform;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Transform;
import java.util.BitSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Category(value="Tempo")
@Name(value="Tempo Divider Numa")
@Description(value="Slow down the tempo by 2, 4, 8 or 16 without affecting the pitch")
public class TempoDividerNuma
extends EffectBase
implements IPushEffect,
IStartStop,
IFixedChunkLength,
ILatency,
IMultiStep {
    private static final int BLOCK_SIZE = 4096;
    private static final int OVERLAP_OUT_0 = 2;
    private static final int OVERLAP_OUT_1 = 16;
    private static final int MAX_QUALITY = 1;
    int logRatio = 1;
    int ratio = 2;
    int quality = 0;
    StftAnalyzerNuma analyzer = null;
    StftSynthesizerNuma synthesizer = null;
    float[] output = null;
    int shrinkLatency;
    transient float[] input;
    transient int length;
    transient ISingleChanAudioSink target;
    transient Cmplx[] spectrum;
    private static final AtomicLong idGen = new AtomicLong();
    private final long id = idGen.getAndIncrement();

    @Order(value=1)
    @Range(minValue=1.0, maxValue=4.0, defaultValue=1.0)
    @Transform(value=PowerOfTwoTransform.class)
    @Name(value="Ratio")
    @Description(value="Amount by which to divide the tempo\nThe result will be that time longer")
    public int getRatio() {
        return this.logRatio;
    }

    public void setRatio(int ratio) {
        this.logRatio = ratio;
        this.ratio = 1 << ratio;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=0.0)
    @Name(value="Accuracy")
    @Description(value="Accuracy of the result\nHigher values mean better quality but slower processing")
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public void startProcessing(IProcessingInfo info) {
        int targetSize = 4096 * this.ratio;
        int blockSize = 4096;
        int shrink = 1;
        while (blockSize < targetSize) {
            blockSize *= 2;
            shrink *= 2;
        }
        int overlapMult = Math.max(4, shrink);
        this.shrinkLatency = (blockSize - blockSize / shrink) / 2;
        float[] analysisWindow = new float[blockSize];
        float[] synthesisWindow = new float[blockSize];
        Windows.fillShrunkWindow((float[])analysisWindow, (float[])Windows.HannCoefs, (float)shrink);
        Windows.fillShrunkWindow((float[])synthesisWindow, (float[])Windows.HannCoefs, (float)1.0f);
        int overlapOut = this.quality == 0 ? 2 : 16;
        this.analyzer = new StftAnalyzerNuma(blockSize, blockSize / (overlapOut * overlapMult * this.ratio), analysisWindow);
        this.synthesizer = new StftSynthesizerNuma(blockSize, blockSize / (overlapOut * overlapMult), analysisWindow, synthesisWindow){

            public void backwardFFT() {
                super.backwardFFT();
                if (TempoDividerNuma.this.ratio % 2 == 0) {
                    int middle = this.blockSize / 2;
                    int i = 0;
                    while (i < middle) {
                        float temp = this.outputBlock[i];
                        this.outputBlock[i] = -this.outputBlock[i + middle];
                        this.outputBlock[i + middle] = -temp;
                        ++i;
                    }
                }
            }
        };
        this.output = new float[this.synthesizer.getHopSize()];
    }

    public int getFixedChunkLength() {
        return this.analyzer.getHopSize();
    }

    public int getLatency(IoDirection ioDirection) {
        if (ioDirection == IoDirection.INPUT) {
            return this.synthesizer.getLatency() / this.ratio + this.shrinkLatency;
        }
        return this.synthesizer.getLatency() + this.shrinkLatency * this.ratio;
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        this.input = input;
        this.length = length;
        this.target = target;
        this.analyzer.setInput(input);
    }

    void processSpectrum() {
        int kk = 0;
        while (kk < 1) {
            float mag;
            Cmplx value;
            int i;
            if (this.ratio == 2) {
                this.spectrum[0].mul(-1.0f);
                this.spectrum[this.spectrum.length - 1].mul(-1.0f);
                i = 1;
                while (i < this.spectrum.length - 1) {
                    value = this.spectrum[i];
                    mag = value.magApprox();
                    if (mag > Float.MIN_NORMAL) {
                        value.mul(value);
                        value.mul(1.0f / mag);
                    }
                    ++i;
                }
            } else {
                i = 1;
                while (i < this.spectrum.length - 1) {
                    value = this.spectrum[i];
                    mag = value.magApprox();
                    if (mag > Float.MIN_NORMAL) {
                        int k = 0;
                        while (k < this.logRatio) {
                            value.mul(value);
                            value.mul(1.0f / mag);
                            ++k;
                        }
                    }
                    ++i;
                }
            }
            ++kk;
        }
    }

    void sendResult() {
        if (this.length == this.input.length) {
            this.target.writeSamples(this.output);
        } else {
            int outLength = this.length * this.ratio;
            assert (outLength < this.output.length);
            float[] lastOutput = new float[outLength];
            System.arraycopy(this.output, 0, lastOutput, 0, outLength);
            this.target.writeSamples(lastOutput);
        }
        this.input = null;
        this.target = null;
    }

    public void stopProcessing() {
        this.analyzer = null;
        this.synthesizer = null;
        this.output = null;
    }

    public Runnable[] getAdditionalSteps() {
        Runnable[] steps = new Runnable[]{new Runnable(){

            public void run() {
                TempoDividerNuma.this.analyzer.pushInput();
            }
        }, new Runnable(){

            public void run() {
                TempoDividerNuma.this.analyzer.fetchInputBlock();
                TempoDividerNuma.this.analyzer.applyAnalysisWindow();
                TempoDividerNuma.this.analyzer.forwardFFT();
                TempoDividerNuma.this.spectrum = TempoDividerNuma.this.analyzer.getSpectrum();
                TempoDividerNuma.this.processSpectrum();
                TempoDividerNuma.this.synthesizer.setInOut(TempoDividerNuma.this.spectrum, TempoDividerNuma.this.output);
            }
        }, new Runnable(){

            public void run() {
                TempoDividerNuma.this.synthesizer.setupOutputBuffer();
            }
        }, new Runnable(){

            public void run() {
                TempoDividerNuma.this.synthesizer.backwardFFT();
                TempoDividerNuma.this.synthesizer.applySynthesisWindow();
            }
        }, new Runnable(){

            public void run() {
                TempoDividerNuma.this.synthesizer.sync();
            }
        }, new Runnable(){

            public void run() {
                TempoDividerNuma.this.synthesizer.overlapAdd();
                TempoDividerNuma.this.sendResult();
            }
        }};
        return steps;
    }

    public BitSet getSerialSteps() {
        BitSet result = new BitSet(6);
        result.set(0);
        result.set(2);
        result.set(4);
        return result;
    }

    public int getMinInputHistorySize() {
        return this.analyzer.getOverlap();
    }

    public void setupCommonData(Map<String, Object> data) {
        this.analyzer.setupCommonData(data);
        this.synthesizer.setupCommonData(data);
    }

    public String toString() {
        return "TempoDividerNuma [id=" + this.id + "]";
    }
}

