/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.scientific;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.ITimeLocal;
import ch.tachyon.tunnel.plugin.opt.thread.Live;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Sweepable;
import ch.tachyon.tunnel.plugin.param.Unit;
import java.util.Random;

@Category(value="Scientific")
@Name(value="Bit Quantizer")
@Description(value="Simulate quantization by the given number of bits")
@Live
@MultiThreading
public class BitQuantizer
extends EffectBase
implements ISimpleEffect,
IStartStop,
ITimeLocal {
    private final double[] b = new double[]{2.2061, -0.4706, -0.2534, -0.6214};
    private final double[] a = new double[]{-1.0587, -0.0676, 0.6054, 0.2738};
    private float bits = 8.0f;
    private boolean dither = false;
    private ShapingType shaping = ShapingType.NONE;
    private Random rnd;
    private double multiplier;
    private double curError;
    private double[] xOld;
    private double[] yOld;

    @Sweepable
    @Order(value=1)
    @Unit(value="bits")
    @Scale(value=ScaleType.CUBEROOT)
    @Range(minValue=0.1, maxValue=24.0, defaultValue=8.0)
    @Name(value="Quantization")
    @Description(value="Number of quantization bits")
    public float getBits() {
        return this.bits;
    }

    public void setBits(float bits) {
        this.bits = bits;
        this.multiplier = (float)Math.pow(2.0, bits);
    }

    @Sweepable
    @Order(value=2)
    @Name(value="Dither")
    @Description(value="Whether to add dither")
    public boolean isDither() {
        return this.dither;
    }

    public void setDither(boolean dither) {
        this.dither = dither;
    }

    @Sweepable
    @Order(value=3)
    @Name(value="Noise Shaping")
    @Description(value="Frequency curve to apply to the dither noise")
    public ShapingType getShaping() {
        return this.shaping;
    }

    public void setShaping(ShapingType shaping) {
        this.shaping = shaping;
    }

    public void startProcessing(IProcessingInfo info) {
        this.rnd = new Random();
        this.curError = 0.0;
        if (this.shaping == ShapingType.ATH) {
            this.xOld = new double[4];
            this.yOld = new double[4];
        }
    }

    public int getRequiredFramesBefore(IProcessingInfo info) {
        return 5;
    }

    public int getRequiredFramesAfter(IProcessingInfo info) {
        return 0;
    }

    public void process(float[] data) {
        int i = 0;
        while (i < data.length) {
            double input;
            double value;
            double noise = -this.curError;
            if (this.dither) {
                noise += (this.rnd.nextDouble() - this.rnd.nextDouble()) / this.multiplier;
            }
            if (this.shaping == ShapingType.ATH) {
                double res = 0.0;
                this.xOld[0] = noise;
                int k = 0;
                while (k < 4) {
                    res += this.b[k] * this.xOld[k] + this.a[k] * this.yOld[k];
                    ++k;
                }
                k = 3;
                while (k > 0) {
                    this.xOld[k] = this.xOld[k - 1];
                    this.yOld[k] = this.yOld[k - 1];
                    --k;
                }
                this.yOld[0] = res /= this.b[0];
                noise = res;
            }
            value = (value = (input = (double)data[i] + noise) * this.multiplier) >= 0.0 ? (int)(value + 0.5) : (int)(value - 0.5);
            if (this.multiplier > 1.0) {
                value /= this.multiplier;
            }
            if (this.shaping != ShapingType.NONE) {
                this.curError = value - input;
            }
            data[i] = (float)value;
            ++i;
        }
    }

    public void stopProcessing() {
        this.rnd = null;
        this.xOld = null;
        this.yOld = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShapingType {
        NONE("No Shaping"),
        ERROR("Error Correction"),
        ATH("ATH Shape");

        private final String name;

        private ShapingType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

