/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.scientific;

import ch.tachyon.sonics.effect.PowerOf2;
import ch.tachyon.sonics.effect.base.stft.old.StftSimpleEffectBase;
import ch.tachyon.sonics.effect.filters.FftFilter;
import ch.tachyon.tunnel.common.ParameterDefinition;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.thread.Live;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.SampleRateTransform;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Sweepable;
import ch.tachyon.tunnel.plugin.param.Transform;
import ch.tachyon.tunnel.plugin.param.Unit;
import java.util.Arrays;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

@Category(value="Scientific")
@Name(value="Brickwall Band-Pass")
@Description(value="Brickwall band-pass filter with linear phase\nKeep only frequencies between the low and high cut frequencies\nCan also be used as band-stop, low-pass or high-pass filter\nImplemented using FIR filtering and FFT")
@Live
@MultiThreading
public class BrickwallFirFilter
extends StftSimpleEffectBase {
    private static final int OVERLAP = 2;
    public static final ParameterDefinition<FftFilter, Float> LOW_CUT = new ParameterDefinition(FftFilter.class, Float.class, "lowCut");
    public static final ParameterDefinition<FftFilter, Float> HIGH_CUT = new ParameterDefinition(FftFilter.class, Float.class, "highCut");
    public static final ParameterDefinition<FftFilter, PowerOf2> FFT_SIZE = new ParameterDefinition(FftFilter.class, PowerOf2.class, "fftSize");
    private float lowCut;
    private float highCut;
    private PowerOf2 fftSize;
    private Cmplx[] cmplxCurve;
    private int bin1;
    private int bin2;

    @Order(value=1)
    @Unit(value="Hz")
    @Sweepable
    @Scale(value=ScaleType.LOGARITHMIC)
    @Transform(value=SampleRateTransform.class)
    @Range(minValue=0.0, maxValue=0.5, defaultValue=0.01)
    @Name(value="Low Cut")
    @Description(value="Low cut frequency\nFrequencies below the given value will be removed")
    public float getLowCut() {
        return this.lowCut;
    }

    public void setLowCut(float lowCut) {
        this.lowCut = lowCut;
    }

    @Order(value=2)
    @Unit(value="Hz")
    @Sweepable
    @Scale(value=ScaleType.LOGARITHMIC)
    @Transform(value=SampleRateTransform.class)
    @Range(minValue=0.0, maxValue=0.5, defaultValue=0.1)
    @Name(value="High Cut")
    @Description(value="High cut frequency\nFrequencies above the given value will be removed")
    public float getHighCut() {
        return this.highCut;
    }

    public void setHighCut(float highCut) {
        this.highCut = highCut;
    }

    @Order(value=3)
    @Range(minValue=6.0, maxValue=19.0, defaultValue=9.0)
    @Name(value="Kernel Size")
    @Description(value="Size of the FIR kernel\nSmaller values mean higher time resolution and lower frequency resolution.\nHigher values mean higher frequency resolution and lower time resolution.")
    public PowerOf2 getFftSize() {
        return this.fftSize;
    }

    public void setFftSize(PowerOf2 fftSize) {
        this.fftSize = fftSize;
    }

    public void startProcessing(IProcessingInfo info) {
        super.setBlockSizeLog(this.fftSize.getLog2() + 1);
        float[] analysisWindow = new float[this.fftSize.intValue() * 2];
        Arrays.fill(analysisWindow, this.fftSize.intValue() / 2, this.fftSize.intValue() * 3 / 2, 1.0f);
        super.setAnalysisWindow(analysisWindow);
        float[] synthesisWindow = new float[this.fftSize.intValue() * 2];
        Arrays.fill(synthesisWindow, 1.0f);
        super.setSynthesisWindow(synthesisWindow);
        super.setOverlapLog(AudioMath.log2((int)2));
        super.startProcessing(info);
        if (this.lowCut <= this.highCut) {
            this.bin1 = this.cut2bin(this.lowCut, 1);
            this.bin2 = this.cut2bin(this.highCut, -1);
        } else {
            this.bin1 = this.cut2bin(this.lowCut, -1);
            this.bin2 = this.cut2bin(this.highCut, 1);
        }
        Cmplx[] freqFilter = Cmplx.newArray((int)(this.fftSize.intValue() / 2 + 1));
        int i = 0;
        while (i < freqFilter.length) {
            if (i < this.bin1 != i > this.bin2) {
                freqFilter[i].set(0.0f, 0.0f);
            } else {
                freqFilter[i].set(1.0f, 0.0f);
            }
            ++i;
        }
        float[] timeFilter = new float[this.fftSize.intValue()];
        BooFFT.getInstance((int)(this.fftSize.intValue() / 2)).backC2R(freqFilter, timeFilter);
        this.rotate(timeFilter);
        float[] hann = new float[timeFilter.length];
        Windows.fillWindow((float[])hann, (float[])Windows.HannCoefs);
        float[] zeroPaddedFilter = new float[timeFilter.length * 2];
        int i2 = 0;
        while (i2 < timeFilter.length) {
            zeroPaddedFilter[i2 + timeFilter.length / 2] = timeFilter[i2] * hann[i2] * 2.0f;
            ++i2;
        }
        this.rotate(zeroPaddedFilter);
        this.cmplxCurve = Cmplx.newArray((int)this.getNbBins());
        BooFFT.getInstance((int)this.fftSize.intValue()).forwR2C(zeroPaddedFilter, this.cmplxCurve);
    }

    private void rotate(float[] data) {
        int middle = data.length / 2;
        int i = 0;
        while (i < middle) {
            float temp = data[i];
            data[i] = data[i + middle];
            data[i + middle] = temp;
            ++i;
        }
    }

    private int cut2bin(float freq, int rounding) {
        int nbBins = this.fftSize.intValue() / 2 + 1;
        float offset = (float)(rounding + 1) * 0.4999f;
        int result = (int)(freq * (float)this.fftSize.intValue() + offset);
        if (result < 0) {
            result = 0;
        } else if (result >= nbBins) {
            result = nbBins - 1;
        }
        return result;
    }

    protected void processSpectrum(Cmplx[] spectrum) {
        int i = 0;
        while (i < spectrum.length) {
            spectrum[i].mul(this.cmplxCurve[i]);
            ++i;
        }
    }
}

