/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.scientific;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.thread.Live;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;

@Category(value="Scientific")
@Name(value="Spectral Inverter")
@Description(value="Invert the spectrum.\nMultiplies the samples by the [1, -1] serie")
@Live
@MultiThreading
public class SpectralInverter
extends EffectBase
implements ISimpleEffect,
IStartStop {
    private int phase = 0;

    public void startProcessing(IProcessingInfo info) {
        this.phase = 1;
    }

    public void process(float[] data) {
        int i = this.phase;
        while (i < data.length) {
            int n = i;
            data[n] = data[n] * -1.0f;
            i += 2;
        }
        if (data.length % 2 == 1) {
            this.phase = 1 - this.phase;
        }
    }

    public void stopProcessing() {
    }
}

