/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.utils.BitSetMedianBuffer;
import ch.tachyon.sonics.effect.utils.PeakPicker;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Unit;
import java.util.BitSet;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

@Category(value="Separation")
@Name(value="Foreground SPlitter")
@Description(value="Split foreground and background sounds\n(experimental)")
public class ForegroundSplitter
extends FourierSimpleEffectBase
implements IStartStop {
    private float separation;
    private int distance;
    private int median;
    private float foregroundLevel;
    private float backgroundLevel;
    private float[] powerMags;
    private BitSetMedianBuffer medianBuffer;

    @Order(value=1)
    @Unit(value="dB")
    @Range(minValue=0.0, maxValue=60.0, defaultValue=15.0)
    public float getSeparation() {
        return this.separation;
    }

    public void setSeparation(float separation) {
        this.separation = separation;
    }

    @Order(value=2)
    @Range(minValue=1.0, maxValue=10.0, defaultValue=3.0)
    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    @Order(value=3)
    @Range(minValue=0.0, maxValue=20.0, defaultValue=8.0)
    public int getMedian() {
        return this.median;
    }

    public void setMedian(int median) {
        this.median = median;
    }

    @Order(value=4)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=1.0)
    public float getForegroundLevel() {
        return this.foregroundLevel;
    }

    public void setForegroundLevel(float foregroundLevel) {
        this.foregroundLevel = foregroundLevel;
    }

    @Order(value=5)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=0.0)
    public float getBackgroundLevel() {
        return this.backgroundLevel;
    }

    public void setBackgroundLevel(float backgroundLevel) {
        this.backgroundLevel = backgroundLevel;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec();
        specs.setBaseResolution(4096);
        return specs;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.powerMags = new float[super.getNbBins()];
        int width = this.median * 2 + 1;
        int height = 7;
        this.medianBuffer = new BitSetMedianBuffer(this.getNbBins(), width, height, width * height / 2, width * height / 2);
    }

    public int getLatency(IoDirection ioDirection) {
        int result = super.getLatency(ioDirection);
        return result += super.getInputHopSize() * this.median;
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.powerMags = null;
        this.medianBuffer = null;
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int stepNum) {
        int nbBins = spectrum.length;
        PeakPicker.fillPowerMags(spectrum, this.powerMags);
        PeakPicker picker = new PeakPicker(nbBins);
        picker.pick(this.powerMags);
        float ratio = (float)AudioMath.dbToPowerLevel((double)(-this.separation));
        BitSet foregroundPeaks = new BitSet();
        int i = 0;
        while (i < picker.getNbPeaks()) {
            int location = picker.getPeakLocation(i);
            float peakValue = this.powerMags[location];
            float maxValue = peakValue * ratio;
            int lower = picker.getPeakLowerBound(i);
            int upper = picker.getPeakUpperBound(i);
            boolean foreground = true;
            int j = 1;
            while (j <= this.distance) {
                int leftPos = location - j;
                if (leftPos < lower && leftPos >= 0 && this.powerMags[leftPos] > maxValue) {
                    foreground = false;
                    break;
                }
                int rightPos = location + j;
                if (rightPos >= upper && rightPos < nbBins && this.powerMags[rightPos] > maxValue) {
                    foreground = false;
                    break;
                }
                ++j;
            }
            foregroundPeaks.set(i, foreground);
            ++i;
        }
        BitSet foregroundBins = new BitSet(nbBins);
        int peakIndex = 0;
        int i2 = 0;
        while (i2 < nbBins) {
            foregroundBins.set(i2, foregroundPeaks.get(peakIndex));
            if (i2 + 1 == picker.getPeakUpperBound(peakIndex)) {
                ++peakIndex;
            }
            ++i2;
        }
        assert (peakIndex == picker.getNbPeaks());
        this.medianBuffer.push(foregroundBins, spectrum);
        foregroundBins = this.medianBuffer.pop(spectrum);
        i2 = 0;
        while (i2 < nbBins) {
            if (foregroundBins.get(i2)) {
                spectrum[i2].mul(this.foregroundLevel);
            } else {
                spectrum[i2].mul(this.backgroundLevel);
            }
            ++i2;
        }
    }
}

