/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import ch.tachyon.sonics.effect.base.adaptive.TransientExtractor;
import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.PowerOfTwoTransform;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Transform;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

@Category(value="Separation")
@Name(value="Knife Splitter")
@Description(value="Split long and short sounds")
@MultiThreading
public class KnifeSplitter
extends FourierSimpleEffectBase
implements IHasSerialSections {
    private int blockSizeLog = 7;
    private int hopSizeLog = 5;
    private int minimizerLength = 24;
    private int averagerLength = 20;
    private double sensitivity = 5.0;
    private double attackSpeed = 1.0;
    private int minSpan = 15;
    private int spread = 3;
    private boolean hard = false;
    private float maxJump = 50.0f;
    private boolean keepLong;
    private TransientExtractor engine;
    private Cmplx[] dropx;

    @Range(minValue=4.0, maxValue=16.0)
    @Transform(value=PowerOfTwoTransform.class)
    @Order(value=0)
    public int getBlockSizeLog() {
        return this.blockSizeLog;
    }

    public void setBlockSizeLog(int blockSize) {
        this.blockSizeLog = blockSize;
    }

    @Range(minValue=2.0, maxValue=14.0)
    @Transform(value=PowerOfTwoTransform.class)
    @Order(value=1)
    public int getHopSizeLog() {
        return this.hopSizeLog;
    }

    public void setHopSizeLog(int hopSize) {
        this.hopSizeLog = hopSize;
    }

    @Range(minValue=2.0, maxValue=50.0)
    @Order(value=2)
    public int getMinimizerLength() {
        return this.minimizerLength;
    }

    public void setMinimizerLength(int minimizerLength) {
        this.minimizerLength = minimizerLength;
    }

    @Range(minValue=2.0, maxValue=50.0)
    @Order(value=3)
    public int getAveragerLength() {
        return this.averagerLength;
    }

    public void setAveragerLength(int averagerLength) {
        this.averagerLength = averagerLength;
    }

    @Range(minValue=-20.0, maxValue=30.0)
    @Order(value=4)
    public double getSensitivity() {
        return this.sensitivity;
    }

    public void setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
    }

    @Scale(value=ScaleType.LOGARITHMIC)
    @Range(minValue=0.1, maxValue=10.0)
    @Order(value=6)
    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    public void setAttackSpeed(double attackSpeed) {
        this.attackSpeed = attackSpeed;
    }

    @Range(minValue=1.0, maxValue=50.0)
    @Order(value=7)
    public int getMinSpan() {
        return this.minSpan;
    }

    public void setMinSpan(int minSpan) {
        this.minSpan = minSpan;
    }

    @Range(minValue=0.0, maxValue=20.0)
    @Order(value=8)
    public int getSpread() {
        return this.spread;
    }

    public void setSpread(int spread) {
        this.spread = spread;
    }

    @Order(value=9)
    public boolean isHard() {
        return this.hard;
    }

    public void setHard(boolean hard) {
        this.hard = hard;
    }

    @Range(minValue=1.0, maxValue=120.0)
    @Order(value=10)
    public float getMaxJump() {
        return this.maxJump;
    }

    public void setMaxJump(float maxJump) {
        this.maxJump = maxJump;
    }

    @Order(value=11)
    public boolean isKeepLong() {
        return this.keepLong;
    }

    public void setKeepLong(boolean keepLong) {
        this.keepLong = keepLong;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec();
        specs.setProcessingType(FourierProcessingType.SIMPLE);
        specs.setBaseResolution(1 << this.blockSizeLog);
        specs.setOverlap((1 << this.blockSizeLog) / (1 << this.hopSizeLog));
        specs.setMultihop(false);
        return specs;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.engine = new TransientExtractor("knife", 1, 1, this.getNbBins(), this.minimizerLength, this.averagerLength, this.sensitivity, this.attackSpeed, this.minSpan, this.spread, this.hard, true, (float)AudioMath.dbToLevel((double)this.maxJump), (float)super.getInputHopSize() / info.getSampleRate(), this.getNbBins() <= 129);
        this.dropx = Cmplx.newArray((int)this.getNbBins());
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.engine = null;
        this.dropx = null;
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int step) {
        Cmplx[][][] data = new Cmplx[][][]{{spectrum}};
        this.engine.analyseSplitted(data, data);
        if (this.keepLong) {
            this.engine.processSplitted(data, 0, new Cmplx[][]{this.dropx}, new Cmplx[][]{spectrum});
        } else {
            this.engine.processSplitted(data, 0, new Cmplx[][]{spectrum}, new Cmplx[][]{this.dropx});
        }
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        super.createSerialSections(factory);
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        super.setSerialSections(pool);
        this.engine.setSerialSections(pool);
    }
}

