/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierLatency;
import ch.tachyon.sonics.effect.utils.ConcurrentFloatMatrixBuffer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.OverTime;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Unit;
import java.util.BitSet;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

@Category(value="Separation")
@Name(value="Length Splitter")
@Description(value="Split long and short sounds\n(experimental)")
@SampleRates(min=8000.0f, max=192000.0f)
@OverTime(parameterName="quality", minValue=3.0)
@MultiThreading
public class LengthSplitter
extends FourierSimpleEffectBase
implements IFourierLatency,
IHasSerialSections {
    private static final String SERIAL_SECTIONS_NAME = LengthSplitter.class.getName();
    private static final float MAG_DECAY_512 = 0.9f;
    private static final float SHORT_DECAY = 0.8f;
    private float variationTolerance;
    private double durationSplit;
    private float longSoundsLevel;
    private float shortSoundsLevel;
    private int quality;
    private float sampleRate;
    private WorkData[] workDatas;
    private SharedData[] sharedDatas;

    @Order(value=1)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLongSoundsLevel() {
        return this.longSoundsLevel;
    }

    public void setLongSoundsLevel(float steadyLevel) {
        this.longSoundsLevel = steadyLevel;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=0.0)
    public float getShortSoundsLevel() {
        return this.shortSoundsLevel;
    }

    public void setShortSoundsLevel(float otherLevel) {
        this.shortSoundsLevel = otherLevel;
    }

    @Order(value=3)
    @Unit(value="ms")
    @Range(minValue=50.0, maxValue=2000.0, defaultValue=200.0)
    @Scale(value=ScaleType.LOGARITHMIC)
    @Description(value="Length split point.\nMinimum duration of a long sound\nMaximum duration of a short sound")
    public double getDurationSplit() {
        return this.durationSplit;
    }

    public void setDurationSplit(double duration) {
        this.durationSplit = duration;
    }

    @Order(value=4)
    @Unit(value="dB")
    @Range(minValue=1.0, maxValue=9.0, defaultValue=5.0)
    @Scale(value=ScaleType.LINEAR, steps=8)
    @Description(value="Maximum amplitude variation for a long sound\nAn amplitude variation greater than this value is considered as a new sound")
    public float getVariationTolerance() {
        return this.variationTolerance;
    }

    public void setVariationTolerance(float maxSkew) {
        this.variationTolerance = maxSkew;
    }

    @Order(value=5)
    @Description(value="Precision of the result\nHigher values mean less transient smearing but slower processing")
    @Range(minValue=1.0, maxValue=3.0, defaultValue=2.0)
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec(info.getSampleRate());
        specs.setFourierLatency(this);
        specs.setMultihop(false);
        if (this.quality == 1) {
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setBaseResolution(4096);
            specs.setOverlap(4.0f);
        } else if (this.quality == 2) {
            specs.setProcessingType(FourierProcessingType.LOCKED_MULTI_SCALE);
            specs.setResolution(4096, 4.0f, 2, 4.0f, 1.0f, true);
            specs.setMaxSynthesisSize(4096.0f);
            specs.setRequiresSource(true);
        } else if (this.quality == 3) {
            specs.setProcessingType(FourierProcessingType.LOCKED_MULTI_SCALE);
            specs.setResolution(4096, 8.0f, 3, 4.0f, 1.0f, true);
            specs.setMaxSynthesisSize(4096.0f);
            specs.setRequiresSource(true);
        }
        return specs;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.sampleRate = info.getSampleRate();
        int nbScales = super.getNbScales();
        this.workDatas = new WorkData[nbScales];
        int r = 0;
        while (r < nbScales) {
            WorkData data;
            this.workDatas[r] = data = new WorkData();
            int nbBins = super.getNbBins();
            data.powerMags = new float[nbBins];
            data.longBins = new BitSet(nbBins);
            ++r;
        }
    }

    public int getFourierLatency(int distanceBetweenFrames, int res, int scale) {
        return distanceBetweenFrames * this.sharedDatas[scale].length;
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long c, int stepNum) {
        int nbBins = spectrum.length;
        float maxRatio = (float)AudioMath.dbToPowerLevel((double)(-this.variationTolerance));
        SharedData sharedData = this.sharedDatas[scale];
        WorkData workData = this.workDatas[scale];
        long clock = sharedData.ss1.getClock();
        this.pushMagnitudes(source, spectrum, nbBins, sharedData, workData, clock);
        sharedData.ss1.enterSerialSection();
        this.trackLength(nbBins, maxRatio, sharedData, workData);
        sharedData.ss1.leaveSerialSection();
        sharedData.ss2.enterSerialSection();
        this.updateCurState(nbBins, sharedData, workData);
        sharedData.ss2.leaveSerialSection();
        this.gatherResults(spectrum, nbBins, sharedData, workData, clock);
        sharedData.ss3.enterSerialSection();
        this.applyResults(spectrum, nbBins, sharedData, workData);
        sharedData.ss3.leaveSerialSection();
    }

    private void pushMagnitudes(Cmplx[] source, Cmplx[] spectrum, int nbBins, SharedData sharedData, WorkData workData, long clock) {
        int i = 0;
        while (i < nbBins) {
            workData.powerMags[i] = source[i].powerMag();
            ++i;
        }
        sharedData.buffer.push(workData.powerMags, spectrum, clock);
    }

    private void trackLength(int nbBins, float maxRatio, SharedData sharedData, WorkData workData) {
        int i = 0;
        while (i < nbBins) {
            boolean continuous;
            float prevMag = sharedData.curMag[i];
            float nextMag = this.getPowerMag(workData, i);
            boolean bl = continuous = LengthSplitter.ratio(prevMag, nextMag) >= maxRatio;
            if (!continuous) {
                float ratioD;
                float nextMagU = this.getPowerMag(workData, i - 1);
                float nextMagD = this.getPowerMag(workData, i + 1);
                float ratioU = LengthSplitter.ratio(prevMag, nextMagU);
                if (ratioU > (ratioD = LengthSplitter.ratio(prevMag, nextMagD))) {
                    if (ratioU >= maxRatio) {
                        continuous = true;
                    }
                } else if (ratioD >= maxRatio) {
                    continuous = true;
                }
            }
            if (continuous) {
                int n = i;
                sharedData.curLength[n] = sharedData.curLength[n] + 1;
                sharedData.curMag[i] = sharedData.curMag[i] * sharedData.magDecay + nextMag * (1.0f - sharedData.magDecay);
            } else {
                sharedData.curLength[i] = 0;
                sharedData.curMag[i] = nextMag;
            }
            workData.longBins.set(i, sharedData.curLength[i] >= sharedData.length);
            ++i;
        }
    }

    private void updateCurState(int nbBins, SharedData sharedData, WorkData workData) {
        int i = 0;
        while (i < nbBins) {
            if (workData.longBins.get(i)) {
                sharedData.curState[i] = sharedData.length;
            } else if (sharedData.curState[i] > 0) {
                int n = i;
                sharedData.curState[n] = sharedData.curState[n] - 1;
            }
            workData.longBins.set(i, sharedData.curState[i] > 0);
            ++i;
        }
    }

    private void gatherResults(Cmplx[] spectrum, int nbBins, SharedData sharedData, WorkData workData, long clock) {
        sharedData.buffer.pop(-sharedData.length, spectrum, workData.powerMags, clock);
    }

    private void applyResults(Cmplx[] spectrum, int nbBins, SharedData sharedData, WorkData workData) {
        int i = 0;
        while (i < nbBins) {
            if (workData.longBins.get(i)) {
                float shortRatio;
                sharedData.shortDecays[i] = shortRatio = sharedData.shortDecays[i] * sharedData.shortDecay;
                spectrum[i].mul(this.longSoundsLevel * (1.0f - shortRatio) + this.shortSoundsLevel * shortRatio);
                sharedData.floorMags[i] = workData.powerMags[i];
            } else {
                sharedData.floorMags[i] = Math.min(sharedData.floorMags[i], workData.powerMags[i]);
                float longRatio = 1.0f;
                if (workData.powerMags[i] > Float.MIN_NORMAL) {
                    longRatio = sharedData.floorMags[i] / workData.powerMags[i];
                }
                spectrum[i].mul(this.longSoundsLevel * longRatio + this.shortSoundsLevel * (1.0f - longRatio));
                sharedData.shortDecays[i] = 1.0f;
            }
            ++i;
        }
    }

    private float getPowerMag(WorkData data, int binIndex) {
        if (binIndex < 0 || binIndex >= data.powerMags.length) {
            return 0.0f;
        }
        return data.powerMags[binIndex];
    }

    private static float ratio(float curMag, float otherMag) {
        if (curMag > otherMag) {
            return curMag <= 0.0f ? 0.0f : otherMag / curMag;
        }
        return otherMag <= 0.0f ? 0.0f : curMag / otherMag;
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.sharedDatas = null;
        this.workDatas = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        super.createSerialSections(factory);
        int nbScales = super.getNbScales();
        this.sharedDatas = new SharedData[nbScales];
        int r = 0;
        while (r < nbScales) {
            SharedData data;
            this.sharedDatas[r] = data = new SharedData();
            int nbBins = super.getNbBins();
            data.length = (int)(this.durationSplit * (double)this.sampleRate / 1000.0 / (double)super.getDistanceBetweenFrames(r) + 0.5);
            float ratio = (float)super.getDistanceBetweenFrames(r) / 512.0f;
            data.magDecay = (float)Math.pow(0.9f, ratio);
            data.shortDecay = (float)Math.pow(0.8f, ratio);
            data.buffer = new ConcurrentFloatMatrixBuffer(nbBins, data.length + factory.getMtContext().getSerialRunningMaxSkew());
            data.curLength = new int[nbBins];
            data.curState = new int[nbBins];
            data.curMag = new float[nbBins];
            data.floorMags = new float[nbBins];
            data.shortDecays = new float[nbBins];
            data.ss1 = factory.createSerialSection(String.valueOf(SERIAL_SECTIONS_NAME) + "." + r + ".1", (Object)data);
            data.ss2 = factory.createSerialSection(String.valueOf(SERIAL_SECTIONS_NAME) + "." + r + ".2", (Object)data);
            data.ss3 = factory.createSerialSection(String.valueOf(SERIAL_SECTIONS_NAME) + "." + r + ".3", (Object)data);
            ++r;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        super.setSerialSections(pool);
        int nbScales = super.getNbScales();
        this.sharedDatas = new SharedData[nbScales];
        int r = 0;
        while (r < nbScales) {
            ISerialSection ss1 = pool.getSerialSection(String.valueOf(SERIAL_SECTIONS_NAME) + "." + r + ".1");
            this.sharedDatas[r] = (SharedData)ss1.getUserData(SharedData.class);
            ++r;
        }
    }

    static class SharedData {
        int length;
        float magDecay;
        float shortDecay;
        ConcurrentFloatMatrixBuffer buffer;
        int[] curLength;
        int[] curState;
        float[] curMag;
        float[] floorMags;
        float[] shortDecays;
        ISerialSection ss1;
        ISerialSection ss2;
        ISerialSection ss3;

        SharedData() {
        }
    }

    static class WorkData {
        float[] powerMags;
        BitSet longBins;

        WorkData() {
        }
    }
}

