/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.utils.FloatMatrixBuffer;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Unit;
import java.util.BitSet;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

@Category(value="Separation")
@Name(value="Length Splitter (Old)")
@Description(value="Split long and short sounds\n(experimental)")
@SampleRates(min=8000.0f, max=192000.0f)
public class LengthSplitterOld
extends FourierSimpleEffectBase {
    private float variationTolerance;
    private double durationSplit;
    private float longSoundsLevel;
    private float shortSoundsLevel;
    private int length;
    private float[] powerMags;
    private FloatMatrixBuffer buffer;

    @Order(value=3)
    @Unit(value="ms")
    @Range(minValue=50.0, maxValue=2000.0, defaultValue=200.0)
    @Scale(value=ScaleType.LOGARITHMIC)
    @Description(value="Length split point.\nMinimum duration of a long sound\nMaximum duration of a short sound")
    public double getDurationSplit() {
        return this.durationSplit;
    }

    public void setDurationSplit(double duration) {
        this.durationSplit = duration;
    }

    @Order(value=4)
    @Unit(value="dB")
    @Range(minValue=1.0, maxValue=9.0, defaultValue=5.0)
    @Scale(value=ScaleType.LINEAR, steps=8)
    @Description(value="Maximum amplitude variation for a long sound\nAn amplitude variation greater than this value is considered as a new sound")
    public float getVariationTolerance() {
        return this.variationTolerance;
    }

    public void setVariationTolerance(float maxSkew) {
        this.variationTolerance = maxSkew;
    }

    @Order(value=1)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=1.0)
    public float getLongSoundsLevel() {
        return this.longSoundsLevel;
    }

    public void setLongSoundsLevel(float steadyLevel) {
        this.longSoundsLevel = steadyLevel;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=0.0)
    public float getShortSoundsLevel() {
        return this.shortSoundsLevel;
    }

    public void setShortSoundsLevel(float otherLevel) {
        this.shortSoundsLevel = otherLevel;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec spec = new FourierSpec();
        spec.setBaseResolution(AudioMath.adjustPowerOf2((int)4096, (float)44100.0f, (float)info.getSampleRate()));
        spec.setOverlap(8.0f);
        return spec;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.length = (int)(this.durationSplit * (double)info.getSampleRate() / 1000.0 / (double)super.getInputHopSize() + 0.5);
        this.buffer = new FloatMatrixBuffer(super.getNbBins(), this.length * 2 + 1);
        this.powerMags = new float[super.getNbBins()];
    }

    public int getLatency(IoDirection ioDirection) {
        int result = super.getLatency(ioDirection);
        return result += super.getInputHopSize() * this.length;
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int step) {
        int nbBins = spectrum.length;
        int i = 0;
        while (i < nbBins) {
            this.powerMags[i] = spectrum[i].powerMag();
            ++i;
        }
        this.buffer.push(this.powerMags, spectrum);
        BitSet steadyTones = new BitSet(nbBins);
        float maxRatio = (float)AudioMath.dbToPowerLevel((double)(-this.variationTolerance));
        int i2 = 0;
        while (i2 < nbBins) {
            int right;
            int left = this.walk(maxRatio, i2, -1);
            steadyTones.set(i2, left + (right = this.walk(maxRatio, i2, 1)) >= this.length);
            ++i2;
        }
        this.buffer.pop(-this.length, spectrum);
        i2 = 0;
        while (i2 < nbBins) {
            if (steadyTones.get(i2)) {
                spectrum[i2].mul(this.longSoundsLevel);
            } else {
                spectrum[i2].mul(this.shortSoundsLevel);
            }
            ++i2;
        }
    }

    private int walk(float maxRatio, int i, int dx) {
        float curMag = this.buffer.getValue(i, -this.length);
        int offset = 1;
        int index = i;
        do {
            float ratio3;
            float nextMag1 = this.buffer.getValue(index, offset * dx - this.length);
            float nextMag2 = this.buffer.getValue(index - 1, offset * dx - this.length);
            float nextMag3 = this.buffer.getValue(index + 1, offset * dx - this.length);
            if (LengthSplitterOld.isCont(curMag, nextMag1, maxRatio)) continue;
            float ratio2 = LengthSplitterOld.ratio(curMag, nextMag2);
            if (ratio2 > (ratio3 = LengthSplitterOld.ratio(curMag, nextMag3))) {
                if (!(ratio2 >= maxRatio)) break;
                --index;
                continue;
            }
            if (!(ratio3 >= maxRatio)) break;
            ++index;
        } while (++offset <= this.length);
        return offset - 1;
    }

    private static float ratio(float curMag, float otherMag) {
        if (curMag > otherMag) {
            return curMag <= 0.0f ? 0.0f : otherMag / curMag;
        }
        return otherMag <= 0.0f ? 0.0f : curMag / otherMag;
    }

    private static boolean isCont(float curMag, float otherMag, float maxRatio) {
        return LengthSplitterOld.ratio(curMag, otherMag) >= maxRatio;
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.buffer = null;
        this.powerMags = null;
    }
}

