/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierLatency;
import ch.tachyon.sonics.effect.separation.LengthSplitter;
import ch.tachyon.sonics.effect.utils.FloatMatrixBuffer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.OverTime;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Unit;
import java.util.BitSet;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

@Category(value="Separation")
@Name(value="Length Splitter Single")
@Description(value="Split long and short sounds\n(experimental)")
@SampleRates(min=8000.0f, max=192000.0f)
@OverTime(parameterName="quality", minValue=4.0)
public class LengthSplitterSingle
extends FourierSimpleEffectBase
implements IFourierLatency {
    private static final String TRACKING_SS_NAME = String.valueOf(LengthSplitter.class.getName()) + ".tracking";
    private static final float MAG_DECAY_512 = 0.9f;
    private static final float SHORT_DECAY = 0.7f;
    private float variationTolerance;
    private double durationSplit;
    private float longSoundsLevel;
    private float shortSoundsLevel;
    private int quality;
    private ProcessData[] datas;
    private SharedData[] shareds;
    private ISerialSection ssTracking;

    @Order(value=1)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=1.0)
    public float getLongSoundsLevel() {
        return this.longSoundsLevel;
    }

    public void setLongSoundsLevel(float steadyLevel) {
        this.longSoundsLevel = steadyLevel;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=1.0, defaultValue=0.0)
    public float getShortSoundsLevel() {
        return this.shortSoundsLevel;
    }

    public void setShortSoundsLevel(float otherLevel) {
        this.shortSoundsLevel = otherLevel;
    }

    @Order(value=3)
    @Unit(value="ms")
    @Range(minValue=50.0, maxValue=2000.0, defaultValue=200.0)
    @Scale(value=ScaleType.LOGARITHMIC)
    @Description(value="Length split point.\nMinimum duration of a long sound\nMaximum duration of a short sound")
    public double getDurationSplit() {
        return this.durationSplit;
    }

    public void setDurationSplit(double duration) {
        this.durationSplit = duration;
    }

    @Order(value=4)
    @Unit(value="dB")
    @Range(minValue=1.0, maxValue=9.0, defaultValue=5.0)
    @Scale(value=ScaleType.LINEAR, steps=8)
    @Description(value="Maximum amplitude variation for a long sound\nAn amplitude variation greater than this value is considered as a new sound")
    public float getVariationTolerance() {
        return this.variationTolerance;
    }

    public void setVariationTolerance(float maxSkew) {
        this.variationTolerance = maxSkew;
    }

    @Order(value=5)
    @Description(value="Precision of the result\nHigher values mean less transient smearing but slower processing")
    @Range(minValue=1.0, maxValue=4.0, defaultValue=2.0)
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec(info.getSampleRate());
        specs.setFourierLatency(this);
        if (this.quality == 1) {
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setBaseResolution(4096);
            specs.setOverlap(4.0f);
        } else if (this.quality == 2) {
            specs.setProcessingType(FourierProcessingType.MULTI_SCALE);
            specs.setResolution(4096, 4.0f, 2, 4.0f, 1.0f, true);
            specs.setMaxSynthesisSize(4096.0f);
            specs.setRequiresSource(true);
            specs.setOverlap(4.0f);
        } else if (this.quality == 3) {
            specs.setProcessingType(FourierProcessingType.MULTI_SCALE);
            specs.setResolution(4096, 4.0f, 3, 4.0f, 1.0f, true);
            specs.setMaxSynthesisSize(4096.0f);
            specs.setRequiresSource(true);
            specs.setOverlap(8.0f);
        } else if (this.quality == 4) {
            specs.setProcessingType(FourierProcessingType.LOCKED_MULTI_SCALE);
            specs.setResolution(4096, 4.0f, 3, 4.0f, 1.0f, true);
            specs.setMaxSynthesisSize(4096.0f);
            specs.setRequiresSource(true);
            specs.setOverlap(4.0f);
        }
        return specs;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        int nbScales = super.getNbScales();
        this.datas = new ProcessData[nbScales];
        int r = 0;
        while (r < nbScales) {
            ProcessData data;
            this.datas[r] = data = new ProcessData();
            int nbBins = super.getNbBins(r);
            data.length = (int)(this.durationSplit * (double)info.getSampleRate() / 1000.0 / (double)super.getDistanceBetweenFrames(r) + 0.5);
            data.powerMags = new float[nbBins];
            data.longBins = new BitSet(nbBins);
            float ratio = (float)super.getDistanceBetweenFrames(r) / 512.0f;
            data.magDecay = (float)Math.pow(0.9f, ratio);
            data.shortDecay = (float)Math.pow(0.7f, ratio);
            ++r;
        }
    }

    private void initSharedData(IMtContext context) {
        int nbScales = super.getNbScales();
        this.shareds = new SharedData[nbScales];
        int r = 0;
        while (r < nbScales) {
            SharedData shared;
            this.shareds[r] = shared = new SharedData();
            int nbBins = super.getNbBins(r);
            shared.buffer = new FloatMatrixBuffer(nbBins, this.datas[r].length + 1);
            shared.curLength = new int[nbBins];
            shared.curState = new int[nbBins];
            shared.curMag = new float[nbBins];
            shared.floorMags = new float[nbBins];
            shared.shortDecays = new float[nbBins];
            ++r;
        }
    }

    public int getFourierLatency(int distanceBetweenFrames, int res, int scale) {
        return distanceBetweenFrames * this.datas[scale].length;
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int stepNum) {
        int nbBins = spectrum.length;
        float maxRatio = (float)AudioMath.dbToPowerLevel((double)(-this.variationTolerance));
        ProcessData data = this.datas[scale];
        SharedData shared = this.shareds[scale];
        this.pushMagnitudes(source, spectrum, nbBins, data, shared);
        this.trackLength(nbBins, maxRatio, data, shared);
        this.updateCurState(nbBins, data, shared);
        this.gatherResults(spectrum, nbBins, data, shared);
        this.applyResults(spectrum, nbBins, data, shared);
    }

    private void pushMagnitudes(Cmplx[] source, Cmplx[] spectrum, int nbBins, ProcessData data, SharedData shared) {
        int i = 0;
        while (i < nbBins) {
            data.powerMags[i] = source[i].powerMag();
            ++i;
        }
        shared.buffer.push(data.powerMags, spectrum);
    }

    private void trackLength(int nbBins, float maxRatio, ProcessData data, SharedData shared) {
        int i = 0;
        while (i < nbBins) {
            boolean continuous;
            float prevMag = shared.curMag[i];
            float nextMag = this.getPowerMag(data, i);
            boolean bl = continuous = LengthSplitterSingle.ratio(prevMag, nextMag) >= maxRatio;
            if (!continuous) {
                float ratioD;
                float nextMagU = this.getPowerMag(data, i - 1);
                float nextMagD = this.getPowerMag(data, i + 1);
                float ratioU = LengthSplitterSingle.ratio(prevMag, nextMagU);
                if (ratioU > (ratioD = LengthSplitterSingle.ratio(prevMag, nextMagD))) {
                    if (ratioU >= maxRatio) {
                        continuous = true;
                    }
                } else if (ratioD >= maxRatio) {
                    continuous = true;
                }
            }
            if (continuous) {
                int n = i;
                shared.curLength[n] = shared.curLength[n] + 1;
                shared.curMag[i] = shared.curMag[i] * data.magDecay + nextMag * (1.0f - data.magDecay);
            } else {
                shared.curLength[i] = 0;
                shared.curMag[i] = nextMag;
            }
            ++i;
        }
    }

    private void updateCurState(int nbBins, ProcessData data, SharedData shared) {
        int i = 0;
        while (i < nbBins) {
            if (shared.curLength[i] >= data.length) {
                shared.curState[i] = data.length;
            } else if (shared.curState[i] > 0) {
                int n = i;
                shared.curState[n] = shared.curState[n] - 1;
            }
            ++i;
        }
    }

    private void gatherResults(Cmplx[] spectrum, int nbBins, ProcessData data, SharedData shared) {
        data.longBins.clear();
        shared.buffer.pop(-data.length, spectrum, data.powerMags);
        int i = 0;
        while (i < nbBins) {
            data.longBins.set(i, shared.curState[i] > 0);
            ++i;
        }
    }

    private void applyResults(Cmplx[] spectrum, int nbBins, ProcessData data, SharedData shared) {
        int i = 0;
        while (i < nbBins) {
            if (data.longBins.get(i)) {
                float shortRatio;
                shared.shortDecays[i] = shortRatio = shared.shortDecays[i] * data.shortDecay;
                spectrum[i].mul(this.longSoundsLevel * (1.0f - shortRatio) + this.shortSoundsLevel * shortRatio);
                shared.floorMags[i] = data.powerMags[i];
            } else {
                shared.floorMags[i] = Math.min(shared.floorMags[i], data.powerMags[i]);
                float longRatio = 1.0f;
                if (data.powerMags[i] > Float.MIN_NORMAL) {
                    longRatio = shared.floorMags[i] / data.powerMags[i];
                }
                spectrum[i].mul(this.longSoundsLevel * longRatio + this.shortSoundsLevel * (1.0f - longRatio));
                shared.shortDecays[i] = 1.0f;
            }
            ++i;
        }
    }

    private float getPowerMag(ProcessData data, int binIndex) {
        if (binIndex < 0 || binIndex >= data.powerMags.length) {
            return 0.0f;
        }
        return data.powerMags[binIndex];
    }

    private static float ratio(float curMag, float otherMag) {
        if (curMag > otherMag) {
            return curMag <= 0.0f ? 0.0f : otherMag / curMag;
        }
        return otherMag <= 0.0f ? 0.0f : curMag / otherMag;
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.datas = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        super.createSerialSections(factory);
        this.initSharedData(factory.getMtContext());
        this.ssTracking = factory.createSerialSection(TRACKING_SS_NAME, (Object)this.shareds);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        super.setSerialSections(pool);
        this.ssTracking = pool.getSerialSection(TRACKING_SS_NAME);
        this.shareds = (SharedData[])this.ssTracking.getUserData(SharedData[].class);
    }

    private static class ProcessData {
        int length;
        float magDecay;
        float shortDecay;
        float[] powerMags;
        BitSet longBins;

        private ProcessData() {
        }
    }

    private static class SharedData {
        FloatMatrixBuffer buffer;
        int[] curLength;
        int[] curState;
        float[] curMag;
        float[] floorMags;
        float[] shortDecays;

        private SharedData() {
        }
    }
}

