/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import java.util.Arrays;
import java.util.BitSet;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.ShellSort;

public class NoiseExtractor {
    private static final int NB_BANDS = 15;
    private static final int OVERLAP = 3;
    private static final int MIN_SPAN = 5;
    private static final float LOWER_LOW = 16.0f;
    private final int nbBins;
    private final float sinusThreshold;
    private final float percentile;
    private final int[] bounds;
    private final float[] levels;
    private final int[] bandIndexes;
    private final float[] bandLevels;
    private final float[] sinusness;
    private final float[][] windows;
    private final float[] invWindow;
    private final float[] biasWindow;
    private final BitSet noiseBins;
    private final float[] noiseNess;

    public NoiseExtractor(int nbBins, float sinusThreshold, float percentile, float sampleRate, float lowerUp) {
        this.nbBins = nbBins;
        this.sinusThreshold = sinusThreshold;
        this.percentile = percentile;
        this.levels = new float[nbBins];
        this.bandIndexes = new int[nbBins];
        this.bandLevels = new float[nbBins];
        this.sinusness = new float[nbBins];
        this.noiseBins = new BitSet(nbBins);
        this.noiseNess = new float[nbBins];
        int nbBounds = 17;
        this.bounds = new int[nbBounds];
        int prevBin = 0;
        int i = 0;
        while (i < nbBounds) {
            int bin = (int)(Math.pow(Math.sqrt(nbBins) * (double)(i + 1) / (double)nbBounds, 2.0) + 0.5);
            if (bin < prevBin + 5) {
                bin = prevBin + 5;
            }
            this.bounds[i] = bin;
            prevBin = bin;
            ++i;
        }
        this.windows = new float[15][];
        int b = 0;
        while (b < 15) {
            int lower = b == 0 ? 0 : this.bounds[b - 1];
            int upper = this.bounds[b + 3 - 1];
            int length = upper - lower;
            this.windows[b] = new float[length];
            Windows.fillWindow((float[])this.windows[b], (int)length, (float[])Windows.HannCoefs);
            if (b == 0) {
                Arrays.fill(this.windows[b], 0, length / 2, 1.0f);
            } else if (b == 14) {
                Arrays.fill(this.windows[b], length / 2, length, 1.0f);
            }
            ++b;
        }
        this.invWindow = new float[nbBins];
        i = 0;
        while (i < nbBins) {
            int b2 = 0;
            while (b2 < 15) {
                int lower = b2 == 0 ? 0 : this.bounds[b2 - 1];
                int upper = this.bounds[b2 + 3 - 1];
                if (i >= lower && i < upper) {
                    int n = i;
                    this.invWindow[n] = this.invWindow[n] + this.windows[b2][i - lower];
                }
                ++b2;
            }
            ++i;
        }
        i = 0;
        while (i < nbBins) {
            this.invWindow[i] = 1.0f / this.invWindow[i];
            ++i;
        }
        this.biasWindow = new float[nbBins];
        int blockSize = (nbBins - 1) * 2;
        double freqToBin = (double)blockSize / (double)sampleRate;
        int lowlow = (int)(16.0 * freqToBin);
        int lowupp = (int)((double)lowerUp * freqToBin + 0.5);
        float upperFreq = sampleRate / 2.0f - 1.0f;
        int upplow = (int)((double)upperFreq * freqToBin);
        int uppupp = (int)((double)upperFreq * freqToBin + 0.5);
        int i2 = 0;
        while (i2 < nbBins) {
            if (i2 < lowlow) {
                this.biasWindow[i2] = 1.0f;
            } else if (i2 < lowupp) {
                this.biasWindow[i2] = 1.0f - (float)(i2 - lowlow) / (float)(lowupp - lowlow);
            } else if (i2 >= uppupp) {
                this.biasWindow[i2] = -1.0f;
            } else if (i2 >= upplow) {
                this.biasWindow[i2] = 0.0f - (float)(i2 - upplow) / (float)(uppupp - upplow);
            }
            ++i2;
        }
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public BitSet analyze(Cmplx[] source) {
        if (source.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        Arrays.fill(this.sinusness, 0.0f);
        this.noiseBins.clear();
        int i = 0;
        while (i < this.nbBins) {
            this.levels[i] = source[i].powerMag();
            ++i;
        }
        int band = 0;
        while (band < 15) {
            int lower = band == 0 ? 0 : this.bounds[band - 1];
            int upper = this.bounds[band + 3 - 1];
            int count = 0;
            int i2 = lower;
            while (i2 < upper) {
                this.bandIndexes[count] = i2 - lower;
                this.bandLevels[count++] = this.levels[i2];
                ++i2;
            }
            ShellSort.sort((int[])this.bandIndexes, (float[])this.bandLevels, (int)count);
            float pivotLevel = this.bandLevels[this.bandIndexes[(int)((float)count * this.percentile)]];
            pivotLevel *= this.sinusThreshold;
            int pos = count / 2;
            while (pos > 0 && this.bandLevels[this.bandIndexes[pos]] < pivotLevel) {
                --pos;
            }
            float pivotRank = (float)pos / (float)count;
            int i3 = 0;
            while (i3 < count) {
                int binNum;
                float rank = (float)i3 / (float)(count - 1);
                assert (rank >= 0.0f && rank <= 1.0f);
                rank = rank < pivotRank || pivotRank == 1.0f ? rank * 0.5f / pivotRank : 0.5f + (rank - pivotRank) * 0.5f / (1.0f - pivotRank);
                rank = 1.0f - rank;
                int n = binNum = this.bandIndexes[i3] + lower;
                this.sinusness[n] = this.sinusness[n] + rank * this.windows[band][binNum - lower];
                ++i3;
            }
            ++band;
        }
        i = 0;
        while (i < this.nbBins) {
            float tonal = this.sinusness[i] * this.invWindow[i] + this.biasWindow[i];
            if (tonal > 0.5f) {
                this.noiseBins.clear(i);
            } else {
                this.noiseBins.set(i);
            }
            this.noiseNess[i] = NoiseExtractor.crop(1.5f - tonal * 2.0f);
            ++i;
        }
        return this.noiseBins;
    }

    public float getNoiseness(int binNum) {
        return this.noiseNess[binNum];
    }

    private static float crop(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }
}

