/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.utils.ConcurrentAverageBuffer;
import ch.tachyon.tunnel.engine.utils.ConcurrentHistoryBuffer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.FastMath;

@Category(value="Separation")
@Name(value="Stability Splitter")
@MultiThreading
@SampleRates(min=44100.0f, max=48000.0f)
@Description(value="Split stable and unstable sounds\n(experimental)")
public class StabilitySplitter
extends FourierSimpleEffectBase
implements IHasSerialSections {
    private static final int BLOCK_SIZE = 2048;
    private static final int NB_BINS = 1025;
    private static final int OVERLAP = 16;
    private static final String ANGLE_SERIAL_SECTION_NAME = String.valueOf(StabilitySplitter.class.getName()) + "#angle";
    private static final String FREQ_SERIAL_SECTION_NAME = String.valueOf(StabilitySplitter.class.getName()) + "#freq";
    private static final String AVG_SERIAL_SECTION_NAME = String.valueOf(StabilitySplitter.class.getName()) + "#avg";
    private static final float THRESHOLD1 = 0.02f;
    private static final float THRESHOLD2 = 0.03f;
    private static final int AVG_LENGTH = 5;
    private float stableLevel;
    private float unstableLevel;
    private boolean highQuality;
    private float[] diffs;
    private ProcessData[] datas;

    @Description(value="Level of stable (deterministic) sounds")
    @Order(value=1)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getStableLevel() {
        return this.stableLevel;
    }

    public void setStableLevel(float stableLevel) {
        this.stableLevel = stableLevel;
    }

    @Description(value="Level of unstable (stochastic) sounds")
    @Order(value=2)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=0.0)
    public float getUnstableLevel() {
        return this.unstableLevel;
    }

    public void setUnstableLevel(float unstableLevel) {
        this.unstableLevel = unstableLevel;
    }

    @Order(value=3)
    @Description(value="Enable higher quality mode\nProcessing will be slower")
    public boolean isHighQuality() {
        return this.highQuality;
    }

    public void setHighQuality(boolean highQuality) {
        this.highQuality = highQuality;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec(info.getSampleRate());
        specs.setMultihop(false);
        specs.setRequiresSource(true);
        if (!this.highQuality) {
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setBaseResolution(2048);
            specs.setOverlap(16.0f);
        } else {
            specs.setProcessingType(FourierProcessingType.LOCKED_MULTI_SCALE);
            specs.setResolution(2048, 4.0f, 2, 4.0f, 1.0f, true);
        }
        return specs;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.diffs = new float[1025];
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        super.createSerialSections(factory);
        int nbScales = super.getNbScales();
        this.datas = new ProcessData[nbScales];
        int r = 0;
        while (r < super.getNbScales()) {
            ProcessData data;
            this.datas[r] = data = new ProcessData();
            data.lastAngles = new ConcurrentHistoryBuffer[1025];
            data.lastFreq = new ConcurrentHistoryBuffer[1025];
            int i = 0;
            while (i < 1025) {
                data.lastAngles[i] = new ConcurrentHistoryBuffer(2, 1 + factory.getMtContext().getSerialRunningMaxSkew());
                data.lastFreq[i] = new ConcurrentHistoryBuffer(2, 1 + factory.getMtContext().getSerialRunningMaxSkew());
                ++i;
            }
            data.averages = new ConcurrentAverageBuffer[1025];
            i = 0;
            while (i < 1025) {
                data.averages[i] = new ConcurrentAverageBuffer(5, 5 + factory.getMtContext().getSerialRunningMaxSkew());
                ++i;
            }
            data.angleSS = factory.createSerialSection(String.valueOf(ANGLE_SERIAL_SECTION_NAME) + r, (Object)data.lastAngles);
            data.freqSS = factory.createSerialSection(String.valueOf(FREQ_SERIAL_SECTION_NAME) + r, (Object)data.lastFreq);
            data.avgSS = factory.createSerialSection(String.valueOf(AVG_SERIAL_SECTION_NAME) + r, (Object)data.averages);
            ++r;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        super.setSerialSections(pool);
        this.datas = new ProcessData[super.getNbScales()];
        int r = 0;
        while (r < super.getNbScales()) {
            ProcessData data;
            this.datas[r] = data = new ProcessData();
            data.angleSS = pool.getSerialSection(String.valueOf(ANGLE_SERIAL_SECTION_NAME) + r);
            data.lastAngles = (ConcurrentHistoryBuffer[])data.angleSS.getUserData(ConcurrentHistoryBuffer[].class);
            data.freqSS = pool.getSerialSection(String.valueOf(FREQ_SERIAL_SECTION_NAME) + r);
            data.lastFreq = (ConcurrentHistoryBuffer[])data.freqSS.getUserData(ConcurrentHistoryBuffer[].class);
            data.avgSS = pool.getSerialSection(String.valueOf(AVG_SERIAL_SECTION_NAME) + r);
            data.averages = (ConcurrentAverageBuffer[])data.avgSS.getUserData(ConcurrentAverageBuffer[].class);
            ++r;
        }
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock0, int stepNum) {
        float prev;
        float angle;
        ProcessData data = this.datas[scale];
        long clock = data.angleSS.getClock();
        int i = 0;
        while (i < 1025) {
            angle = source[i].phiApprox();
            data.lastAngles[i].write(angle, clock);
            ++i;
        }
        data.angleSS.sync();
        i = 0;
        while (i < 1025) {
            angle = data.lastAngles[i].read(0, clock);
            prev = data.lastAngles[i].read(-1, clock);
            float freq = (float)FastMath.wrap((double)(angle - prev));
            data.lastFreq[i].write(freq, clock);
            ++i;
        }
        data.freqSS.sync();
        i = 0;
        while (i < 1025) {
            float freq = data.lastFreq[i].read(0, clock);
            prev = data.lastFreq[i].read(-1, clock);
            this.diffs[i] = Math.abs((float)FastMath.wrap((double)(freq - prev)));
            data.averages[i].push(this.diffs[i], clock);
            ++i;
        }
        data.avgSS.sync();
        i = 0;
        while (i < 1025) {
            float avg = data.averages[i].getAverage(clock);
            float variance = Math.abs(this.diffs[i] - avg);
            if (variance > 0.03f) {
                spectrum[i].mul(this.unstableLevel);
            } else if (variance < 0.02f) {
                spectrum[i].mul(this.stableLevel);
            } else {
                float uRatio = (variance - 0.02f) / 0.01f;
                float level = this.unstableLevel * uRatio + this.stableLevel * (1.0f - uRatio);
                spectrum[i].mul(level);
            }
            ++i;
        }
    }

    public void stopProcessing() {
        super.stopProcessing();
        ProcessData[] processDataArray = this.datas;
        int n = this.datas.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessData data = processDataArray[n2];
            ConcurrentAverageBuffer[] concurrentAverageBufferArray = data.averages;
            int n3 = data.averages.length;
            int n4 = 0;
            while (n4 < n3) {
                ConcurrentAverageBuffer avgBuf = concurrentAverageBufferArray[n4];
                avgBuf.dispose();
                ++n4;
            }
            ++n2;
        }
        this.datas = null;
        this.diffs = null;
    }

    static class ProcessData {
        ConcurrentHistoryBuffer[] lastAngles;
        ConcurrentHistoryBuffer[] lastFreq;
        ConcurrentAverageBuffer[] averages;
        ISerialSection angleSS;
        ISerialSection freqSS;
        ISerialSection avgSS;

        ProcessData() {
        }
    }
}

