/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import org.corebounce.common.dsp.AverageBuffer;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.FastMath;

@Category(value="Separation")
@Name(value="Stability Single")
@SampleRates(min=44100.0f, max=48000.0f)
@Description(value="Split stable and unstable sounds\n(experimental, single core)")
public class StabilitySplitterSingle
extends FourierSimpleEffectBase {
    private static final int BLOCK_SIZE = 2048;
    private static final int NB_BINS = 1025;
    private static final int OVERLAP = 16;
    private static final float THRESHOLD1 = 0.02f;
    private static final float THRESHOLD2 = 0.03f;
    private static final int AVG_LENGTH = 5;
    private float stableLevel;
    private float unstableLevel;
    private float[] lastAngles;
    private float[] lastFreq;
    private AverageBuffer[] averages;
    private AverageBuffer[] variances;

    @Order(value=1)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getStableLevel() {
        return this.stableLevel;
    }

    public void setStableLevel(float stableLevel) {
        this.stableLevel = stableLevel;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=0.0)
    public float getUnstableLevel() {
        return this.unstableLevel;
    }

    public void setUnstableLevel(float unstableLevel) {
        this.unstableLevel = unstableLevel;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec(info.getSampleRate());
        specs.setProcessingType(FourierProcessingType.SIMPLE);
        specs.setBaseResolution(2048);
        specs.setOverlap(16.0f);
        return specs;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.lastAngles = new float[1025];
        this.lastFreq = new float[1025];
        this.averages = new AverageBuffer[1025];
        int i = 0;
        while (i < 1025) {
            this.averages[i] = new AverageBuffer(5);
            ++i;
        }
        this.variances = new AverageBuffer[1025];
        i = 0;
        while (i < 1025) {
            this.variances[i] = new AverageBuffer(5);
            ++i;
        }
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int stepNum) {
        int i = 0;
        while (i < 1025) {
            float angle = spectrum[i].phi();
            float prev = this.lastAngles[i];
            this.lastAngles[i] = angle;
            float freq = (float)FastMath.wrap((double)(angle - prev));
            prev = this.lastFreq[i];
            this.lastFreq[i] = freq;
            float diff = Math.abs((float)FastMath.wrap((double)(freq - prev)));
            this.averages[i].push(diff);
            float avg = this.averages[i].getAverage();
            float variation = Math.abs(diff - avg);
            this.variances[i].push(variation);
            float variance = this.variances[i].getAverage();
            if (variance > 0.03f) {
                spectrum[i].mul(this.unstableLevel);
            } else if (variance < 0.02f) {
                spectrum[i].mul(this.stableLevel);
            } else {
                float uRatio = (variance - 0.02f) / 0.01f;
                float level = this.unstableLevel * uRatio + this.stableLevel * (1.0f - uRatio);
                spectrum[i].mul(level);
            }
            ++i;
        }
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.lastAngles = null;
        this.lastFreq = null;
        this.averages = null;
        this.variances = null;
    }
}

