/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.separation.NoiseExtractor;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

@Category(value="Separation")
@Name(value="Tonalness Splitter")
@MultiThreading
@SampleRates(min=44100.0f, max=48000.0f)
@Description(value="Split tonal and atonal sounds\n(experimental)")
public class TonalnessSplitter
extends FourierSimpleEffectBase {
    private NoiseExtractor[] engines;
    private float tonalLevel;
    private float noiseLevel;
    private int quality;

    @Order(value=1)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    @Description(value="Tonal sounds level")
    public float getTonalLevel() {
        return this.tonalLevel;
    }

    public void setTonalLevel(float sinusLevel) {
        this.tonalLevel = sinusLevel;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    @Description(value="Atonal sounds level")
    public float getNoiseLevel() {
        return this.noiseLevel;
    }

    public void setNoiseLevel(float noiseLevel) {
        this.noiseLevel = noiseLevel;
    }

    @Order(value=5)
    @Range(minValue=1.0, maxValue=3.0, defaultValue=2.0)
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec();
        specs.setAntiLeakage(false);
        int blockSize = AudioMath.adjustPowerOf2((int)8192, (float)44100.0f, (float)info.getSampleRate());
        if (this.quality == 1) {
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setResolution(blockSize, 4.0f, 1, 1.0f, 1.0f, false);
        } else if (this.quality == 2) {
            specs.setProcessingType(FourierProcessingType.MULTI_SCALE);
            specs.setResolution(blockSize, 8.0f, 2, 4.0f, 2.0f, false);
            specs.setMaxSynthesisSize((float)specs.getBaseResolution() / 4.0f);
        } else if (this.quality == 3) {
            specs.setProcessingType(FourierProcessingType.LOCKED_MULTI_SCALE);
            specs.setResolution(blockSize, 16.0f, 2, 8.0f, 4.0f, false);
            specs.setMaxSynthesisSize((float)specs.getBaseResolution() / 4.0f);
        }
        return specs;
    }

    public void beginProcessing(IProcessingInfo info) {
        super.beginProcessing(info);
        this.engines = new NoiseExtractor[super.getNbResolutions()];
        int i = 0;
        while (i < this.engines.length) {
            this.engines[i] = new NoiseExtractor(this.getNbBins(i), (float)AudioMath.dbToPowerLevel((double)10.0), 0.5f, info.getSampleRate(), 20.0f);
            ++i;
        }
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int step) {
        this.engines[res].analyze(source);
        int i = 0;
        while (i < spectrum.length) {
            float noiseness = this.engines[res].getNoiseness(i);
            float sinusness = 1.0f - noiseness;
            spectrum[i].mul(noiseness * this.noiseLevel + sinusness * this.tonalLevel);
            ++i;
        }
    }

    public void stopProcessing() {
        this.engines = null;
    }
}

