/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.separation;

import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.KnifeInfo;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Sweepable;

@Category(value="Separation")
@Name(value="Transience Splitter")
@Description(value="Split according to the degree of transience")
@MultiThreading
public class TransienceSplitter
implements ISimpleEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private int nbLayers = 4;
    private SharpInfo sharpInfo;
    private float transientLevel = 1.0f;
    private float mediumLevel = 1.0f;
    private float smoothLevel = 1.0f;
    private transient Fork fork;
    private transient float[][] mChan;

    @Order(value=1)
    @Sweepable
    @Range(minValue=0.0, maxValue=1.0, defaultValue=1.0)
    @Name(value="Edge Level")
    @Description(value="Level of transient sounds")
    public float getTransientLevel() {
        return this.transientLevel;
    }

    public void setTransientLevel(float edgeLevel) {
        this.transientLevel = edgeLevel;
    }

    @Order(value=2)
    @Sweepable
    @Range(minValue=0.0, maxValue=1.0, defaultValue=1.0)
    @Name(value="Medium Level")
    @Description(value="Level of medium sounds")
    public float getMediumLevel() {
        return this.mediumLevel;
    }

    public void setMediumLevel(float mediumLevel) {
        this.mediumLevel = mediumLevel;
    }

    @Order(value=3)
    @Sweepable
    @Range(minValue=0.0, maxValue=1.0, defaultValue=1.0)
    @Name(value="Smooth Level")
    @Description(value="Level of smooth sounds")
    public float getSmoothLevel() {
        return this.smoothLevel;
    }

    public void setSmoothLevel(float smoothLevel) {
        this.smoothLevel = smoothLevel;
    }

    public void startProcessing(IProcessingInfo info) {
        this.sharpInfo = new SharpInfo(8192.0f, this.nbLayers, 2.0f, 1024.0f, 3.0f, info.getSampleRate());
        this.sharpInfo.knifeInfo[2] = new KnifeInfo(2048, 512, 12, 10, 4, 2, 1.5, 5.0, false);
        this.sharpInfo.knifeInfo[2] = new KnifeInfo(4096, 1024, 1, 1, 1, 0, 0.0, 0.5, false);
        this.fork = new Fork(1, this.sharpInfo);
        this.mChan = new float[1][];
    }

    public int getLatency(IoDirection ioDirection) {
        return this.fork.getLatency();
    }

    public int getFixedChunkLength() {
        return this.fork.getInputSize();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.fork.init();
    }

    public void process(float[] data) {
        this.mChan[0] = data;
        this.fork.process(this.mChan);
        float[] edge1 = this.fork.getOutput(0, 0);
        float[] edge2 = this.fork.getOutput(1, 0);
        float[] medium = this.fork.getOutput(2, 0);
        float[] smooth = this.fork.getOutput(3, 0);
        int i = 0;
        while (i < data.length) {
            data[i] = (edge1[i] + edge2[i]) * this.transientLevel + medium[i] * this.mediumLevel + smooth[i] * this.smoothLevel;
            ++i;
        }
    }

    public void stopProcessing() {
        this.fork = null;
        this.mChan = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.fork.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.fork.setSerialSections(pool);
    }
}

