/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre;

import ch.tachyon.sonics.effect.base.stft.old.StftSimpleEffectBase;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.math.Cmplx;

@MultiThreading
@Category(value="Timbre")
public class CepstrumEqualizer
extends StftSimpleEffectBase {
    private static final int BLOCK_SIZE_LOG = 11;
    private static final int OVERLAP_LOG = 3;
    private float level0;
    private float level1;
    private float level2;
    private float level3;
    private float level4;
    private float level5;
    private float level6;
    private float level7;
    private float level8;
    private float level9;
    private float[] inLevels;
    private float[] outLevels;
    private BooFFT fft;
    private Cmplx[] cepstrum;

    @Order(value=0)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel0() {
        return this.level0;
    }

    public void setLevel0(float level0) {
        this.level0 = level0;
    }

    @Order(value=1)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel1() {
        return this.level1;
    }

    public void setLevel1(float level1) {
        this.level1 = level1;
    }

    @Order(value=2)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel2() {
        return this.level2;
    }

    public void setLevel2(float level2) {
        this.level2 = level2;
    }

    @Order(value=3)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel3() {
        return this.level3;
    }

    public void setLevel3(float level3) {
        this.level3 = level3;
    }

    @Order(value=4)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel4() {
        return this.level4;
    }

    public void setLevel4(float level4) {
        this.level4 = level4;
    }

    @Order(value=5)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel5() {
        return this.level5;
    }

    public void setLevel5(float level5) {
        this.level5 = level5;
    }

    @Order(value=6)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel6() {
        return this.level6;
    }

    public void setLevel6(float level6) {
        this.level6 = level6;
    }

    @Order(value=7)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel7() {
        return this.level7;
    }

    public void setLevel7(float level7) {
        this.level7 = level7;
    }

    @Order(value=8)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel8() {
        return this.level8;
    }

    public void setLevel8(float level8) {
        this.level8 = level8;
    }

    @Order(value=9)
    @Range(minValue=0.0, maxValue=2.0, defaultValue=1.0)
    public float getLevel9() {
        return this.level9;
    }

    public void setLevel9(float level9) {
        this.level9 = level9;
    }

    public void startProcessing(IProcessingInfo info) {
        super.setBlockSizeLog(11);
        super.setOverlapLog(3);
        super.startProcessing(info);
    }

    public void beginProcessing(IProcessingInfo info) {
        super.beginProcessing(info);
        int blockSize = 2048;
        this.inLevels = new float[blockSize / 2];
        this.outLevels = new float[blockSize / 2];
        this.fft = BooFFT.getInstance((int)(blockSize / 4));
        this.cepstrum = Cmplx.newArray((int)(blockSize / 4 + 1));
    }

    protected void processSpectrum(Cmplx[] spectrum) {
        double BASE = 200.0;
        int i = 0;
        while (i < this.inLevels.length) {
            float pMag = spectrum[i + 1].powerMag();
            this.inLevels[i] = (float)Math.log(pMag + 1.0E-8f);
            ++i;
        }
        this.fft.forwR2C(this.inLevels, this.cepstrum);
        float[] amplifications = new float[]{this.level0, this.level1, this.level2, this.level3, this.level4, this.level5, this.level6, this.level7, this.level8, this.level9};
        int nbLevels = amplifications.length;
        int k = 0;
        while (k < nbLevels) {
            double start = (Math.pow(200.0, (double)k / (double)nbLevels) - 1.0) / 199.0;
            double stop = (Math.pow(200.0, (double)(k + 1) / (double)nbLevels) - 1.0) / 199.0;
            int startBin = (int)(start * (double)(this.cepstrum.length - 1) + 0.5);
            int stopBin = (int)(stop * (double)(this.cepstrum.length - 1) + 0.5);
            int i2 = startBin;
            while (i2 < stopBin) {
                this.cepstrum[i2 + 1].mul(amplifications[k]);
                ++i2;
            }
            ++k;
        }
        this.fft.backC2R(this.cepstrum, this.outLevels);
        int i3 = 0;
        while (i3 < this.outLevels.length) {
            this.outLevels[i3] = (float)Math.exp(this.outLevels[i3]) - 1.0E-8f;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.inLevels.length) {
            float pMag;
            this.inLevels[i3] = pMag = spectrum[i3 + 1].powerMag();
            ++i3;
        }
        i3 = 0;
        while (i3 < this.outLevels.length) {
            float correction = (float)Math.sqrt(this.outLevels[i3] / this.inLevels[i3]);
            if (Float.isNaN(correction)) {
                correction = 0.0f;
            }
            if (correction > 10.0f) {
                correction = 10.0f;
            }
            spectrum[i3 + 1].mul(correction);
            ++i3;
        }
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.inLevels = null;
        this.fft = null;
        this.cepstrum = null;
    }
}

