/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre;

import ch.tachyon.sonics.effect.timbre.rollers.PitchShiftRollersEngine;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.Live;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import org.corebounce.common.audio.AudioMath;

@Category(value="Timbre")
@Name(value="Miserablize")
@SampleRates(min=44100.0f, max=48000.0f)
@Live
public class Miserablize
implements ISimpleEffect,
IStartStop,
IFixedChunkLength {
    private static final int CHUNK_SIZE = 32;
    private final float INIT_GAIN = (float)AudioMath.dbToLevel((double)-7.0);
    private final float FEEDBACK_GAIN = (float)AudioMath.dbToLevel((double)-2.0);
    private float strength = 0.5f;
    private int inputSize = 32;
    private PitchShiftRollersEngine engine;
    private float[] processBuffer;
    private float[] feedbackBuffer;
    private float dryLevel;
    private float wetLevel;

    @Order(value=1)
    @Description(value="Dry (0.0) to Wet (1.0) balance")
    @Range(minValue=0.0, maxValue=1.0)
    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public void startProcessing(IProcessingInfo info) {
        this.engine = new PitchShiftRollersEngine(info.getSampleRate(), 32, 0.99f, 36, 4, 10.0f);
        this.processBuffer = new float[32];
        this.feedbackBuffer = new float[32];
        this.wetLevel = (float)Math.pow(this.strength, 0.75);
        this.dryLevel = (float)Math.pow(1.0f - this.strength, 0.75);
        this.inputSize = info.getHostPreferredChunkLength();
        this.inputSize = this.inputSize < 0 ? 32 : Math.max(32, this.inputSize / 32 * 32);
        info.negociateFixedChunkLength(this.inputSize);
    }

    public int getFixedChunkLength() {
        return this.inputSize;
    }

    public void process(float[] data) {
        assert (data.length % 32 == 0);
        int offset = 0;
        while (offset < data.length) {
            int i = 0;
            while (i < 32) {
                this.processBuffer[i] = data[i + offset] * this.INIT_GAIN + this.feedbackBuffer[i] * this.FEEDBACK_GAIN;
                ++i;
            }
            this.engine.process(this.processBuffer, this.feedbackBuffer);
            i = 0;
            while (i < 32) {
                data[i + offset] = data[i + offset] * this.dryLevel + this.processBuffer[i] * this.wetLevel;
                ++i;
            }
            offset += 32;
        }
    }

    public void stopProcessing() {
        this.engine = null;
        this.processBuffer = null;
        this.feedbackBuffer = null;
    }
}

