/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.opt.spec.OverTime;
import ch.tachyon.tunnel.plugin.opt.spec.SampleRates;
import ch.tachyon.tunnel.plugin.opt.thread.Live;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.math.Cmplx;

@Category(value="Timbre")
@Name(value="Spectral Compander")
@Description(value="Dynamics expansion and compression of the spectrum and cepstrum")
@SampleRates(min=44100.0f, max=48000.0f)
@Live
@MultiThreading
@OverTime(parameterName="quality", minValue=4.0)
public class SpectralCompander
extends FourierSimpleEffectBase
implements IBeginProcessing,
IStartStop {
    private final double NEG_BASE = 100.0;
    private double spectralExpansion;
    private double cepstralExpansion;
    private double spectralSlope;
    private int quality;
    private ProcessData[] datas;

    @Order(value=1)
    @Range(minValue=-20.0, maxValue=20.0, defaultValue=10.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public double getSpectralExpansion() {
        return this.spectralExpansion;
    }

    public void setSpectralExpansion(double spectralExpansion) {
        this.spectralExpansion = spectralExpansion;
    }

    @Order(value=2)
    @Range(minValue=-20.0, maxValue=20.0, defaultValue=10.0)
    @Scale(value=ScaleType.LINEAR, steps=20)
    public double getCepstralExpansion() {
        return this.cepstralExpansion;
    }

    public void setCepstralExpansion(double cepstralExpansion) {
        this.cepstralExpansion = cepstralExpansion;
    }

    @Order(value=3)
    @Range(minValue=-15.0, maxValue=0.0, defaultValue=-7.5)
    @Description(value="Average spectral slope of the audio being processed\nin dB / Octave")
    public double getSpectralSlope() {
        return this.spectralSlope;
    }

    public void setSpectralSlope(double spectralSlope) {
        this.spectralSlope = spectralSlope;
    }

    @Order(value=4)
    @Description(value="Precision of the result\nHigher values mean less transient smearing but slower processing")
    @Range(minValue=1.0, maxValue=4.0, defaultValue=2.0)
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec(info.getSampleRate());
        if (this.quality == 1) {
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setBaseResolution(4096);
            specs.setOverlap(2.0f);
        } else if (this.quality == 2) {
            specs.setProcessingType(FourierProcessingType.MULTI_SCALE);
            specs.setResolution(4096, 4.0f, 2, 4.0f, 1.0f, true);
            specs.setMaxSynthesisSize(4096.0f);
            specs.setRequiresSource(true);
            specs.setOverlap(4.0f);
        } else if (this.quality == 3) {
            specs.setProcessingType(FourierProcessingType.MULTI_SCALE);
            specs.setResolution(4096, 4.0f, 3, 4.0f, 1.0f, true);
            specs.setMaxSynthesisSize(4096.0f);
            specs.setRequiresSource(true);
            specs.setOverlap(8.0f);
        } else if (this.quality == 4) {
            specs.setProcessingType(FourierProcessingType.LOCKED_MULTI_SCALE);
            specs.setResolution(4096, 4.0f, 3, 4.0f, 1.0f, true);
            specs.setMaxSynthesisSize(4096.0f);
            specs.setRequiresSource(true);
            specs.setOverlap(4.0f);
        }
        return specs;
    }

    public void beginProcessing(IProcessingInfo info) {
        super.beginProcessing(info);
        this.datas = new ProcessData[this.getNbResolutions()];
        int r = 0;
        while (r < this.datas.length) {
            ProcessData data;
            this.datas[r] = data = new ProcessData();
            int blockSize = (super.getNbBins(r) - 1) * 2;
            data.inLevels = new float[blockSize / 2];
            data.outLevels = new float[blockSize / 2];
            data.fft = BooFFT.getInstance((int)(blockSize / 4));
            data.cepstrum = Cmplx.newArray((int)(blockSize / 4 + 1));
            data.srcSpectrum = Cmplx.newArray((int)this.getNbBins(r));
            data.slopeCoefficients = new float[this.getNbBins(r)];
            double pinkEn = 0.0;
            int i = 0;
            while (i < data.slopeCoefficients.length) {
                double freq = i;
                double pink = 1.0 / Math.pow(freq, 0.5);
                if (Double.isNaN(pink) || Double.isInfinite(pink)) {
                    pink = 1.0;
                }
                pinkEn += pink * pink;
                ++i;
            }
            double pinkCor = Math.sqrt(data.slopeCoefficients.length) / Math.sqrt(pinkEn);
            double slope = -this.spectralSlope / 6.0;
            double energy = 0.0;
            int i2 = 0;
            while (i2 < data.slopeCoefficients.length) {
                double freq = i2;
                double value = slope < 0.0 ? 1.0 / Math.pow(freq, -slope) : Math.pow(freq, slope);
                if (Double.isNaN(value) || Double.isInfinite(value) || value <= 0.0) {
                    value = 1.0;
                }
                data.slopeCoefficients[i2] = (float)value;
                double expected = pinkCor / Math.pow(freq, 0.5);
                if (Double.isNaN(expected) || Double.isInfinite(expected)) {
                    expected = 1.0;
                }
                energy += value * value * expected * expected;
                ++i2;
            }
            float correction = (float)Math.sqrt(Math.sqrt(data.slopeCoefficients.length) / Math.sqrt(energy));
            int i3 = 0;
            while (i3 < data.slopeCoefficients.length) {
                int n = i3++;
                data.slopeCoefficients[n] = data.slopeCoefficients[n] * correction;
            }
            ++r;
        }
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int step) {
        ProcessData data = this.datas[scale % this.datas.length];
        assert (data.srcSpectrum.length == source.length && source.length == spectrum.length);
        int i = 0;
        while (i < source.length) {
            data.srcSpectrum[i].set(source[i]);
            ++i;
        }
        this.applySlope(data, spectrum);
        this.spectralCompanding(data, spectrum);
        this.cepstralCompanding(data, spectrum, scale);
        this.applyInverseSlope(data, spectrum);
    }

    private void applySlope(ProcessData data, Cmplx[] spectrum) {
        int i = 0;
        while (i < spectrum.length) {
            spectrum[i].mul(data.slopeCoefficients[i]);
            data.srcSpectrum[i].mul(data.slopeCoefficients[i]);
            ++i;
        }
    }

    private void applyInverseSlope(ProcessData data, Cmplx[] spectrum) {
        int i = 0;
        while (i < spectrum.length) {
            spectrum[i].mul(1.0f / data.slopeCoefficients[i]);
            data.srcSpectrum[i].mul(1.0f / data.slopeCoefficients[i]);
            ++i;
        }
    }

    private void spectralCompanding(ProcessData data, Cmplx[] spectrum) {
        boolean expand = this.spectralExpansion > 0.0;
        double factorDb = Math.abs(this.spectralExpansion);
        double boost = expand ? AudioMath.dbToLevel((double)(factorDb / 2.25)) : AudioMath.dbToLevel((double)(factorDb / 2.0));
        int i = 1;
        while (i < spectrum.length) {
            Cmplx srcValue = data.srcSpectrum[i];
            Cmplx value = spectrum[i];
            double oldGainDb = AudioMath.powerLevelToDb((double)srcValue.powerMag());
            if (oldGainDb > -100.0) {
                double newGainDb = expand ? oldGainDb - factorDb * -oldGainDb / 100.0 : oldGainDb - factorDb * (oldGainDb + 100.0) / 100.0;
                double ratio = AudioMath.dbToLevel((double)(newGainDb - oldGainDb));
                value.mul((float)(ratio * boost));
                if (srcValue != value) {
                    srcValue.mul((float)(ratio * boost));
                }
            }
            ++i;
        }
    }

    private void cepstralCompanding(ProcessData data, Cmplx[] spectrum, int scale) {
        double BASE = 200.0;
        int i = 0;
        while (i < data.inLevels.length) {
            float pMag = data.srcSpectrum[i + 1].powerMag();
            data.inLevels[i] = (float)Math.log(pMag + 1.0E-8f);
            ++i;
        }
        data.fft.forwR2C(data.inLevels, data.cepstrum);
        float level = 1.0f + (float)(this.cepstralExpansion / 120.0);
        float correction = (float)AudioMath.dbToLevel((double)(-this.cepstralExpansion / 4.0));
        float[] amplifications = new float[]{1.0f, (level + 1.0f) / 2.0f, level, level, level, level, level, level, (level + 1.0f) / 2.0f, 1.0f};
        int nbLevels = amplifications.length;
        int k = 0;
        while (k < nbLevels) {
            double start = (Math.pow(200.0, (double)k / (double)nbLevels) - 1.0) / 199.0;
            double stop = (Math.pow(200.0, (double)(k + 1) / (double)nbLevels) - 1.0) / 199.0;
            int startBin = (int)(start * (double)(data.cepstrum.length - 1) + 0.5);
            int stopBin = (int)(stop * (double)(data.cepstrum.length - 1) + 0.5);
            int i2 = startBin;
            while (i2 < stopBin) {
                data.cepstrum[i2 + 1].mul(amplifications[k]);
                ++i2;
            }
            ++k;
        }
        data.fft.backC2R(data.cepstrum, data.outLevels);
        int i3 = 0;
        while (i3 < data.outLevels.length) {
            data.outLevels[i3] = (float)Math.exp(data.outLevels[i3]) - 1.0E-8f;
            ++i3;
        }
        i3 = 0;
        while (i3 < data.inLevels.length) {
            float pMag;
            data.inLevels[i3] = pMag = data.srcSpectrum[i3 + 1].powerMag();
            ++i3;
        }
        i3 = 0;
        while (i3 < data.outLevels.length) {
            float ratio = (float)Math.sqrt(data.outLevels[i3] / data.inLevels[i3]);
            if (Float.isNaN(ratio)) {
                ratio = 0.0f;
            }
            if (ratio > 10.0f) {
                ratio = 10.0f;
            }
            spectrum[i3 + 1].mul(ratio * correction);
            ++i3;
        }
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.datas = null;
    }

    static class ProcessData {
        float[] slopeCoefficients;
        Cmplx[] srcSpectrum;
        float[] inLevels;
        float[] outLevels;
        BooFFT fft;
        Cmplx[] cepstrum;

        ProcessData() {
        }
    }
}

