/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.rollers;

public class ButterworthEngine {
    private static final float \u03c0 = (float)Math.PI;
    private static final float sqrt2 = (float)Math.sqrt(2.0);
    private final float a1;
    private final float a2;
    private final float a3;
    private final float a4;
    private final float a5;
    private float prev1;
    private float prev2;

    private ButterworthEngine(float a1, float a2, float a3, float a4, float a5) {
        this.a1 = a1;
        this.a2 = a2;
        this.a3 = a3;
        this.a4 = a4;
        this.a5 = a5;
    }

    public void process(float[] in, float[] out) {
        if (in.length != out.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < in.length) {
            float b2 = in[i] - this.a4 * this.prev1 - this.a5 * this.prev2;
            float b3 = b2 * this.a1 + this.a2 * this.prev1 + this.a3 * this.prev2;
            this.prev2 = this.prev1;
            this.prev1 = b2;
            out[i] = b3;
            ++i;
        }
    }

    public void processBand(float[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            float b2 = buffer[i] - this.a4 * this.prev1 - this.a5 * this.prev2;
            float b3 = (b2 - this.prev2) * this.a1;
            this.prev2 = this.prev1;
            this.prev1 = b2;
            buffer[i] = b3;
            ++i;
        }
    }

    public void processReversed(float[] in, float[] out) {
        if (in.length != out.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < in.length) {
            float b2 = in[i] - this.a4 * this.prev1 - this.a5 * this.prev2;
            float b3 = b2 * this.a1 + this.a2 * this.prev1 + this.a3 * this.prev2;
            this.prev2 = this.prev1;
            this.prev1 = b2;
            out[i] = in[i] - b3;
            ++i;
        }
    }

    public float process(float sample) {
        float b2 = sample - this.a4 * this.prev1 - this.a5 * this.prev2;
        float b3 = b2 * this.a1 + this.a2 * this.prev1 + this.a3 * this.prev2;
        this.prev2 = this.prev1;
        this.prev1 = b2;
        return b3;
    }

    public void processWeighted(float[] in, float[] out, float begFactor, float endFactor) {
        assert (in.length == out.length);
        float inc = (endFactor - begFactor) / (float)in.length;
        int i = 0;
        while (i < in.length) {
            float b2 = in[i] - this.a4 * this.prev1 - this.a5 * this.prev2;
            float b3 = b2 * this.a1 + this.a2 * this.prev1 + this.a3 * this.prev2;
            this.prev2 = this.prev1;
            this.prev1 = b2;
            int n = i++;
            out[n] = out[n] + b3 * begFactor;
            begFactor += inc;
        }
    }

    public static ButterworthEngine getLowpassFilter(float sampleRate, float frequency) {
        float b0 = (float)(1.0 / Math.tan((float)Math.PI * frequency / sampleRate));
        float a1 = 1.0f / (1.0f + sqrt2 * b0 + b0 * b0);
        float a2 = a1 + a1;
        float a3 = a1;
        float a4 = 2.0f * (1.0f - b0 * b0) * a1;
        float a5 = (1.0f - sqrt2 * b0 + b0 * b0) * a1;
        ButterworthEngine engine = new ButterworthEngine(a1, a2, a3, a4, a5);
        return engine;
    }

    public static ButterworthEngine getHighpassFilter(float sampleRate, float frequency) {
        float b0 = (float)Math.tan((float)Math.PI * frequency / sampleRate);
        float a1 = 1.0f / (1.0f + sqrt2 * b0 + b0 * b0);
        float a2 = -(a1 + a1);
        float a3 = a1;
        float a4 = 2.0f * (b0 * b0 - 1.0f) * a1;
        float a5 = (1.0f - sqrt2 * b0 + b0 * b0) * a1;
        ButterworthEngine engine = new ButterworthEngine(a1, a2, a3, a4, a5);
        return engine;
    }

    private static ButterworthEngine getBandpassFilter0(float sampleRate, float frequency, float bandWidth) {
        if (bandWidth < 1.0f) {
            bandWidth = 1.0f;
        }
        float b0 = (float)(1.0 / Math.tan((float)Math.PI * bandWidth / sampleRate));
        float b1 = (float)(2.0 * Math.cos(6.2831854820251465 * (double)frequency / (double)sampleRate));
        float a1 = 1.0f / (1.0f + b0);
        float a2 = 0.0f;
        float a3 = -a1;
        float a4 = -b0 * b1 * a1;
        float a5 = (b0 - 1.0f) * a1;
        ButterworthEngine engine = new ButterworthEngine(a1, a2, a3, a4, a5);
        return engine;
    }

    private static ButterworthEngine getBandrejectFilter0(float sampleRate, float frequency, float bandWidth) {
        if (bandWidth < 1.0f) {
            bandWidth = 1.0f;
        }
        float b0 = (float)Math.tan((float)Math.PI * bandWidth / sampleRate);
        float b1 = (float)(2.0 * Math.cos(6.2831854820251465 * (double)frequency / (double)sampleRate));
        float a1 = 1.0f / (1.0f + b0);
        float a2 = -b1 * a1;
        float a3 = a1;
        float a4 = a2;
        float a5 = (1.0f - b0) * a1;
        ButterworthEngine engine = new ButterworthEngine(a1, a2, a3, a4, a5);
        return engine;
    }

    public static ButterworthEngine getBandpassFilter(float sampleRate, float lower, float upper) {
        float center = (float)Math.exp((Math.log(lower) + Math.log(upper)) / 2.0);
        float width = Math.abs(upper - lower);
        return ButterworthEngine.getBandpassFilter0(sampleRate, center, width);
    }

    public static ButterworthEngine getBandrejectFilter(float sampleRate, float lower, float upper) {
        float center = (float)Math.exp((Math.log(lower) + Math.log(upper)) / 2.0);
        float width = Math.abs(upper - lower);
        return ButterworthEngine.getBandrejectFilter0(sampleRate, center, width);
    }

    public void copyHistory(ButterworthEngine other) {
        this.prev1 = other.prev1;
        this.prev2 = other.prev2;
    }

    public void setHistory(float p1, float p2) {
        this.prev1 = p1;
        this.prev2 = p2;
    }
}

