/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.rollers;

import ch.tachyon.sonics.effect.timbre.rollers.FilterEngine;
import ch.tachyon.sonics.effect.timbre.rollers.HilbertEngine;
import org.corebounce.common.math.FastMath;

public class DetuneEngine {
    private static final double MIN_AUDIBLE = 15.0;
    private static final double MAX_AUDIBLE = 22000.0;
    private static final int RESET_COUNTDOWN = 10000;
    private final HilbertEngine hilbert;
    private final double sampleRate;
    private final float[] hilbert1;
    private final float[] hilbert2;
    private final FilterEngine filter;
    private double rate;
    private double angle;
    private double sinAngle;
    private double cosAngle;
    private double sinRate;
    private double cosRate;
    private int countDown;
    private boolean down;

    public DetuneEngine(float sampleRate, int blockSize, int filterStrength) {
        this.hilbert = new HilbertEngine(sampleRate);
        this.sampleRate = sampleRate;
        this.hilbert1 = new float[blockSize];
        this.hilbert2 = new float[blockSize];
        this.filter = new FilterEngine(filterStrength);
        this.countDown = Math.abs(this.hashCode()) % 10000;
    }

    public void setShift(double shift) {
        boolean down;
        boolean bl = down = shift < 0.0;
        if (down != this.down && (this.cosAngle != 0.0 || this.sinAngle != 0.0)) {
            this.angle = Math.atan2(this.cosAngle, this.sinAngle);
        }
        if (down != this.down || this.cosAngle == 0.0 && this.sinAngle == 0.0) {
            if (shift > 0.0) {
                this.filter.initButterworthLow(this.sampleRate, 22000.0 - shift);
            } else {
                this.filter.initButterworthHigh(this.sampleRate, 15.0 - shift);
            }
            this.filter.clearHistory();
        }
        this.down = down;
        this.rate = Math.PI * 2 * Math.abs(shift) / this.sampleRate;
        this.sinAngle = Math.sin(this.angle);
        this.cosAngle = Math.cos(this.angle);
        this.sinRate = Math.sin(this.rate);
        this.cosRate = Math.cos(this.rate);
    }

    public void process(float[] input, float[] output, boolean preFilter) {
        if (input.length != output.length || input.length != this.hilbert1.length) {
            throw new IllegalArgumentException();
        }
        if (preFilter) {
            this.filter.processButter(input, output);
            this.hilbert.process(output, this.hilbert1, this.hilbert2);
        } else {
            this.hilbert.process(input, this.hilbert1, this.hilbert2);
        }
        this.process(this.hilbert1, this.hilbert2, output);
    }

    public void process(float[] hilbert1, float[] hilbert2, float[] output) {
        float[] inp1 = this.down ? hilbert1 : hilbert2;
        float[] inp2 = this.down ? hilbert2 : hilbert1;
        int i = 0;
        while (i < output.length) {
            output[i] = inp1[i] * (float)this.sinAngle + inp2[i] * (float)this.cosAngle;
            this.updateModulators();
            ++i;
        }
    }

    public void processAdd(float[] hilbert1, float[] hilbert2, float[] output) {
        float[] inp1 = this.down ? hilbert1 : hilbert2;
        float[] inp2 = this.down ? hilbert2 : hilbert1;
        int i = 0;
        while (i < hilbert1.length) {
            int n = i;
            output[n] = output[n] + (inp1[i] * (float)this.sinAngle + inp2[i] * (float)this.cosAngle);
            this.updateModulators();
            ++i;
        }
    }

    private void updateModulators() {
        this.angle += this.rate;
        if (this.countDown <= 0) {
            this.angle = FastMath.wrap((double)this.angle);
            this.sinAngle = Math.sin(this.angle);
            this.cosAngle = Math.cos(this.angle);
            this.countDown = 10000;
        } else {
            double nextSin = this.sinAngle * this.cosRate + this.cosAngle * this.sinRate;
            double nextCos = this.cosAngle * this.cosRate - this.sinAngle * this.sinRate;
            this.sinAngle = nextSin;
            this.cosAngle = nextCos;
            --this.countDown;
        }
    }
}

