/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.rollers;

import java.util.Arrays;

public class FilterEngine {
    public static final double DEFAULT_PASS_BAND_RIPPLE = 1.0;
    public static final double DEFAULT_STOP_BAND_ATTENUATION = -60.0;
    public final int nsec;
    public final float[] xnm1;
    public final float[] xnm2;
    public final float[] ynm1;
    public final float[] ynm2;
    public final float[] a0;
    public final float[] a1;
    public final float[] a2;
    public final float[] b0;
    public final float[] b1;
    public final float[] b2;

    public FilterEngine(int nsec) {
        this.nsec = nsec;
        this.xnm1 = new float[nsec];
        this.xnm2 = new float[nsec];
        this.ynm1 = new float[nsec];
        this.ynm2 = new float[nsec];
        this.a0 = new float[nsec];
        this.a1 = new float[nsec];
        this.a2 = new float[nsec];
        this.b0 = new float[nsec];
        this.b1 = new float[nsec];
        this.b2 = new float[nsec];
    }

    public int getNbSections() {
        return this.nsec;
    }

    public void initButterworthLow(double sampleRate, double cutFrequency) {
        float cotfpi = 1.0f / (float)Math.tan(Math.PI * cutFrequency / sampleRate);
        float cotfpi2 = cotfpi * cotfpi;
        int m = 0;
        while (m < this.nsec) {
            this.initButterworthLowSection(cotfpi, cotfpi2, m, m, this.nsec);
            ++m;
        }
    }

    private void initButterworthLowSection(float cotfpi, float cotfpi2, int index, int m, int nsec) {
        float alpha = (float)Math.cos(Math.PI * (((double)m + 0.5) / (2.0 * (double)nsec) + 0.5));
        float beta = (float)Math.sin(Math.PI * (((double)m + 0.5) / (2.0 * (double)nsec) + 0.5));
        this.a0[index] = alpha * alpha + beta * beta + cotfpi * (cotfpi - 2.0f * alpha);
        this.a1[index] = 2.0f * (alpha * alpha + beta * beta - cotfpi2);
        this.a2[index] = alpha * alpha + beta * beta + cotfpi * (cotfpi + 2.0f * alpha);
        this.b0[index] = 1.0f;
        this.b1[index] = 2.0f;
        this.b2[index] = 1.0f;
    }

    public void initButterworthHigh(double sampleRate, double cutFrequency) {
        float tanfpi = (float)Math.tan(Math.PI * cutFrequency / sampleRate);
        float tanfpi2 = tanfpi * tanfpi;
        int m = 0;
        while (m < this.nsec) {
            this.initButterworthHighSection(tanfpi, tanfpi2, m, m, this.nsec);
            ++m;
        }
    }

    private void initButterworthHighSection(float tanfpi, float tanfpi2, int index, int m, int nsec) {
        float alpha = (float)Math.cos(Math.PI * (((double)m + 0.5) / (2.0 * (double)nsec) + 0.5));
        float beta = (float)Math.sin(Math.PI * (((double)m + 0.5) / (2.0 * (double)nsec) + 0.5));
        this.a0[index] = alpha * alpha + beta * beta + tanfpi * (tanfpi - 2.0f * alpha);
        this.a1[index] = 2.0f * (tanfpi2 - (alpha * alpha + beta * beta));
        this.a2[index] = alpha * alpha + beta * beta + tanfpi * (tanfpi + 2.0f * alpha);
        this.b0[index] = 1.0f;
        this.b1[index] = -2.0f;
        this.b2[index] = 1.0f;
    }

    public void initButterworthBand(double sampleRate, double lower, double upper) {
        if (this.nsec % 2 != 0) {
            throw new UnsupportedOperationException("Bandpass only possible with even order");
        }
        if (lower > upper) {
            double temp = lower;
            lower = upper;
            upper = temp;
        }
        float cotfpi = 1.0f / (float)Math.tan(Math.PI * upper / sampleRate);
        float cotfpi2 = cotfpi * cotfpi;
        float tanfpi = (float)Math.tan(Math.PI * lower / sampleRate);
        float tanfpi2 = tanfpi * tanfpi;
        int m = 0;
        while (m < this.nsec / 2) {
            this.initButterworthLowSection(cotfpi, cotfpi2, m * 2 + 0, m, this.nsec / 2);
            this.initButterworthHighSection(tanfpi, tanfpi2, m * 2 + 1, m, this.nsec / 2);
            ++m;
        }
    }

    public void initChebyshev1Low(double sampleRate, double cutFrequency, double passBandRipple) {
        if (passBandRipple < 0.0) {
            throw new IllegalArgumentException("passBandRipple < 0");
        }
        float cotfpi = 1.0f / (float)Math.tan(Math.PI * cutFrequency / sampleRate);
        float cotfpi2 = cotfpi * cotfpi;
        float eps = (float)Math.sqrt(Math.pow(10.0, passBandRipple / 10.0) - 1.0);
        float aleph = (float)(0.5 / (double)this.nsec * Math.log(1.0 / (double)eps + Math.sqrt(1.0 / (double)eps / (double)eps + 1.0)));
        int m = 0;
        while (m < this.nsec) {
            this.initChebyshec1LowSection(cotfpi, cotfpi2, eps, aleph, m, m, this.nsec);
            ++m;
        }
    }

    private void initChebyshec1LowSection(float cotfpi, float cotfpi2, float eps, float aleph, int index, int m, int nsec) {
        float bethe = (float)(Math.PI * (((double)m + 0.5) / (2.0 * (double)nsec) + 0.5));
        float alpha = (float)(Math.sinh(aleph) * Math.cos(bethe));
        float beta = (float)(Math.cosh(aleph) * Math.sin(bethe));
        float gamma = alpha * alpha + beta * beta;
        this.a0[index] = gamma + cotfpi * (cotfpi - 2.0f * alpha);
        this.a1[index] = 2.0f * (gamma - cotfpi2);
        this.a2[index] = gamma + cotfpi * (cotfpi + 2.0f * alpha);
        if (m == 0) {
            this.b0[index] = gamma / (float)Math.sqrt(1.0 + (double)(eps * eps));
            this.b1[index] = gamma * 2.0f / (float)Math.sqrt(1.0 + (double)(eps * eps));
            this.b2[index] = gamma / (float)Math.sqrt(1.0 + (double)(eps * eps));
        } else {
            this.b0[index] = gamma;
            this.b1[index] = gamma * 2.0f;
            this.b2[index] = gamma;
        }
    }

    public void initChebyshev1High(double sampleRate, double cutFrequency, double passBandRipple) {
        if (passBandRipple < 0.0) {
            throw new IllegalArgumentException("passBandRipple < 0");
        }
        float tanfpi = (float)Math.tan(Math.PI * cutFrequency / sampleRate);
        float tanfpi2 = tanfpi * tanfpi;
        float eps = (float)Math.sqrt(Math.pow(10.0, passBandRipple / 10.0) - 1.0);
        float aleph = (float)(0.5 / (double)this.nsec * Math.log(1.0 / (double)eps + Math.sqrt(1.0 / (double)eps / (double)eps + 1.0)));
        int m = 0;
        while (m <= this.nsec - 1) {
            this.initChebyshev1HighSection(tanfpi, tanfpi2, eps, aleph, m, m, this.nsec);
            ++m;
        }
    }

    private void initChebyshev1HighSection(float tanfpi, float tanfpi2, float eps, float aleph, int index, int m, int nsec) {
        float bethe = (float)(Math.PI * (((double)m + 0.5) / (2.0 * (double)nsec) + 0.5));
        float alpha = (float)(Math.sinh(aleph) * Math.cos(bethe));
        float beta = (float)(Math.cosh(aleph) * Math.sin(bethe));
        float gamma = alpha * alpha + beta * beta;
        this.a0[index] = gamma + tanfpi * (tanfpi - 2.0f * alpha);
        this.a1[index] = 2.0f * (tanfpi2 - gamma);
        this.a2[index] = gamma + tanfpi * (tanfpi + 2.0f * alpha);
        if (m == 0) {
            this.b0[index] = gamma / (float)Math.sqrt(1.0 + (double)(eps * eps));
            this.b1[index] = -gamma * 2.0f / (float)Math.sqrt(1.0 + (double)(eps * eps));
            this.b2[index] = gamma / (float)Math.sqrt(1.0 + (double)(eps * eps));
        } else {
            this.b0[index] = gamma;
            this.b1[index] = -gamma * 2.0f;
            this.b2[index] = gamma;
        }
    }

    public void initChebyshev1Band(double sampleRate, double lower, double upper, double passBandRipple) {
        if (this.nsec % 2 != 0) {
            throw new UnsupportedOperationException("Bandpass only possible with even order");
        }
        if (passBandRipple < 0.0) {
            throw new IllegalArgumentException("passBandRipple < 0");
        }
        float cotfpi = 1.0f / (float)Math.tan(Math.PI * upper / sampleRate);
        float cotfpi2 = cotfpi * cotfpi;
        float tanfpi = (float)Math.tan(Math.PI * lower / sampleRate);
        float tanfpi2 = tanfpi * tanfpi;
        float eps = (float)Math.sqrt(Math.pow(10.0, passBandRipple / 10.0) - 1.0);
        float aleph = (float)(1.0 / (double)this.nsec * Math.log(1.0 / (double)eps + Math.sqrt(1.0 / (double)eps / (double)eps + 1.0)));
        int m = 0;
        while (m < this.nsec / 2) {
            this.initChebyshec1LowSection(cotfpi, cotfpi2, eps, aleph, m * 2 + 0, m, this.nsec / 2);
            this.initChebyshev1HighSection(tanfpi, tanfpi2, eps, aleph, m * 2 + 1, m, this.nsec / 2);
            ++m;
        }
    }

    public void initChebyshev2Low(double sampleRate, double cutFrequency, double stopBandAttenuation) {
        if (stopBandAttenuation >= 0.0) {
            throw new IllegalArgumentException("stopBandAttenuation must be negative");
        }
        float tanfpi = (float)Math.tan(Math.PI * cutFrequency / sampleRate);
        float tanfpi2 = tanfpi * tanfpi;
        float eps = (float)Math.sqrt(1.0 / (Math.pow(10.0, -(stopBandAttenuation / 10.0)) - 1.0));
        float aleph = (float)(0.5 / (double)this.nsec * Math.log(1.0 / (double)eps + Math.sqrt(1.0 / (double)eps / (double)eps + 1.0)));
        int m = 0;
        while (m < this.nsec) {
            this.initChebyshev2LowSection(tanfpi, tanfpi2, aleph, m, m, this.nsec);
            ++m;
        }
    }

    private void initChebyshev2LowSection(float tanfpi, float tanfpi2, float aleph, int index, int m, int nsec) {
        float zee = (float)(Math.PI * ((double)m + 0.5) / (2.0 * (double)nsec));
        float bethe = (float)(Math.PI * (((double)m + 0.5) / (2.0 * (double)nsec) + 0.5));
        float alpha = (float)(Math.sinh(aleph) * Math.cos(bethe));
        float beta = (float)(Math.cosh(aleph) * Math.sin(bethe));
        float odelta2 = (float)(Math.cos(zee) * Math.cos(zee));
        float gamma = alpha * alpha + beta * beta;
        this.a0[index] = gamma + tanfpi * (tanfpi - 2.0f * alpha);
        this.a1[index] = 2.0f * (tanfpi2 - gamma);
        this.a2[index] = gamma + tanfpi * (tanfpi + 2.0f * alpha);
        this.b0[index] = odelta2 + tanfpi2;
        this.b1[index] = 2.0f * (tanfpi2 - odelta2);
        this.b2[index] = odelta2 + tanfpi2;
    }

    public void initChebyshev2High(double sampleRate, double cutFrequency, double stopBandAttenuation) {
        if (stopBandAttenuation >= 0.0) {
            throw new IllegalArgumentException("stopBandAttenuation must be negative");
        }
        float cotfpi = 1.0f / (float)Math.tan(Math.PI * cutFrequency / sampleRate);
        float cotfpi2 = cotfpi * cotfpi;
        float eps = (float)Math.sqrt(1.0 / (Math.pow(10.0, -(stopBandAttenuation / 10.0)) - 1.0));
        float aleph = (float)(0.5 / (double)this.nsec * Math.log(1.0 / (double)eps + Math.sqrt(1.0 / (double)eps / (double)eps + 1.0)));
        int m = 0;
        while (m < this.nsec) {
            this.initChebyshev2HighSection(cotfpi, cotfpi2, aleph, m, m, this.nsec);
            ++m;
        }
    }

    private void initChebyshev2HighSection(float cotfpi, float cotfpi2, float aleph, int index, int m, int nsec) {
        float zee = (float)(Math.PI * ((double)m + 0.5) / (2.0 * (double)nsec));
        float bethe = (float)(Math.PI * (((double)m + 0.5) / (2.0 * (double)nsec) + 0.5));
        float alpha = (float)(Math.sinh(aleph) * Math.cos(bethe));
        float beta = (float)(Math.cosh(aleph) * Math.sin(bethe));
        float odelta2 = (float)(Math.cos(zee) * Math.cos(zee));
        float gamma = alpha * alpha + beta * beta;
        this.a0[index] = gamma + cotfpi * (cotfpi - 2.0f * alpha);
        this.a1[index] = 2.0f * (-cotfpi2 + gamma);
        this.a2[index] = gamma + cotfpi * (cotfpi + 2.0f * alpha);
        this.b0[index] = odelta2 + cotfpi2;
        this.b1[index] = 2.0f * (-cotfpi2 + odelta2);
        this.b2[index] = odelta2 + cotfpi2;
    }

    public void initChebyshev2Band(double sampleRate, double lower, double upper, double stopBandAttenuation) {
        if (this.nsec % 2 != 0) {
            throw new UnsupportedOperationException("Bandpass only possible with even order");
        }
        if (stopBandAttenuation >= 0.0) {
            throw new IllegalArgumentException("stopBandAttenuation must be negative");
        }
        float cotfpi = 1.0f / (float)Math.tan(Math.PI * lower / sampleRate);
        float cotfpi2 = cotfpi * cotfpi;
        float tanfpi = (float)Math.tan(Math.PI * upper / sampleRate);
        float tanfpi2 = tanfpi * tanfpi;
        float eps = (float)Math.sqrt(1.0 / (Math.pow(10.0, -(stopBandAttenuation / 10.0)) - 1.0));
        float aleph = (float)(1.0 / (double)this.nsec * Math.log(1.0 / (double)eps + Math.sqrt(1.0 / (double)eps / (double)eps + 1.0)));
        int m = 0;
        while (m < this.nsec / 2) {
            this.initChebyshev2LowSection(tanfpi, tanfpi2, aleph, m * 2 + 0, m, this.nsec / 2);
            this.initChebyshev2HighSection(cotfpi, cotfpi2, aleph, m * 2 + 1, m, this.nsec / 2);
            ++m;
        }
    }

    public void process(float[] input, float[] output) {
        int i = 0;
        while (i < input.length) {
            float in = input[i];
            float out = 0.0f;
            int m = 0;
            while (m < this.nsec) {
                out = (this.b0[m] * in + this.b1[m] * this.xnm1[m] + this.b2[m] * this.xnm2[m] - this.a1[m] * this.ynm1[m] - this.a2[m] * this.ynm2[m]) / this.a0[m];
                this.xnm2[m] = this.xnm1[m];
                this.xnm1[m] = in;
                this.ynm2[m] = this.ynm1[m];
                this.ynm1[m] = out;
                in = out;
                ++m;
            }
            output[i] = out;
            ++i;
        }
    }

    public float process(float value) {
        float out = 0.0f;
        int m = 0;
        while (m < this.nsec) {
            out = (this.b0[m] * value + this.b1[m] * this.xnm1[m] + this.b2[m] * this.xnm2[m] - this.a1[m] * this.ynm1[m] - this.a2[m] * this.ynm2[m]) / this.a0[m];
            this.xnm2[m] = this.xnm1[m];
            this.xnm1[m] = value;
            this.ynm2[m] = this.ynm1[m];
            this.ynm1[m] = out;
            value = out;
            ++m;
        }
        return out;
    }

    public void processButter(float[] input, float[] output) {
        this.processButter(input, output, input.length);
    }

    public void processButter(float[] input, float[] output, int count) {
        int i = 0;
        while (i < count) {
            float in = input[i];
            float out = 0.0f;
            int m = 0;
            while (m < this.nsec) {
                out = (in + this.b1[m] * this.xnm1[m] + this.xnm2[m] - this.a1[m] * this.ynm1[m] - this.a2[m] * this.ynm2[m]) / this.a0[m];
                this.xnm2[m] = this.xnm1[m];
                this.xnm1[m] = in;
                this.ynm2[m] = this.ynm1[m];
                this.ynm1[m] = out;
                in = out;
                ++m;
            }
            output[i] = out;
            ++i;
        }
    }

    public void processReversed(float[] input, float[] output) {
        int i = 0;
        while (i < input.length) {
            float in = input[i];
            float out = 0.0f;
            int m = 0;
            while (m < this.nsec) {
                out = (this.b0[m] * in + this.b1[m] * this.xnm1[m] + this.b2[m] * this.xnm2[m] - this.a1[m] * this.ynm1[m] - this.a2[m] * this.ynm2[m]) / this.a0[m];
                this.xnm2[m] = this.xnm1[m];
                this.xnm1[m] = in;
                this.ynm2[m] = this.ynm1[m];
                this.ynm1[m] = out;
                in = out;
                ++m;
            }
            output[i] = input[i] - out;
            ++i;
        }
    }

    public void copyHistory(FilterEngine source) {
        if (this.nsec != source.nsec) {
            throw new IllegalArgumentException("The number of sections does not match");
        }
        System.arraycopy(source.xnm1, 0, this.xnm1, 0, this.nsec);
        System.arraycopy(source.xnm2, 0, this.xnm2, 0, this.nsec);
        System.arraycopy(source.ynm1, 0, this.ynm1, 0, this.nsec);
        System.arraycopy(source.ynm2, 0, this.ynm2, 0, this.nsec);
    }

    public void clearHistory() {
        Arrays.fill(this.xnm1, 0.0f);
        Arrays.fill(this.xnm2, 0.0f);
        Arrays.fill(this.ynm1, 0.0f);
        Arrays.fill(this.ynm2, 0.0f);
    }

    public void clearDenormal() {
        this.clearDenormal(this.xnm1);
        this.clearDenormal(this.xnm2);
        this.clearDenormal(this.ynm1);
        this.clearDenormal(this.ynm2);
    }

    private void clearDenormal(float[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i] < Float.MIN_NORMAL && values[i] > -1.1754944E-38f) {
                values[i] = 0.0f;
            }
            ++i;
        }
    }
}

