/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.rollers;

public class HilbertEngine {
    private final float[] xbuf = new float[12];
    private final float[] ybuf = new float[12];
    private final float[] coef = new float[12];

    public HilbertEngine(double sampleRate) {
        double[] poles = new double[]{0.3609, 2.7412, 11.1573, 44.7581, 179.6242, 798.4578, 1.2524, 5.5671, 22.3423, 89.6271, 364.7914, 2770.1114};
        int i = 0;
        while (i < 12) {
            double polefreq = poles[i] * 15.0;
            double alpha = Math.PI * 2 * polefreq;
            double beta = (1.0 - alpha * 0.5 / sampleRate) / (1.0 + alpha * 0.5 / sampleRate);
            this.xbuf[i] = 0.0f;
            this.ybuf[i] = 0.0f;
            this.coef[i] = -((float)beta);
            ++i;
        }
    }

    public void process(float[] input, float[] output1, float[] output2) {
        this.process(input, output1, output2, 0, input.length);
    }

    public void process(float[] input, float[] output1, float[] output2, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            float xn1 = input[i];
            float yn1 = 0.0f;
            int j = 0;
            while (j < 6) {
                yn1 = this.coef[j] * (xn1 - this.ybuf[j]) + this.xbuf[j];
                this.xbuf[j] = xn1;
                this.ybuf[j] = yn1;
                xn1 = yn1;
                ++j;
            }
            float xn2 = input[i];
            float yn2 = 0.0f;
            int j2 = 6;
            while (j2 < 12) {
                yn2 = this.coef[j2] * (xn2 - this.ybuf[j2]) + this.xbuf[j2];
                this.xbuf[j2] = xn2;
                this.ybuf[j2] = yn2;
                xn2 = yn2;
                ++j2;
            }
            output1[i] = yn1;
            output2[i] = yn2;
            ++i;
        }
    }
}

