/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.rollers;

import ch.tachyon.sonics.effect.timbre.rollers.ButterworthEngine;

public class RollersFilterBank {
    private final float lower;
    private final float upper;
    private final int size;
    private final ButterworthEngine[][] engines;
    private final float[] lowers;
    private final float[] uppers;
    private final float[] centers;

    public RollersFilterBank(float sampleRate, float lower, float upper, int size, int strength, float minBandWidth) {
        if (lower >= upper) {
            throw new IllegalArgumentException();
        }
        this.lower = lower;
        this.upper = upper;
        this.size = size;
        this.engines = new ButterworthEngine[size][strength];
        this.centers = new float[size];
        this.lowers = new float[size];
        this.uppers = new float[size];
        double logLower = Math.log(lower);
        double logUpper = Math.log(upper);
        double logLast = logLower;
        int i = 0;
        while (i < size) {
            double logStart = logLast;
            double logStop = logLast + (logUpper - logLast) / (double)(size - i);
            double start = Math.exp(logStart);
            double stop = Math.exp(logStop);
            if (stop - start < (double)minBandWidth) {
                stop = start + (double)minBandWidth;
                logStop = Math.log(stop);
            }
            this.centers[i] = (float)Math.exp((logStart + logStop) / 2.0);
            this.lowers[i] = (float)start;
            this.uppers[i] = (float)stop;
            int j = 0;
            while (j < strength) {
                this.engines[i][j] = ButterworthEngine.getBandpassFilter(sampleRate, this.lowers[i], this.uppers[i]);
                ++j;
            }
            logLast = logStop;
            ++i;
        }
    }

    public double getLower() {
        return this.lower;
    }

    public double getUpper() {
        return this.upper;
    }

    public int getSize() {
        return this.size;
    }

    public double getLowerFrequency(int band) {
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException();
        }
        return this.lowers[band];
    }

    public double getCenterFrequency(int band) {
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException();
        }
        return this.centers[band];
    }

    public double getUpperFrequency(int band) {
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException();
        }
        return this.uppers[band];
    }

    public void process(float[] input, float[] output, int band) {
        int i;
        if (input.length != output.length) {
            throw new IllegalArgumentException();
        }
        if (band < 0 || band >= this.size) {
            throw new IllegalArgumentException("'band' must be in the [0..size] range");
        }
        if (input != output) {
            i = 0;
            while (i < input.length) {
                output[i] = input[i];
                ++i;
            }
        }
        i = 0;
        while (i < this.engines[band].length) {
            this.engines[band][i].processBand(output);
            ++i;
        }
    }
}

