/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.texture;

import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.param.Range;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.FastMath;
import org.corebounce.common.math.TwinStatistics;

@Category(value="Timbre")
public class MicroBlur
extends FourierSimpleEffectBase {
    private final int OVERLAP = 16;
    private final int STATS_COUNT = 7;
    private final int BLOCK_SIZE = 1024;
    private float strength;
    private Cmplx[][] history;
    private int index;
    private TwinStatistics stats;

    @Range(minValue=-1.0, maxValue=4.0, defaultValue=1.0)
    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec();
        specs.setBaseResolution(1024);
        specs.setOverlap(16.0f);
        return specs;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.history = Cmplx.newArray((int)7, (int)this.getNbBins());
        this.stats = new TwinStatistics();
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int fi, long clock, int step) {
        int i = 0;
        while (i < spectrum.length) {
            spectrum[i].toPolarApprox();
            ++i;
        }
        i = 0;
        while (i < spectrum.length) {
            this.history[this.index][i].set(spectrum[i]);
            ++i;
        }
        int mid = (this.index - 3 + 7) % 7;
        int start = (mid - 3 + 7) % 7;
        assert (start == (this.index + 1) % 7);
        int i2 = 0;
        while (i2 < spectrum.length) {
            this.stats.reset();
            int k = 0;
            while (k < 7) {
                this.stats.add((double)k, (double)this.history[(start + k) % 7][i2].re);
                ++k;
            }
            int middle = 3;
            assert ((start + middle) % 7 == mid);
            float norm = (float)this.stats.getRegressionY((double)middle);
            float actual = this.history[(start + middle) % 7][i2].re;
            spectrum[i2].re = (float)FastMath.wrap((double)(norm + (actual - norm) * this.strength));
            spectrum[i2].im = this.history[(start + middle) % 7][i2].im;
            ++i2;
        }
        i2 = 0;
        while (i2 < spectrum.length) {
            spectrum[i2].toCartesianApprox();
            ++i2;
        }
        this.index = (this.index + 1) % 7;
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.history = null;
        this.stats = null;
    }
}

