/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.texture;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierLatency;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Unit;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.AverageBuffer;
import org.corebounce.common.math.Cmplx;

@Category(value="Timbre")
public class MicroBlur2
extends FourierSimpleEffectBase
implements IFourierLatency {
    private final int OVERLAP = 16;
    private final int BLOCK_SIZE = 1024;
    private int length;
    private float strength;
    private float postGain;
    private int quality;
    private Cmplx[][][] histories;
    private int[] historyLengths;
    private int[] indexes;
    private AverageBuffer[][] filters;
    private int[] filterLatencies;

    @Range(minValue=0.0, maxValue=10.0, defaultValue=4.0)
    @Order(value=1)
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Order(value=2)
    @Range(minValue=-1.0, maxValue=16.0, defaultValue=4.0)
    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    @Unit(value="dB")
    @Order(value=3)
    @Range(minValue=-3.0, maxValue=2.0, defaultValue=-0.7)
    public float getPostGain() {
        return this.postGain;
    }

    public void setPostGain(float postGain) {
        this.postGain = postGain;
    }

    @Order(value=4)
    @Range(minValue=1.0, maxValue=2.0, defaultValue=2.0)
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec();
        if (this.quality == 1) {
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setBaseResolution(1024);
            specs.setOverlap(16.0f);
            specs.setFourierLatency(this);
        } else {
            specs.setProcessingType(FourierProcessingType.PYRAMIDAL);
            int[] resolutions = new int[]{1024, 512, 256, 128};
            specs.setPyramidResolutions(resolutions);
            specs.setSplitFreqs(new float[]{1250.0f, 3700.0f, 10000.0f});
            specs.setFourierLatency(this);
            specs.setOverlap(16.0f);
        }
        return specs;
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        int length = this.length * 2 + 1;
        int nbRes = this.getNbResolutions();
        this.filters = new AverageBuffer[nbRes][];
        this.filterLatencies = new int[nbRes];
        this.historyLengths = new int[nbRes];
        this.histories = new Cmplx[nbRes][][];
        this.indexes = new int[nbRes];
        int r = 0;
        while (r < nbRes) {
            int nbBins = this.getNbBins(r);
            this.filters[r] = new AverageBuffer[nbBins];
            int i = 0;
            while (i < nbBins) {
                this.filters[r][i] = new AverageBuffer(length);
                ++i;
            }
            this.filterLatencies[r] = (int)(this.filters[r][0].getLatency() + 0.5f);
            this.historyLengths[r] = this.filterLatencies[r] + 1;
            this.histories[r] = Cmplx.newArray((int)this.historyLengths[r], (int)nbBins);
            ++r;
        }
    }

    public int getFourierLatency(int hopSize, int res, int scale) {
        return hopSize * this.length;
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int step) {
        float correction = (float)AudioMath.dbToLevel((double)this.postGain);
        int curIndex = this.indexes[scale];
        Cmplx[][] curHistory = this.histories[scale];
        int curHistoryLength = this.historyLengths[scale];
        AverageBuffer[] curFilter = this.filters[scale];
        Cmplx[] currentFrame = curHistory[curIndex];
        int i = 0;
        while (i < spectrum.length) {
            currentFrame[i].set(spectrum[i]);
            ++i;
        }
        int delayIndex = (curIndex + curHistoryLength - this.filterLatencies[scale]) % curHistoryLength;
        Cmplx[] pastFrame = curHistory[delayIndex];
        int i2 = 0;
        while (i2 < spectrum.length) {
            float dstMag = spectrum[i2].magApprox();
            curFilter[i2].push(dstMag);
            dstMag = curFilter[i2].getAverage();
            Cmplx src = pastFrame[i2];
            float srcMag = src.magApprox();
            dstMag += (srcMag - dstMag) * this.strength;
            spectrum[i2].set(src);
            if (srcMag > Float.MIN_NORMAL) {
                spectrum[i2].mul(dstMag * correction / srcMag);
            }
            ++i2;
        }
        this.indexes[scale] = (curIndex + 1) % curHistoryLength;
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.histories = null;
        this.filters = null;
        this.historyLengths = null;
        this.indexes = null;
        this.filterLatencies = null;
    }
}

