/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.texture;

import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSimpleEffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierLatency;
import ch.tachyon.sonics.effect.timbre.texture.TextureLevelEngine;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Unit;
import org.corebounce.common.math.Cmplx;

@MultiThreading
@Category(value="Timbre")
@Description(value="Amplify or reduce the level of the texture\nTexure consists of spectrogram amplitude variations in the 4ms - 10ms range.")
public class TextureLevel
extends FourierSimpleEffectBase
implements IFourierLatency,
IHasSerialSections {
    private final int OVERLAP = 16;
    private final int BLOCK_SIZE = 512;
    private int length;
    private float strength;
    private float postGain;
    private int quality;
    private TextureLevelEngine engine;

    @Range(minValue=0.0, maxValue=10.0, defaultValue=4.0)
    @Order(value=1)
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Order(value=2)
    @Range(minValue=-1.0, maxValue=16.0, defaultValue=4.0)
    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    @Unit(value="dB")
    @Order(value=3)
    @Range(minValue=-3.0, maxValue=2.0, defaultValue=-1.0)
    public float getPostGain() {
        return this.postGain;
    }

    public void setPostGain(float postGain) {
        this.postGain = postGain;
    }

    @Order(value=4)
    @Range(minValue=1.0, maxValue=2.0, defaultValue=2.0)
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        FourierSpec specs = new FourierSpec();
        if (this.quality == 1) {
            specs.setProcessingType(FourierProcessingType.SIMPLE);
            specs.setBaseResolution(512);
            specs.setOverlap(16.0f);
            specs.setFourierLatency(this);
        } else {
            specs.setProcessingType(FourierProcessingType.PYRAMIDAL);
            int[] resolutions = new int[]{1024, 512};
            specs.setPyramidResolutions(resolutions);
            specs.setSplitFreqs(new float[]{1250.0f});
            specs.setFourierLatency(this);
            specs.setOverlap(16.0f);
        }
        specs.setMinimizeNumHops(true);
        return specs;
    }

    public int getFourierLatency(int hopSize, int res, int scale) {
        return this.engine.getFourierLatency(hopSize, res, scale);
    }

    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        int[] nbBins = new int[this.getNbResolutions()];
        int[] numHops = new int[this.getNbResolutions()];
        int i = 0;
        while (i < this.getNbResolutions()) {
            nbBins[i] = super.getNbBins(i);
            numHops[i] = super.getNumHops(i);
            ++i;
        }
        this.engine = new TextureLevelEngine(this.length, new float[]{this.strength, this.strength}, this.postGain, nbBins, numHops, new float[]{1250.0f, 3700.0f});
        this.engine.setup(info.getSampleRate());
    }

    public void process(int res, int scale, Cmplx[] source, Cmplx[] spectrum, int k, long clock, int step) {
        this.engine.analyze(res, source, 0);
        this.engine.analyzeFinished();
        this.engine.process(res, spectrum, 0);
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.engine.stopProcessing();
        this.engine = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        super.createSerialSections(factory);
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        super.setSerialSections(pool);
        this.engine.setSerialSections(pool);
    }
}

