/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.texture;

import ch.tachyon.sonics.effect.base.fourier.IFourierLatency;
import ch.tachyon.sonics.effect.timbre.texture.TextureLevel;
import ch.tachyon.sonics.effect.utils.CmplxConcurrentDelayBuffer;
import ch.tachyon.sonics.effect.utils.ConcurrentAverageBuffer;
import ch.tachyon.sonics.effect.utils.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

public class TextureLevelEngine
implements IHasSerialSections,
IFourierLatency {
    private final String SERIAL_SECTION_NAME = TextureLevel.class.getName();
    private final int length;
    private final float[] strengths;
    private final float postGain;
    private final int[] nbBins;
    private final int[] numHops;
    private final float[] splitFreqs;
    private int[] minBin;
    private int[] maxBin;
    private CmplxConcurrentDelayBuffer[] frameDelayers;
    private ConcurrentDelayBuffer[][] magnitudeDelayers;
    private ConcurrentAverageBuffer[][] filters;
    private ISerialSection ss = new DummySerialSection();
    private transient long ssClock;

    public TextureLevelEngine(int length, float[] strengths, float postGain, int[] nbBins, int[] numHops, float[] splitFreqs) {
        this.length = length;
        this.strengths = strengths;
        this.postGain = postGain;
        this.nbBins = nbBins;
        this.numHops = numHops;
        this.splitFreqs = splitFreqs;
    }

    public int getFourierLatency(int hopSize, int res, int scale) {
        return hopSize * this.length;
    }

    public void setup(float sampleRate) {
        int nbScales = this.nbBins.length;
        this.minBin = new int[nbScales];
        this.maxBin = new int[nbScales];
        int i = 0;
        while (i < nbScales) {
            if (i > 0) {
                this.minBin[i] = (int)(this.splitFreqs[i - 1] * (float)((this.nbBins[i] - 1) * 2) / sampleRate + 0.5f);
            } else {
                this.minBin[0] = 2;
            }
            this.maxBin[i] = (int)(this.splitFreqs[i] * (float)((this.nbBins[i] - 1) * 2) / sampleRate + 0.5f);
            ++i;
        }
    }

    public void analyze(int layer, Cmplx[] source, int k) {
        ConcurrentDelayBuffer[] magnitudeDelayer = this.magnitudeDelayers[layer];
        ConcurrentAverageBuffer[] curFilter = this.filters[layer];
        this.ssClock = this.ss.getClock();
        long clock = this.ssClock * (long)this.numHops[layer] + (long)k;
        this.frameDelayers[layer].push(source, clock);
        int i = 0;
        while (i < source.length) {
            if (i >= this.minBin[layer] && i < this.maxBin[layer]) {
                magnitudeDelayer[i].push(source[i].magApprox(), clock);
                float dstMag = source[i].magApprox();
                curFilter[i].push(dstMag, clock);
            }
            ++i;
        }
    }

    public long getClock() {
        return this.ss.getClock();
    }

    public void analyzeFinished() {
        this.ss.sync();
    }

    public void process(int layer, Cmplx[] spectrum, int k) {
        float correction = (float)AudioMath.dbToLevel((double)this.postGain);
        ConcurrentAverageBuffer[] curFilter = this.filters[layer];
        CmplxConcurrentDelayBuffer frameDelayer = this.frameDelayers[layer];
        ConcurrentDelayBuffer[] magnitudeDelayer = this.magnitudeDelayers[layer];
        long clock = this.ssClock * (long)this.numHops[layer] + (long)k;
        Cmplx[] sources = frameDelayer.pop(clock);
        int i = 0;
        while (i < spectrum.length) {
            if (i >= this.minBin[layer] && i < this.maxBin[layer]) {
                float dstMag = curFilter[i].getAverage(clock);
                Cmplx src = sources[i];
                float srcMag = magnitudeDelayer[i].pop(clock);
                dstMag += (srcMag - dstMag) * this.strengths[layer];
                if (srcMag > Float.MIN_NORMAL) {
                    float mul = dstMag * correction / srcMag;
                    spectrum[i].set(src.re * mul, src.im * mul);
                } else {
                    spectrum[i].set(src);
                }
            } else {
                spectrum[i].set(sources[i]);
            }
            ++i;
        }
    }

    public void stopProcessing() {
        ConcurrentAverageBuffer[][] concurrentAverageBufferArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            ConcurrentAverageBuffer[] filterArr;
            ConcurrentAverageBuffer[] concurrentAverageBufferArray2 = filterArr = concurrentAverageBufferArray[n2];
            int n3 = filterArr.length;
            int n4 = 0;
            while (n4 < n3) {
                ConcurrentAverageBuffer filter = concurrentAverageBufferArray2[n4];
                if (filter != null) {
                    filter.dispose();
                }
                ++n4;
            }
            ++n2;
        }
        this.frameDelayers = null;
        this.magnitudeDelayers = null;
        this.filters = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        if (this.nbBins.length != this.numHops.length) {
            throw new IllegalArgumentException();
        }
        int nbRes = this.nbBins.length;
        this.filters = new ConcurrentAverageBuffer[nbRes][];
        this.frameDelayers = new CmplxConcurrentDelayBuffer[nbRes];
        this.magnitudeDelayers = new ConcurrentDelayBuffer[nbRes][];
        int r = 0;
        while (r < nbRes) {
            int nbBin = this.nbBins[r];
            int numHop = this.numHops[r];
            this.filters[r] = new ConcurrentAverageBuffer[nbBin];
            this.magnitudeDelayers[r] = new ConcurrentDelayBuffer[nbBin];
            int delay = this.length;
            this.frameDelayers[r] = new CmplxConcurrentDelayBuffer(delay, delay + factory.getMtContext().getSerialRunningMaxSkew() * numHop, nbBin);
            int i = 0;
            while (i < nbBin) {
                if (i >= this.minBin[r] && i < this.maxBin[r]) {
                    this.magnitudeDelayers[r][i] = new ConcurrentDelayBuffer(delay, delay + factory.getMtContext().getSerialRunningMaxSkew() * numHop, 1);
                    int avgLength = this.length * 2 + 1;
                    this.filters[r][i] = new ConcurrentAverageBuffer(avgLength, avgLength + factory.getMtContext().getSerialRunningMaxSkew() * numHop);
                }
                ++i;
            }
            ++r;
        }
        this.ss = factory.createSerialSection(this.SERIAL_SECTION_NAME, (Object)new Object[]{this.frameDelayers, this.magnitudeDelayers, this.filters});
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.ss = pool.getSerialSection(this.SERIAL_SECTION_NAME);
        Object[] userData = (Object[])this.ss.getUserData();
        this.frameDelayers = (CmplxConcurrentDelayBuffer[])userData[0];
        this.magnitudeDelayers = (ConcurrentDelayBuffer[][])userData[1];
        this.filters = (ConcurrentAverageBuffer[][])userData[2];
    }
}

