/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.texture;

import ch.tachyon.sonics.effect.timbre.texture.TextureLevelTimeEngine;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Unit;

@MultiThreading
@Category(value="Timbre")
public class TextureLevelTime
implements ISimpleEffect,
IStartStop,
IBeginProcessing,
IHasSerialSections,
IFixedChunkLength,
ILatency {
    private final int OVERLAP = 16;
    private final int BLOCK_SIZE = 256;
    private int length;
    private float strength;
    private float postGain;
    private int quality;
    private TextureLevelTimeEngine engine;

    @Range(minValue=0.0, maxValue=10.0, defaultValue=4.0)
    @Order(value=1)
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Order(value=2)
    @Range(minValue=-1.0, maxValue=16.0, defaultValue=4.0)
    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    @Unit(value="dB")
    @Order(value=3)
    @Range(minValue=-3.0, maxValue=2.0, defaultValue=-1.0)
    public float getPostGain() {
        return this.postGain;
    }

    public void setPostGain(float postGain) {
        this.postGain = postGain;
    }

    @Order(value=4)
    @Range(minValue=1.0, maxValue=2.0, defaultValue=2.0)
    public int getQuality() {
        return this.quality;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public int getFixedChunkLength() {
        return 256;
    }

    public void startProcessing(IProcessingInfo info) {
        this.engine = new TextureLevelTimeEngine(16, 256, this.length, new float[]{this.strength, this.strength}, this.postGain, new int[]{1024, 512}, new float[]{1250.0f}, info.getSampleRate());
    }

    public int getLatency(IoDirection ioDirection) {
        return this.engine.getLatency();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.engine.init();
    }

    public void process(float[] data) {
        this.engine.process(data);
    }

    public void stopProcessing() {
        this.engine = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engine.setSerialSections(pool);
    }
}

