/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.timbre.texture;

import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.sonics.effect.timbre.texture.TextureLevelEngine;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public class TextureLevelTimeEngine
implements IHasSerialSections {
    private static final float MAX_FREQUENCY = 2050.0f;
    private final int[] resolutions;
    private final float[] splitFreqs;
    private final float sampleRate;
    private TextureLevelEngine engine;
    private PyramidAnalyzer analyzer;
    private PyramidSynthesizer synthesizer;

    public TextureLevelTimeEngine(int overlap, int blockSize, int length, float[] strengths, float postGain, int[] resolutions, float[] splitFreqs, float sampleRate) {
        this.resolutions = resolutions;
        this.splitFreqs = splitFreqs;
        this.sampleRate = sampleRate;
        float[] window = WindowsFactory.getHannWindow(resolutions[0]);
        this.analyzer = new PyramidAnalyzer("Texture", resolutions, blockSize, overlap, window);
        this.synthesizer = new PyramidSynthesizer("Texture", resolutions, blockSize, overlap, window, window, null, 1.0f, false, 1.0f);
        int[] nbBins = new int[resolutions.length];
        int[] numHops = new int[resolutions.length];
        int i = 0;
        while (i < resolutions.length) {
            nbBins[i] = resolutions[i] / 2 + 1;
            numHops[i] = this.analyzer.getNumHops(i);
            ++i;
        }
        float[] sf = new float[splitFreqs.length + 1];
        System.arraycopy(splitFreqs, 0, sf, 0, splitFreqs.length);
        sf[sf.length - 1] = 2050.0f;
        this.engine = new TextureLevelEngine(length, strengths, postGain, nbBins, numHops, sf);
        this.engine.setup(sampleRate);
        this.synthesizer.setFourierLatency(this.engine);
    }

    public void init() {
        this.analyzer.init();
        this.synthesizer.init();
    }

    public long getClock() {
        return this.engine.getClock();
    }

    public void process(float[] data) {
        int k;
        Cmplx[][][] spectrums = this.analyzer.analyzeInEachRes(data);
        this.splitFrequencies(spectrums);
        int r = 0;
        while (r < spectrums.length) {
            Cmplx[][] srcFrames = spectrums[r];
            k = 0;
            while (k < srcFrames.length) {
                this.engine.analyze(r, srcFrames[k], k);
                ++k;
            }
            ++r;
        }
        this.engine.analyzeFinished();
        r = 0;
        while (r < spectrums.length) {
            Cmplx[][] dstFrames = spectrums[r];
            k = 0;
            while (k < dstFrames.length) {
                this.engine.process(r, dstFrames[k], k);
                ++k;
            }
            ++r;
        }
        this.synthesizer.synthesize(spectrums, data);
    }

    private void splitFrequencies(Cmplx[][][] spectrums) {
        int r = 0;
        while (r < spectrums.length) {
            int hihBin;
            float lowFreq = r == 0 ? 0.0f : this.splitFreqs[r - 1];
            float hihFreq = r >= this.splitFreqs.length ? this.sampleRate / 2.0f : this.splitFreqs[r];
            float lowR = lowFreq / this.sampleRate;
            float hihR = hihFreq / this.sampleRate;
            int res = this.resolutions[r];
            int lowBin = this.cut2bin(res, lowR);
            if (r < this.resolutions.length - 1) {
                hihBin = this.cut2bin(this.resolutions[r + 1], hihR);
                hihBin = hihBin * this.resolutions[r] / this.resolutions[r + 1];
            } else {
                hihBin = this.resolutions[r] / 2 + 1;
            }
            int k = 0;
            while (k < spectrums[r].length) {
                Cmplx[] spectrum = spectrums[r][k];
                int i = 0;
                while (i < spectrum.length) {
                    if (i < lowBin || i >= hihBin) {
                        spectrum[i].set(0.0f, 0.0f);
                    } else if (i == lowBin && i != 0) {
                        spectrum[i].set(spectrum[i].re * 0.8f, spectrum[i].im * 0.8f);
                    }
                    ++i;
                }
                ++k;
            }
            ++r;
        }
    }

    private int cut2bin(int fftSize, float freq) {
        int nbBins = fftSize / 2 + 1;
        int result = (int)(freq * (float)fftSize + 0.5f);
        if (result < 0) {
            result = 0;
        } else if (result >= nbBins) {
            result = nbBins - 1;
        }
        return result;
    }

    public int getLatency() {
        return this.synthesizer.getLatency();
    }

    public void stopProcessing() {
        this.analyzer = null;
        this.synthesizer = null;
        this.engine.stopProcessing();
        this.engine = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
        this.engine.setSerialSections(pool);
    }
}

