/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.Out;

public class BitSetMedianBuffer {
    private final int nbBins;
    private final int width;
    private final int height;
    private final int lowValue;
    private final int highValue;
    private final int[] counts;
    private final BitSet[] history;
    private final Cmplx[][] spectrums;
    private final BitSet result = new BitSet();
    private int index;

    public BitSetMedianBuffer(int nbBins, int width, int height, int lowValue, int highValue) {
        this.width = width;
        this.height = height;
        this.nbBins = nbBins;
        this.lowValue = lowValue;
        this.highValue = highValue;
        this.counts = new int[nbBins];
        this.history = new BitSet[width];
        int i = 0;
        while (i < this.history.length) {
            this.history[i] = new BitSet();
            ++i;
        }
        this.spectrums = Cmplx.newArray((int)width, (int)nbBins);
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void push(BitSet values, Cmplx[] spectrum) {
        BitSet oldest = this.history[this.index];
        int i = 0;
        while (i < this.nbBins) {
            if (oldest.get(i)) {
                int n = i;
                this.counts[n] = this.counts[n] - 1;
            }
            ++i;
        }
        this.history[this.index] = values;
        i = 0;
        while (i < this.nbBins) {
            if (values.get(i)) {
                int n = i;
                this.counts[n] = this.counts[n] + 1;
            }
            this.spectrums[this.index][i].set(spectrum[i]);
            ++i;
        }
        this.index = (this.index + 1) % this.width;
    }

    public BitSet pop(@Out Cmplx[] spectrum) {
        int middleIndex = (this.index + this.width / 2 + 1) % this.width;
        Cmplx[] middleSpectrum = this.spectrums[middleIndex];
        BitSet middleSet = this.history[middleIndex];
        int curCount = 0;
        int offset = this.height / 2;
        int k = 0;
        while (k < offset) {
            curCount += this.counts[k];
            ++k;
        }
        int i = 0;
        while (i < this.nbBins) {
            if (i + offset < this.nbBins) {
                curCount += this.counts[i + offset];
            }
            assert (this.counts[i] >= 0 && this.counts[i] <= this.width);
            if (curCount < this.lowValue) {
                this.result.set(i, false);
            } else if (curCount > this.highValue) {
                this.result.set(i, true);
            } else {
                this.result.set(i, middleSet.get(i));
            }
            spectrum[i].set(middleSpectrum[i]);
            if (i - offset >= 0) {
                curCount -= this.counts[i - offset];
            }
            ++i;
        }
        return this.result;
    }
}

