/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import org.corebounce.common.math.Cmplx;

public class CmplxConcurrentDelayBuffer {
    private final int delay;
    private final int capacity;
    private final int nbBins;
    private final Cmplx[][] buffer;

    public CmplxConcurrentDelayBuffer(int delay, int capacity, int nbBins) {
        this.delay = delay;
        this.capacity = capacity;
        this.nbBins = nbBins;
        this.buffer = Cmplx.newArray((int)capacity, (int)nbBins);
    }

    public void push(Cmplx[] values, long clock) {
        int index = (int)((clock + (long)this.delay) % (long)this.capacity);
        Cmplx[] frame = this.buffer[index];
        int i = 0;
        while (i < this.nbBins) {
            frame[i].set(values[i]);
            ++i;
        }
    }

    public Cmplx[] pop(long clock) {
        int index = (int)(clock % (long)this.capacity);
        return this.buffer[index];
    }

    public int getDelay() {
        return this.delay;
    }

    public int getCapacity() {
        return this.capacity;
    }
}

